/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.cfg;

import com.caucho.amber.cfg.AbstractConfig;
import com.caucho.amber.cfg.CollectionTableConfig;
import com.caucho.amber.cfg.JoinColumnConfig;
import com.caucho.amber.field.ElementCollectionField;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.EntityType;
import com.caucho.bytecode.JType;
import com.caucho.bytecode.JTypeWrapper;
import com.caucho.util.L10N;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.persistence.CollectionTable;
import javax.persistence.ElementCollection;
import javax.persistence.FetchType;

class ElementCollectionConfig
extends AbstractConfig {
    private static final L10N L = new L10N(ElementCollectionConfig.class);
    private EntityType _sourceType;
    private AccessibleObject _field;
    private String _fieldName;
    private Class _fieldType;
    private Class _targetClass;
    private FetchType _fetch = FetchType.EAGER;
    private CollectionTableConfig _collectionTable;

    ElementCollectionConfig(EntityType sourceType, AccessibleObject field, String fieldName, Class fieldType) {
        this._sourceType = sourceType;
        this._field = field;
        this._fieldName = fieldName;
        this._fieldType = fieldType;
        this.setFetch(FetchType.LAZY);
        this.introspect();
    }

    public Class getTargetClass() {
        return this._targetClass;
    }

    public void setTargetClass(Class targetClass) {
        this._targetClass = targetClass;
    }

    public FetchType getFetch() {
        return this._fetch;
    }

    public void setFetch(FetchType fetch) {
        this._fetch = fetch;
    }

    public boolean isFetchLazy() {
        return this._fetch == FetchType.LAZY;
    }

    private void introspect() {
        CollectionTable collectionTableAnn;
        this.introspectTypes();
        ElementCollection elementCollectionAnn = this._field.getAnnotation(ElementCollection.class);
        if (elementCollectionAnn != null) {
            this.introspectElementCollection(elementCollectionAnn);
        }
        this._collectionTable = (collectionTableAnn = this._field.getAnnotation(CollectionTable.class)) != null ? new CollectionTableConfig(collectionTableAnn) : new CollectionTableConfig(this.getRelatedType().getName(), this._fieldName);
    }

    private void introspectTypes() {
        ClassLoader loader;
        Type retType = this._field instanceof Field ? ((Field)this._field).getGenericType() : ((Method)this._field).getGenericReturnType();
        JType type = JTypeWrapper.create(retType, loader = this._sourceType.getPersistenceUnit().getTempClassLoader());
        JType[] typeArgs = type.getActualTypeArguments();
        if (typeArgs.length > 0) {
            this.setTargetClass(typeArgs[0].getRawType().getJavaClass());
        }
    }

    private void introspectElementCollection(ElementCollection eltCollection) {
        Class targetClass = eltCollection.targetClass();
        if (!Void.TYPE.equals(targetClass)) {
            this.setTargetClass(targetClass);
        }
        this.setFetch(eltCollection.fetch());
    }

    public EntityType getRelatedType() {
        return this._sourceType;
    }

    public void complete() {
        AmberPersistenceUnit persistenceUnit = this._sourceType.getPersistenceUnit();
        Class targetClass = this.getTargetClass();
        if (targetClass == null || Void.TYPE.equals(targetClass)) {
            throw ElementCollectionConfig.error(this._field, L.l("Can't determine targetEntity for {0}.  @OneToMany properties must target @Entity beans.", this._fieldName));
        }
        AmberType targetType = persistenceUnit.createType(targetClass);
        if (targetType == null) {
            throw ElementCollectionConfig.error(this._field, L.l("targetClass '{0}' is not a known element collection class for {1}.  The targetClass of a @ElementCollection must be a basic class.", (Object)targetClass.getName(), this._fieldName));
        }
        this.addCollection(targetType);
    }

    private void addCollection(AmberType targetType) {
        ElementCollectionField eltCollectionField = new ElementCollectionField(this._sourceType, this._fieldName);
        eltCollectionField.setType(targetType);
        eltCollectionField.setLazy(this.isFetchLazy());
        CollectionTableConfig collectionTableConfig = this._collectionTable;
        AmberPersistenceUnit persistenceUnit = this._sourceType.getPersistenceUnit();
        String sqlTable = collectionTableConfig.getName();
        AmberTable mapTable = persistenceUnit.createTable(sqlTable);
        HashMap<String, JoinColumnConfig> joinColumnsConfig = collectionTableConfig.getJoinColumnMap();
        ArrayList<ForeignColumn> sourceColumns = null;
        sourceColumns = this.calculateColumns(this._field, this._fieldName, mapTable, this._sourceType.getTable().getName() + "_", this._sourceType, joinColumnsConfig);
        eltCollectionField.setAssociationTable(mapTable);
        eltCollectionField.setTable(sqlTable);
        eltCollectionField.setSourceLink(new LinkColumns(mapTable, this._sourceType.getTable(), sourceColumns));
        this._sourceType.addField(eltCollectionField);
    }
}

