/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.collection;

import com.caucho.amber.AmberQuery;
import com.caucho.amber.AmberRuntimeException;
import com.caucho.amber.collection.AmberCollection;
import com.caucho.amber.manager.AmberConnection;
import com.caucho.amber.query.UserQuery;
import com.caucho.util.Alarm;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapImpl<K, V>
extends AbstractMap<K, V>
implements AmberCollection {
    private AmberQuery _query;
    private AmberConnection _aConn;
    private HashMap<K, V> _values = new HashMap();
    private long _expireTime;
    private Method _methodGetMapKey;

    public MapImpl(AmberConnection aConn, String query, Method methodGetMapKey) {
        this._aConn = aConn;
        this._methodGetMapKey = methodGetMapKey;
        if (query != null) {
            try {
                this._query = this._aConn.prepareQuery(query);
            }
            catch (SQLException e) {
                throw new AmberRuntimeException(e);
            }
        }
    }

    public MapImpl(AmberQuery query, Method methodGetMapKey) {
        this._query = query;
        this._methodGetMapKey = methodGetMapKey;
        if (this._query != null) {
            this.setSession(((UserQuery)this._query).getConnection());
        }
    }

    public void setSession(AmberConnection aConn) {
        this._aConn = aConn;
        if (aConn != null) {
            this._aConn.register(this);
        }
    }

    public AmberConnection getSession() {
        return this._aConn;
    }

    public AmberQuery getQuery() {
        return this._query;
    }

    @Override
    public int size() {
        this.fill();
        return this._values.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.fill();
        return this._values.entrySet();
    }

    @Override
    public V get(Object key) {
        this.fill();
        return this._values.get(key);
    }

    @Override
    public Set<K> keySet() {
        this.fill();
        return this._values.keySet();
    }

    @Override
    public void clear() {
        this._values.clear();
        this._expireTime = Alarm.getCurrentTime();
    }

    @Override
    public void update() {
        this._expireTime = 0L;
    }

    public void detach() {
        this._aConn = null;
        this._query = null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.fill();
        this._values.putAll(map);
    }

    protected boolean isValid() {
        return Alarm.getCurrentTime() <= this._expireTime;
    }

    private void fill() {
        if (this._query == null) {
            return;
        }
        if (this._aConn == null) {
            return;
        }
        if (Alarm.getCurrentTime() <= this._expireTime) {
            return;
        }
        try {
            this._expireTime = Alarm.getCurrentTime();
            ((UserQuery)this._query).setSession(this._aConn);
            this._values.clear();
            this._query.list(this._values, this._methodGetMapKey);
        }
        catch (Exception e) {
            throw new AmberRuntimeException(e);
        }
    }
}

