/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.expr;

import com.caucho.amber.expr.AbstractAmberExpr;
import com.caucho.amber.expr.EmbeddedExpr;
import com.caucho.amber.expr.LoadEmbeddedExpr;
import com.caucho.amber.expr.LoadEntityExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.BeanType;
import com.caucho.amber.type.EmbeddableType;
import com.caucho.amber.type.EntityType;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;

public abstract class LoadExpr
extends AbstractAmberExpr {
    PathExpr _expr;
    FromItem _fromItem;
    FromItem _rootItem;
    int _index;
    ArrayList<FromItem> _subItems = new ArrayList();

    public static LoadExpr create(PathExpr expr) {
        if (expr instanceof EmbeddedExpr) {
            return new LoadEmbeddedExpr(expr);
        }
        return new LoadEntityExpr(expr);
    }

    public static LoadExpr create(PathExpr expr, FromItem rootItem) {
        LoadExpr loadExpr = expr.createLoad();
        loadExpr._rootItem = rootItem;
        return loadExpr;
    }

    LoadExpr(PathExpr expr) {
        this._expr = expr;
    }

    public AmberType getType() {
        return this._expr.getTargetType();
    }

    public PathExpr getExpr() {
        return this._expr;
    }

    public int getIndex() {
        return this._index;
    }

    public String getTable() {
        return this._fromItem.getName();
    }

    public FromItem bindSubPath(QueryParser parser) {
        throw new UnsupportedOperationException();
    }

    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        if (this._fromItem == from) {
            return true;
        }
        for (int i = 0; i < this._subItems.size(); ++i) {
            FromItem subItem = this._subItems.get(i);
            if (from != subItem) continue;
            return true;
        }
        return this._expr.usesFrom(from, type, isNot);
    }

    public FromItem getChildFromItem() {
        return this._expr.getChildFromItem();
    }

    public void generateSelect(CharBuffer cb) {
        this.generateSelect(cb, true);
    }

    public void generateSelect(CharBuffer cb, boolean fullSelect) {
        BeanType type = (BeanType)this.getType();
        if (type instanceof EmbeddableType) {
            this._expr.generateSelect(cb);
            return;
        }
        if (type instanceof EntityType) {
            EntityType relatedType = (EntityType)type;
            cb.append(relatedType.getId().generateSelect(this.getTable()));
        }
        if (!fullSelect) {
            return;
        }
        FromItem item = this._fromItem;
        if (this._rootItem != null) {
            EntityType parentType = (EntityType)type;
            while (parentType.getParentType() != null && parentType.getParentType() instanceof EntityType) {
                parentType = parentType.getParentType();
            }
            item = this._rootItem;
        }
        String valueSelect = "";
        valueSelect = type.generateLoadSelect(item.getTable(), item.getName());
        if (valueSelect != null && !"".equals(valueSelect)) {
            cb.append(", ");
            cb.append(valueSelect);
        }
        for (int i = 0; i < this._subItems.size(); ++i) {
            item = this._subItems.get(i);
            valueSelect = type.generateLoadSelect(item.getTable(), item.getName());
            if (valueSelect.equals("")) continue;
            cb.append(", ");
            cb.append(valueSelect);
        }
    }

    public void generateWhere(CharBuffer cb, String fieldName) {
        throw new UnsupportedOperationException();
    }

    public void generateUpdateWhere(CharBuffer cb, String fieldName) {
        this.generateWhere(cb, fieldName);
    }

    public void generateHaving(CharBuffer cb, String fieldName) {
        this.generateWhere(cb, fieldName);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._expr + "," + this.getType() + "]";
    }
}

