/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.KeyColumnExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.IdField;
import com.caucho.amber.field.PropertyField;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.AmberColumn;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.BeanType;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyPropertyField
extends PropertyField
implements IdField {
    private static final L10N L = new L10N(KeyPropertyField.class);
    private static final Logger log = Logger.getLogger(KeyPropertyField.class.getName());
    private AmberColumn _column;
    private boolean _isKeyField;
    private String _generator;

    public KeyPropertyField(EntityType tableType) {
        super(tableType);
    }

    public KeyPropertyField(EntityType tableType, String name) throws ConfigException {
        super(tableType, name);
    }

    public KeyPropertyField(EntityType entityType, String name, AmberColumn column) throws ConfigException {
        super(entityType, name);
        this._column = column;
        this._column.setPrimaryKey(true);
    }

    @Override
    public boolean isKey() {
        return true;
    }

    public boolean isKeyField() {
        return this._isKeyField;
    }

    @Override
    public void setKeyField(boolean isKeyField) {
        this._isKeyField = isKeyField;
    }

    public void setGenerator(String generator) {
        this._generator = generator;
        if (this._column != null) {
            this._column.setGeneratorType(generator);
        }
    }

    @Override
    public String getGenerator() {
        return this._generator;
    }

    @Override
    public boolean isAutoGenerate() {
        return this._generator != null;
    }

    @Override
    public void setColumn(AmberColumn column) {
        this._column = column;
        this._column.setPrimaryKey(true);
    }

    @Override
    public AmberColumn getColumn() {
        return this._column;
    }

    @Override
    public ArrayList<AmberColumn> getColumns() {
        ArrayList<AmberColumn> columns = new ArrayList<AmberColumn>();
        columns.add(this._column);
        return columns;
    }

    @Override
    public int getComponentCount() {
        return 1;
    }

    @Override
    public AmberType getType() {
        return this._column.getType();
    }

    @Override
    public String getForeignTypeName() {
        if (this._column == null) {
            return "";
        }
        return this._column.getType().getForeignTypeName();
    }

    @Override
    public void generatePrologue(JavaWriter out, HashSet<Object> completedSet) throws IOException {
        super.generatePrologue(out, completedSet);
    }

    @Override
    public String generateGet(String objThis) {
        if (objThis == null) {
            return this.generateNull();
        }
        if ("super".equals(objThis)) {
            return this.generateSuperGetter("this");
        }
        return this.generateSuperGetter(objThis);
    }

    @Override
    public String generateSet(String objThis, String value) {
        if ("super".equals(objThis)) {
            objThis = "this";
        }
        if (this.isFieldAccess()) {
            return this.generateSuperSetter(objThis, value);
        }
        return objThis + "." + this.getSetterName() + "(" + value + ")";
    }

    @Override
    public void generateMergeFrom(JavaWriter out, String dst, String src) throws IOException {
    }

    @Override
    public void generateCopy(JavaWriter out, String dest, String source) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public AmberField override(BeanType type) {
        KeyPropertyField field = new KeyPropertyField((EntityType)this.getSourceType(), this.getName());
        field.setOverride(true);
        field.setLazy(this.isLazy());
        field.setInsert(this.isInsert());
        field.setUpdate(this.isUpdate());
        return field;
    }

    @Override
    public String generateSelect(String id) {
        return this._column.generateSelect(id);
    }

    @Override
    public String generateJavaSelect(String id) {
        String select = this.getName();
        if (id != null) {
            select = id + "." + select;
        }
        return select;
    }

    @Override
    public String generateMatchArgWhere(String id) {
        return this._column.generateMatchArgWhere(id);
    }

    @Override
    public String generateRawWhere(String id) {
        return id + "." + this.getName() + "=?";
    }

    @Override
    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        return this.generateLoadForeign(out, rs, indexVar, index, this.getForeignTypeName().replace('.', '_'));
    }

    @Override
    public void generateLoadFromObject(JavaWriter out, String obj) throws IOException {
        out.println(this.generateSuperSetter("this", this.generateGet(obj)) + ";");
    }

    public String generateSetNull(String obj) throws IOException {
        return this.generateSet(obj, this.getColumn().getType().generateNull());
    }

    @Override
    public String generateIsNull(String value) {
        return "(" + this.getType().generateIsNull(this.generateSuperGetter("this")) + ")";
    }

    @Override
    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index, String name) throws IOException {
        return this._column.getType().generateLoadForeign(out, rs, indexVar, index);
    }

    @Override
    public void generateStatementSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        if (value == null) {
            this._column.getType().generateSetNull(out, pstmt, index);
        } else {
            this._column.getType().generateSet(out, pstmt, index, this.generateGet(value));
        }
    }

    public void generateMatch(JavaWriter out, String key) throws IOException {
        out.println("return " + this.generateEquals("super", key) + ";");
    }

    @Override
    public String generateEquals(String left, String right) {
        return this._column.getType().generateEquals(left, right);
    }

    @Override
    public void generateSetInsert(JavaWriter out, String pstmt, String index) throws IOException {
        String value = this.generateSuperGetter("this");
        if (this.isAutoGenerate()) {
            out.println("if (! (" + this.getType().generateIsNull(value) + ")) {");
            out.pushDepth();
            this.generateStatementSet(out, pstmt, index);
            out.popDepth();
            out.println("} else if (! __caucho_home.isIdentityGenerator()) {");
            out.pushDepth();
            this.getType().generateSetNull(out, pstmt, index);
            out.popDepth();
            out.println("}");
        } else {
            this.generateStatementSet(out, pstmt, index);
        }
    }

    @Override
    public void generateCheckCreateKey(JavaWriter out) throws IOException {
        if ("identity".equals(this._generator)) {
            return;
        }
        if (this._generator != null) {
            out.println("if (" + this.getType().generateIsNull(this.generateSuperGetter("this")) + " && home.isSequenceGenerator()) {");
            out.pushDepth();
            String id = "home.nextGeneratorId(aConn, \"" + this.getName() + "\")";
            String javaType = this.getType().getJavaTypeName();
            if ("long".equals(javaType)) {
                id = "(" + javaType + ") " + id;
            } else if ("int".equals(javaType)) {
                id = "(" + javaType + ") " + id;
            } else if ("short".equals(javaType)) {
                id = "(" + javaType + ") " + id;
            } else if ("java.lang.Long".equals(javaType)) {
                id = "new Long(" + id + ")";
            } else if ("java.lang.Integer".equals(javaType)) {
                id = "new Integer((int) " + id + ")";
            } else if ("java.lang.Short".equals(javaType)) {
                id = "new Short((short) " + id + ")";
            } else if ("java.lang.Byte".equals(javaType)) {
                id = "new Byte((byte) " + id + ")";
            } else {
                throw new UnsupportedOperationException(L.l("{0} is an unsupported generated key type.", javaType));
            }
            out.println(this.generateSuperSetter("this", id) + ";");
            out.popDepth();
            out.println("}");
            return;
        }
        if (!this.getJavaType().isPrimitive()) {
            out.println("if (" + this.getType().generateIsNull(this.generateSuperGetter("this")) + ")");
            out.println("  throw new com.caucho.amber.AmberException(\"primary key must not be null on creation.  " + this.getGetterName() + "() must not return null.\");");
        }
    }

    @Override
    public void generateSetGeneratedKeys(JavaWriter out, String pstmt) throws IOException {
        if (!"identity".equals(this._generator) && !"auto".equals(this._generator)) {
            return;
        }
        out.print("if (");
        out.println(this.getType().generateIsNull(this.generateSuperGetter("this")));
        out.println("    && __caucho_home.isIdentityGenerator()) {");
        out.pushDepth();
        String var = "__caucho_rs_" + out.generateId();
        out.println("java.sql.ResultSet " + var + " = " + pstmt + ".getGeneratedKeys();");
        out.println("if (" + var + ".next()) {");
        out.pushDepth();
        out.print(this.getType().getName() + " v1 = ");
        this.getType().generateLoad(out, var, "", 1);
        out.println(";");
        out.println(this.generateSuperSetter("this", "v1") + ";");
        out.println("if (__caucho_log.isLoggable(java.util.logging.Level.FINER))");
        out.println("  __caucho_log.finer(\"create with new primaryKey \" + " + this.generateSuperGetter("this") + ");");
        out.popDepth();
        out.println("}");
        out.println("else throw new java.sql.SQLException();");
        out.popDepth();
        out.println("}");
    }

    @Override
    public String generateSetKeyProperty(String key, String value) throws IOException {
        if (this._isKeyField) {
            return key + "." + this.getName() + " = " + value;
        }
        return this.generateSet(key, value);
    }

    @Override
    public String generateGetKeyProperty(String key) {
        if (this._isKeyField) {
            return key + "." + this.getName();
        }
        return this.generateGet(key);
    }

    @Override
    public String generateGetProxyProperty(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AmberExpr createExpr(QueryParser parser, PathExpr parent) {
        return new KeyColumnExpr(parent, this.getColumn());
    }

    @Override
    public String toObject(String value) {
        return this.getColumn().getType().toObject(value);
    }

    @Override
    public String toValue(String value) {
        return this.getColumn().getType().generateCastFromObject(value);
    }
}

