/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.util.CharBuffer;

public class QueryCacheKey {
    private String _sql;
    private Object[] _args;
    private int _startRow;

    public QueryCacheKey() {
    }

    public QueryCacheKey(String sql, Object[] args, int startRow) {
        this.init(sql, args, startRow);
    }

    public void init(String sql, Object[] args, int startRow) {
        this._sql = sql;
        this._args = args;
        this._startRow = startRow;
    }

    public int hashCode() {
        int hash = this._startRow;
        hash = 65537 * hash + this._sql.hashCode();
        Object[] args = this._args;
        for (int i = args.length - 1; i >= 0; --i) {
            Object v = args[i];
            hash = v == null ? 65537 * hash + 17 : 65537 * hash + 17 * v.hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        QueryCacheKey key = (QueryCacheKey)o;
        if (!this._sql.equals(key._sql)) {
            return false;
        }
        if (this._startRow != key._startRow) {
            return false;
        }
        Object[] argsA = this._args;
        Object[] argsB = key._args;
        if (argsA.length != argsB.length) {
            return false;
        }
        for (int i = argsA.length - 1; i >= 0; --i) {
            Object a = argsA[i];
            Object b = argsB[i];
            if (a == b || a != null && a.equals(b)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        CharBuffer cb = new CharBuffer();
        cb.append("QueryCacheKey[");
        cb.append(this._sql);
        for (int i = 0; i < this._args.length; ++i) {
            cb.append(",");
            cb.append(this._args[i]);
        }
        cb.append("]");
        return cb.toString();
    }
}

