/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.AmberType;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BigIntegerType
extends AmberType {
    private static final L10N L = new L10N(BigIntegerType.class);

    private BigIntegerType() {
    }

    public static BigIntegerType create() {
        return new BigIntegerType();
    }

    public String getName() {
        return "java.math.BigInteger";
    }

    public boolean isNumeric() {
        return true;
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(rs + ".getBigDecimal(" + indexVar + " + " + index + ")");
        out.print(" == null || " + rs + ".wasNull() ? null : ");
        out.print(rs + ".getBigDecimal(" + indexVar + " + " + index + ").toBigInteger()");
        return index + 1;
    }

    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("com.caucho.amber.type.BigIntegerType.toBigInteger(rs.getBigDecimal(columnNames[" + index + "]), rs.wasNull())");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setNull(" + index + "++, java.sql.Types.DECIMAL);");
        out.println("else");
        out.println("  " + pstmt + ".setBigDecimal(" + index + "++, new java.math.BigDecimal(" + value + "));");
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        if (value == null) {
            pstmt.setNull(index, 3);
        } else {
            pstmt.setBigDecimal(index, new BigDecimal((BigInteger)value));
        }
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        BigDecimal v = rs.getBigDecimal(index);
        if (rs.wasNull()) {
            return null;
        }
        return v.toBigInteger();
    }

    public String generateCreateColumnSQL(AmberPersistenceUnit manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(2, length, precision, scale);
    }

    public static BigInteger toBigInteger(BigDecimal value, boolean wasNull) {
        if (wasNull || value == null) {
            return null;
        }
        return value.toBigInteger();
    }
}

