/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.type.ArrayType;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CharacterArrayType
extends ArrayType {
    private static final L10N L = new L10N(CharacterArrayType.class);

    private CharacterArrayType() {
    }

    public static CharacterArrayType create() {
        return new CharacterArrayType();
    }

    public String getName() {
        return "java.lang.Character[]";
    }

    public String getJavaTypeName() {
        return "java.lang.Character[]";
    }

    public String getJavaObjectTypeName() {
        return "java.lang.Character";
    }

    public String getPrimitiveArrayTypeName() {
        return "char[]";
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(rs + ".getString(" + indexVar + " + " + index + ")");
        out.print(" == null || " + rs + ".wasNull() ? null : ");
        out.print(rs + ".getString(" + indexVar + " + " + index + ").toCharArray()");
        return index + 1;
    }

    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("CharacterArrayType.toCharArray(");
        out.print("rs.getString(columnNames[" + index + "]), ");
        out.print("rs.wasNull())");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setNull(" + index + "++, java.sql.Types.CHAR);");
        out.println("else {");
        out.println("  java.lang.Character[] super_temp_" + index + " = " + value + ";");
        out.println("  char[] temp_" + index + " = new char[super_temp_" + index + ".length];");
        out.println("  for (int i=0; i < temp_" + index + ".length; i++)");
        out.println("    temp_" + index + "[i] = super_temp_" + index + "[i].charValue();");
        out.println("  " + pstmt + ".setString(" + index + "++, new String(temp_" + index + "));");
        out.println("}");
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        Character[] wrapperCharacter = (Character[])value;
        char[] primitiveCharacter = new char[wrapperCharacter.length];
        for (int i = 0; i < wrapperCharacter.length; ++i) {
            primitiveCharacter[i] = wrapperCharacter[i].charValue();
        }
        pstmt.setString(index, new String(primitiveCharacter));
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        char[] primitiveCharacter = rs.getString(index).toCharArray();
        if (rs.wasNull()) {
            return null;
        }
        Character[] wrapperCharacter = new Character[primitiveCharacter.length];
        for (int i = 0; i < primitiveCharacter.length; ++i) {
            wrapperCharacter[i] = new Character(primitiveCharacter[i]);
        }
        return wrapperCharacter;
    }

    public static Character[] toCharArray(String v, boolean isNull) throws SQLException {
        if (isNull) {
            return null;
        }
        char[] primitiveCharacter = v.toCharArray();
        Character[] wrapperCharacter = new Character[primitiveCharacter.length];
        for (int i = 0; i < primitiveCharacter.length; ++i) {
            wrapperCharacter[i] = new Character(primitiveCharacter[i]);
        }
        return wrapperCharacter;
    }
}

