/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.type.AmberType;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class PrimitiveByteArrayType
extends AmberType {
    private static final L10N L = new L10N(PrimitiveByteArrayType.class);

    private PrimitiveByteArrayType() {
    }

    public static PrimitiveByteArrayType create() {
        return new PrimitiveByteArrayType();
    }

    public String getName() {
        return "byte[]";
    }

    public String getJavaTypeName() {
        return "byte[]";
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(rs + ".getBytes(" + indexVar + " + " + index + ")");
        return index + 1;
    }

    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("rs.getBytes(columnNames[" + index + "])");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setNull(" + index + "++, java.sql.Types.LONGVARBINARY);");
        out.println("else");
        out.println("  " + pstmt + ".setBytes(" + index + "++, " + value + ");");
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        pstmt.setBytes(index, (byte[])value);
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        return rs.getBytes(index);
    }
}

