/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.AmberType;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.TemporalType;

public class UtilDateType
extends AmberType {
    private static final L10N L = new L10N(UtilDateType.class);
    public static final UtilDateType TEMPORAL_DATE_TYPE = new UtilDateType(TemporalType.DATE);
    public static final UtilDateType TEMPORAL_TIME_TYPE = new UtilDateType(TemporalType.TIME);
    public static final UtilDateType TEMPORAL_TIMESTAMP_TYPE = new UtilDateType(TemporalType.TIMESTAMP);
    private TemporalType _temporalType;

    private UtilDateType(TemporalType temporalType) {
        this._temporalType = temporalType;
    }

    public static UtilDateType create() {
        return TEMPORAL_TIMESTAMP_TYPE;
    }

    public String getName() {
        return "java.util.Date";
    }

    public boolean isAssignableTo(Class javaType) {
        return javaType.isAssignableFrom(Date.class);
    }

    public String generateCreateColumnSQL(AmberPersistenceUnit manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(93, length, precision, scale);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("com.caucho.amber.type.UtilDateType.toDate(" + rs + ".getTimestamp(" + indexVar + " + " + index + "))");
        return index + 1;
    }

    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("com.caucho.amber.type.UtilDateType.toDate(rs.getTimestamp(columnNames[" + index + "]))");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setNull(" + index + "++, java.sql.Types.TIMESTAMP);");
        out.println("else");
        out.println("  " + pstmt + ".setTimestamp(" + index + "++, new java.sql.Timestamp(" + value + ".getTime()));");
    }

    public static Date toDate(Timestamp time) throws SQLException {
        return time;
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        Timestamp date = rs.getTimestamp(index);
        if (date == null) {
            return null;
        }
        return new Date(date.getTime());
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        switch (this._temporalType) {
            case DATE: {
                pstmt.setObject(index, value, 91);
                break;
            }
            case TIME: {
                pstmt.setObject(index, value, 92);
                break;
            }
            default: {
                pstmt.setObject(index, value, 93);
            }
        }
    }
}

