/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ant;

import com.caucho.ant.ResinDeployClientTask;
import com.caucho.env.repository.CommitBuilder;
import com.caucho.server.admin.TagResult;
import com.caucho.server.admin.WebAppDeployClient;
import org.apache.tools.ant.BuildException;

public class ResinQueryTags
extends ResinDeployClientTask {
    private String _pattern;
    private boolean _printValues = false;

    public void setPattern(String pattern) {
        this._pattern = pattern;
    }

    public String getPattern() {
        return this._pattern;
    }

    public void setPrintValues(boolean printValues) {
        this._printValues = printValues;
    }

    public boolean getPrintValues() {
        return this._printValues;
    }

    protected void validate() throws BuildException {
        super.validate();
        if (this._pattern == null && this.getStage() == null && this.getVirtualHost() == null && this.getContextRoot() == null && this.getVersion() == null) {
            throw new BuildException("At least one of pattern, stage, virtualHost, contextRoot, or version is required by " + this.getTaskName());
        }
    }

    protected void doTask(WebAppDeployClient client) throws BuildException {
        TagResult[] tags;
        String pattern = this._pattern;
        if (pattern == null) {
            if (this.getContextRoot() == null) {
                this.setContextRoot(".*");
            }
            CommitBuilder commit = this.buildVersionedWarTag();
            pattern = commit.getId();
        }
        this.log("Query pattern = '" + pattern + "'", 4);
        for (TagResult tag : tags = client.queryTags(pattern)) {
            if (this._printValues) {
                this.log(tag.getTag() + " -> " + tag.getRoot());
                continue;
            }
            this.log(tag.getTag());
        }
    }
}

