/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam;

import com.caucho.bam.ActorError;
import com.caucho.bam.ActorStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractActorStream
implements ActorStream {
    private static final Logger log = Logger.getLogger(AbstractActorStream.class.getName());

    public abstract String getJid();

    public abstract ActorStream getLinkStream();

    public void message(String to, String from, Serializable payload) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " message ignored " + payload + " {from:" + from + ", to:" + to + "}");
        }
        String msg = this + ": message is not implemented by this actor.\n" + payload + " {from:" + from + ", to:" + to + "}";
        ActorError error = new ActorError("cancel", "feature-not-implemented", msg);
        ActorStream linkStream = this.getLinkStream();
        if (linkStream != null) {
            linkStream.messageError(from, to, payload, error);
        }
    }

    public void messageError(String to, String from, Serializable payload, ActorError error) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " messageError ignored " + error + " " + payload + " {from:" + from + ", to:" + to + "}");
        }
    }

    public void queryGet(long id, String to, String from, Serializable payload) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " queryGet not implemented " + payload + " {id:" + id + ", from:" + from + ", to:" + to + "}");
        }
        String msg = this + ": queryGet is not implemented by this actor.\n" + payload + " {id:" + id + ", from:" + from + ", to:" + to + "}";
        ActorError error = new ActorError("cancel", "feature-not-implemented", msg);
        ActorStream linkStream = this.getLinkStream();
        if (linkStream == null) {
            throw new IllegalStateException(this + ".getLinkStream() did not return an ActorStream, which is needed to send an error for a QueryGet");
        }
        linkStream.queryError(id, from, to, payload, error);
    }

    public void querySet(long id, String to, String from, Serializable payload) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " querySet not implemented " + payload + " {id:" + id + ", from:" + from + ", to:" + to + "}");
        }
        String msg = this + ": querySet is not implemented for this payload:\n" + "  " + payload + " {id:" + id + ", from:" + from + ", to:" + to + "}";
        ActorError error = new ActorError("cancel", "feature-not-implemented", msg);
        ActorStream linkStream = this.getLinkStream();
        if (linkStream == null) {
            throw new IllegalStateException(this + ".getLinkStream() did not return an ActorStream, which is needed to send an error for a QuerySet");
        }
        linkStream.queryError(id, from, to, payload, error);
    }

    public void queryResult(long id, String to, String from, Serializable payload) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " queryResult ignored " + payload + " {id:" + id + ", from:" + from + ", to:" + to + "}");
        }
    }

    public void queryError(long id, String to, String from, Serializable payload, ActorError error) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " queryError ignored " + error + " " + payload + " {id:" + id + ", from:" + from + ", to:" + to + "}");
        }
    }

    public boolean isClosed() {
        return false;
    }

    public void close() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getJid() + "]";
    }
}

