/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bayeux;

import com.caucho.bayeux.JsonArray;
import com.caucho.bayeux.JsonBoolean;
import com.caucho.bayeux.JsonDecodingException;
import com.caucho.bayeux.JsonDouble;
import com.caucho.bayeux.JsonLong;
import com.caucho.bayeux.JsonMap;
import com.caucho.bayeux.JsonNull;
import com.caucho.bayeux.JsonNumber;
import com.caucho.bayeux.JsonObject;
import com.caucho.bayeux.JsonString;
import com.caucho.util.L10N;

class JsonDecoder {
    private static final L10N L = new L10N(JsonDecoder.class);
    private String _string;
    private int _len;
    private int _offset;

    private JsonDecoder(String string) {
        this._string = string;
        this._len = this._string.length();
        this._offset = 0;
    }

    public static JsonObject decode(String string) throws JsonDecodingException {
        return new JsonDecoder(string).decode();
    }

    private JsonObject decode() throws JsonDecodingException {
        JsonObject object = this.decodeObject();
        if (this.skipWhitespace() >= 0) {
            this.error("expected no more input");
        }
        return object;
    }

    private JsonObject decodeObject() throws JsonDecodingException {
        int ch = this.skipWhitespace();
        while (ch >= 0) {
            switch (ch) {
                case 34: {
                    return this.decodeString();
                }
                case 116: {
                    if (this.read() == 114 && this.read() == 117 && this.read() == 101) {
                        return JsonBoolean.TRUE;
                    }
                    this.error("expected 'true'");
                }
                case 102: {
                    if (this.read() == 97 && this.read() == 108 && this.read() == 115 && this.read() == 101) {
                        return JsonBoolean.FALSE;
                    }
                    this.error("expected 'false'");
                }
                case 110: {
                    if (this.read() == 117 && this.read() == 108 && this.read() == 108) {
                        return JsonNull.NULL;
                    }
                    this.error("expected 'null'");
                }
                case 91: {
                    return this.decodeArray();
                }
                case 123: {
                    return this.decodeMap();
                }
            }
            if (ch == 45 || 48 <= ch && ch <= 57) {
                this.unread();
                return this.decodeNumber();
            }
            this.error();
            ch = this.read();
        }
        this.error();
        return null;
    }

    private JsonNumber decodeNumber() throws JsonDecodingException {
        StringBuilder sb = new StringBuilder();
        int ch = this.read();
        if (ch == 45) {
            sb.append((char)ch);
            ch = this.read();
        }
        if (ch >= 0) {
            if (ch == 48) {
                sb.append((char)ch);
                ch = this.read();
            } else if (49 <= ch && ch <= 57) {
                sb.append((char)ch);
                ch = this.read();
                while (48 <= ch && ch <= 57) {
                    sb.append((char)ch);
                    ch = this.read();
                }
            } else {
                this.error("expected 1-9");
            }
        }
        int integerEnd = sb.length();
        if (ch == 46) {
            sb.append((char)ch);
            ch = this.read();
            while (48 <= ch && ch <= 57) {
                sb.append((char)ch);
                ch = this.read();
            }
        }
        if (ch == 101 || ch == 69) {
            sb.append((char)ch);
            ch = this.read();
            if (ch == 43 || ch == 45) {
                sb.append((char)ch);
                ch = this.read();
            }
            if (48 <= ch && ch <= 57) {
                sb.append((char)ch);
                ch = this.read();
                while (48 <= ch && ch <= 57) {
                    sb.append((char)ch);
                    ch = this.read();
                }
            } else {
                this.error("expected 0-9 exponent");
            }
        }
        this.unread();
        if (integerEnd != sb.length()) {
            return JsonDouble.valueOf(Double.parseDouble(sb.toString()));
        }
        return JsonLong.valueOf(Long.parseLong(sb.toString()));
    }

    private JsonArray decodeArray() throws JsonDecodingException {
        int ch;
        JsonArray array = new JsonArray();
        while ((ch = this.skipWhitespace()) != 93) {
            this.unread();
            array.add(this.decodeObject());
            ch = this.skipWhitespace();
            if (ch == 44) continue;
            if (ch == 93) break;
            this.error("expected either ',' or ']'");
        }
        return array;
    }

    private JsonMap decodeMap() throws JsonDecodingException {
        int ch;
        JsonMap map = new JsonMap();
        while ((ch = this.skipWhitespace()) != 125) {
            this.unread();
            JsonObject name = this.decodeObject();
            if (name == null) {
                this.error("field names must not be null");
            }
            if (!(name instanceof JsonString)) {
                this.error("field names must be strings");
            }
            if ((ch = this.skipWhitespace()) != 58) {
                this.error("expected ':'");
            }
            map.put(name.toString(), this.decodeObject());
            ch = this.skipWhitespace();
            if (ch == 44) continue;
            if (ch == 125) break;
            this.error("expected either ',' or '}'");
        }
        return map;
    }

    private JsonString decodeString() throws JsonDecodingException {
        StringBuilder sb = new StringBuilder();
        int ch = this.read();
        while (ch >= 0) {
            switch (ch) {
                case 92: {
                    ch = this.read();
                    if (ch < 0) {
                        this.error("invalid escape character");
                    }
                    switch (ch) {
                        case 34: {
                            sb.append('\"');
                            break;
                        }
                        case 92: {
                            sb.append('\\');
                            break;
                        }
                        case 47: {
                            sb.append('/');
                            break;
                        }
                        case 98: {
                            sb.append('\b');
                            break;
                        }
                        case 102: {
                            sb.append('\f');
                            break;
                        }
                        case 110: {
                            sb.append('\n');
                            break;
                        }
                        case 114: {
                            sb.append('\r');
                            break;
                        }
                        case 116: {
                            sb.append('\t');
                            break;
                        }
                        case 85: 
                        case 117: {
                            int hex = 0;
                            for (int i = 0; i < 4; ++i) {
                                hex <<= 4;
                                ch = this.read();
                                if (48 <= ch && ch <= 57) {
                                    hex += ch - 48;
                                    continue;
                                }
                                if (ch >= 97 && ch <= 102) {
                                    hex += ch - 97 + 10;
                                    continue;
                                }
                                if (ch >= 65 && ch <= 70) {
                                    hex += ch - 65 + 10;
                                    continue;
                                }
                                this.error("invalid escaped hex character");
                            }
                            sb.append((char)hex);
                        }
                    }
                    break;
                }
                case 34: {
                    return JsonString.valueOf(sb.toString());
                }
                default: {
                    sb.append((char)ch);
                }
            }
            ch = this.read();
        }
        this.error("error decoding string");
        return null;
    }

    private void error() throws JsonDecodingException {
        this.error(null);
    }

    private void error(String message) throws JsonDecodingException {
        int end;
        int start;
        if (this._offset < this._len) {
            start = this._offset - 1;
            end = this._offset;
        } else {
            start = this._len - 1;
            end = this._len;
        }
        String token = this._string.substring(start, end).toString();
        if (message != null) {
            throw new JsonDecodingException(L.l("error parsing '{0}': {1}", (Object)token, message));
        }
        throw new JsonDecodingException(L.l("error parsing '{0}'", token));
    }

    private void unread() {
        if (this._offset > 0) {
            --this._offset;
        }
    }

    private int peek(int index) {
        if (0 <= index && index < this._len) {
            return this._string.charAt(index);
        }
        return -1;
    }

    private int read() {
        if (this._offset < this._len) {
            return this._string.charAt(this._offset++);
        }
        return -1;
    }

    private int skipWhitespace() {
        int ch = this.read();
        while (ch >= 0 && (ch == 32 || ch == 10 || ch == 13 || ch == 9)) {
            ch = this.read();
        }
        return ch;
    }
}

