/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractBootCommand;
import com.caucho.boot.OpenPort;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.config.ConfigException;
import com.caucho.env.repository.CommitBuilder;
import com.caucho.network.listen.SocketLinkListener;
import com.caucho.server.admin.WebAppDeployClient;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.ArrayList;

public class DeployCommand
extends AbstractBootCommand {
    private static final L10N L = new L10N(DeployCommand.class);

    public void doCommand(WatchdogArgs args, WatchdogClient client) {
        WebAppDeployClient deployClient = this.getDeployClient(args, client);
        String war = this.findWar(args);
        if (war == null) {
            throw new ConfigException(L.l("Cannot find .war argument in command line"));
        }
        if (!war.endsWith(".war")) {
            throw new ConfigException(L.l("Deploy expects to be used with a *.war file at {0}", war));
        }
        String name = args.getArg("-name");
        String host = args.getArg("-host");
        if (host == null) {
            host = "default";
        }
        CommitBuilder commit = new CommitBuilder();
        commit.type("webapp");
        String stage = args.getArg("-stage");
        if (stage != null) {
            commit.stage(stage);
        }
        Path path = Vfs.lookup(war);
        if (name == null) {
            String tail = path.getTail();
            int p = tail.lastIndexOf(46);
            name = tail.substring(0, p);
        }
        commit.tagKey(host + "/" + name);
        if (!path.isFile()) {
            throw new ConfigException(L.l("'{0}' is not a readable file.", path.getFullPath()));
        }
        String message = args.getArg("-m");
        if (message == null) {
            message = args.getArg("-message");
        }
        if (message == null) {
            message = "deploy " + war + " from command line";
        }
        commit.message(message);
        commit.attribute("user", System.getProperty("user.name"));
        deployClient.commitArchive(commit, path);
        deployClient.close();
        System.out.println("Deployed " + commit.getId() + " as " + war + " to " + deployClient.getUrl());
    }

    private String findWar(WatchdogArgs args) {
        ArrayList<String> tailArgs = args.getTailArgs();
        for (int i = 0; i < tailArgs.size(); ++i) {
            String arg = tailArgs.get(i);
            if (arg.startsWith("-")) {
                ++i;
                continue;
            }
            return arg;
        }
        return null;
    }

    private WebAppDeployClient getDeployClient(WatchdogArgs args, WatchdogClient client) {
        String address = client.getConfig().getAddress();
        int port = this.findPort(client);
        if (port == 0) {
            throw new ConfigException(L.l("HTTP listener {0}:{1} was not found", (Object)address, port));
        }
        String user = args.getArg("-user");
        String password = args.getArg("-password");
        return new WebAppDeployClient(address, port, user, password);
    }

    private int findPort(WatchdogClient client) {
        for (SocketLinkListener listener : client.getConfig().getPorts()) {
            OpenPort openPort;
            if (!(listener instanceof OpenPort) || !"http".equals((openPort = (OpenPort)listener).getProtocolName())) continue;
            return openPort.getPort();
        }
        return 0;
    }
}

