/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.VersionFactory;
import com.caucho.boot.BootCommand;
import com.caucho.boot.BootResinConfig;
import com.caucho.boot.DeployCommand;
import com.caucho.boot.ProLoader;
import com.caucho.boot.ResinGUI;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.lib.ResinConfigLibrary;
import com.caucho.env.service.ResinSystem;
import com.caucho.loader.Environment;
import com.caucho.server.resin.ResinELContext;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResinBoot {
    private static L10N _L;
    private static Logger _log;
    private static HashMap<WatchdogArgs.StartMode, BootCommand> _commandMap;
    private WatchdogArgs _args;
    private WatchdogClient _client;
    private ResinGUI _ui;

    ResinBoot(String[] argv) throws Exception {
        this._args = new WatchdogArgs(argv);
        Path resinHome = this._args.getResinHome();
        ProLoader loader = ProLoader.create(resinHome);
        if (loader != null) {
            System.setProperty("resin.home", resinHome.getNativePath());
            Thread.currentThread().setContextClassLoader(loader);
            Environment.init();
            Vfs.initJNI();
            resinHome = Vfs.lookup(resinHome.getFullPath());
            this._args.setResinHome(resinHome);
        } else {
            Environment.init();
        }
        String jvmVersion = System.getProperty("java.runtime.version");
        if ("1.6".compareTo(jvmVersion) > 0) {
            throw new ConfigException(ResinBoot.L().l("Resin requires Java 1.6 or later but was started with {0}", jvmVersion));
        }
        System.setProperty("resin.home", resinHome.getNativePath());
        if (!this._args.getResinConf().canRead()) {
            throw new ConfigException(ResinBoot.L().l("Resin/{0} can't open configuration file '{1}'", (Object)VersionFactory.getVersion(), this._args.getResinConf().getNativePath()));
        }
        Path rootDirectory = this._args.getRootDirectory();
        Path dataDirectory = rootDirectory.lookup("watchdog-data");
        ResinSystem system = new ResinSystem("watchdog", rootDirectory, dataDirectory);
        Thread thread = Thread.currentThread();
        thread.setContextClassLoader(system.getClassLoader());
        Config config = new Config();
        BootResinConfig bootManager = new BootResinConfig(system, this._args);
        ResinELContext elContext = this._args.getELContext();
        InjectManager beanManager = InjectManager.create();
        Config.setProperty("resinHome", elContext.getResinHome());
        Config.setProperty("java", elContext.getJavaVar());
        Config.setProperty("resin", elContext.getResinVar());
        Config.setProperty("server", elContext.getServerVar());
        Config.setProperty("system", System.getProperties());
        Config.setProperty("getenv", System.getenv());
        ResinConfigLibrary.configure(beanManager);
        config.configure((Object)bootManager, this._args.getResinConf(), "com/caucho/server/resin/resin.rnc");
        this._client = this._args.isDynamicServer() ? bootManager.addDynamicClient(this._args) : bootManager.findClient(this._args.getServerId());
        if (this._client == null) {
            throw new ConfigException(ResinBoot.L().l("Resin/{0}: -server '{1}' does not match any defined <server>\nin {2}.", VersionFactory.getVersion(), this._args.getServerId(), this._args.getResinConf()));
        }
    }

    boolean start() throws Exception {
        if (this._args.isStatus()) {
            try {
                String status = this._client.statusWatchdog();
                System.out.println(ResinBoot.L().l("Resin/{0} status for watchdog at {1}:{2}", VersionFactory.getVersion(), this._client.getWatchdogAddress(), this._client.getWatchdogPort()));
                System.out.println(status);
            }
            catch (Exception e) {
                System.out.println(ResinBoot.L().l("Resin/{0} can't retrieve status of -server '{1}' for watchdog at {2}:{3}.\n{4}", VersionFactory.getVersion(), this._client.getId(), this._client.getWatchdogAddress(), this._client.getWatchdogPort(), e.toString()));
                ResinBoot.log().log(Level.FINE, e.toString(), e);
                System.exit(1);
            }
            return false;
        }
        if (this._args.isStart()) {
            try {
                this._client.startWatchdog(this._args.getArgv());
                System.out.println(ResinBoot.L().l("Resin/{0} started -server '{1}' for watchdog at {2}:{3}", VersionFactory.getVersion(), this._client.getId(), this._client.getWatchdogAddress(), this._client.getWatchdogPort()));
            }
            catch (Exception e) {
                String eMsg = e instanceof ConfigException ? e.getMessage() : e.toString();
                System.out.println(ResinBoot.L().l("Resin/{0} can't start -server '{1}' for watchdog at {2}:{3}.\n  {4}", VersionFactory.getVersion(), this._client.getId(), this._client.getWatchdogAddress(), this._client.getWatchdogPort(), eMsg));
                ResinBoot.log().log(Level.FINE, e.toString(), e);
                System.exit(1);
            }
            return false;
        }
        if (this._args.isStop()) {
            try {
                this._client.stopWatchdog();
                System.out.println(ResinBoot.L().l("Resin/{0} stopped -server '{1}' for watchdog at {2}:{3}", VersionFactory.getVersion(), this._client.getId(), this._client.getWatchdogAddress(), this._client.getWatchdogPort()));
            }
            catch (Exception e) {
                System.out.println(ResinBoot.L().l("Resin/{0} can't stop -server '{1}' for watchdog at {2}:{3}.\n{4}", VersionFactory.getVersion(), this._client.getId(), this._client.getWatchdogAddress(), this._client.getWatchdogPort(), e.toString()));
                ResinBoot.log().log(Level.FINE, e.toString(), e);
                System.exit(1);
            }
            return false;
        }
        if (this._args.isKill()) {
            try {
                this._client.killWatchdog();
                System.out.println(ResinBoot.L().l("Resin/{0} killed -server '{1}' for watchdog at {2}:{3}", VersionFactory.getVersion(), this._client.getId(), this._client.getWatchdogAddress(), this._client.getWatchdogPort()));
            }
            catch (Exception e) {
                System.out.println(ResinBoot.L().l("Resin/{0} can't kill -server '{1}' for watchdog at {2}:{3}.\n{4}", VersionFactory.getVersion(), this._client.getId(), this._client.getWatchdogAddress(), this._client.getWatchdogPort(), e.toString()));
                ResinBoot.log().log(Level.FINE, e.toString(), e);
                System.exit(1);
            }
            return false;
        }
        if (this._args.isRestart()) {
            try {
                this._client.restartWatchdog(this._args.getArgv());
                System.out.println(ResinBoot.L().l("Resin/{0} restarted -server '{1}' for watchdog at {2}:{3}", VersionFactory.getVersion(), this._client.getId(), this._client.getWatchdogAddress(), this._client.getWatchdogPort()));
            }
            catch (Exception e) {
                System.out.println(ResinBoot.L().l("Resin/{0} can't restart -server '{1}'.\n{2}", VersionFactory.getVersion(), this._client.getId(), e.toString()));
                ResinBoot.log().log(Level.FINE, e.toString(), e);
                System.exit(1);
            }
            return false;
        }
        if (this._args.isShutdown()) {
            try {
                this._client.shutdown();
                System.out.println(ResinBoot.L().l("Resin/{0} shutdown watchdog at {1}:{2}", VersionFactory.getVersion(), this._client.getWatchdogAddress(), this._client.getWatchdogPort()));
            }
            catch (Exception e) {
                System.out.println(ResinBoot.L().l("Resin/{0} can't shutdown watchdog at {1}:{2}.\n{3}", VersionFactory.getVersion(), this._client.getWatchdogAddress(), this._client.getWatchdogPort(), e.toString()));
                ResinBoot.log().log(Level.FINE, e.toString(), e);
                System.exit(1);
            }
            return false;
        }
        if (this._args.isConsole()) {
            return this._client.startConsole() != 0;
        }
        if (this._args.isGui()) {
            if (this._ui != null && this._ui.isVisible()) {
                return true;
            }
            if (this._ui != null) {
                return false;
            }
            this._ui = new ResinGUI(this, this._client);
            this._ui.setVisible(true);
            return true;
        }
        BootCommand command = _commandMap.get((Object)this._args.getStartMode());
        if (command != null) {
            command.doCommand(this._args, this._client);
            return false;
        }
        throw new IllegalStateException(ResinBoot.L().l("Unknown start mode"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        if (System.getProperty("log.level") != null) {
            Logger.getLogger("").setLevel(Level.FINER);
        }
        try {
            ResinBoot boot = new ResinBoot(argv);
            while (boot.start()) {
                try {
                    ResinBoot resinBoot = boot;
                    synchronized (resinBoot) {
                        boot.wait(5000L);
                    }
                }
                catch (Exception exception) {
                }
            }
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof ConfigException) {
                System.out.println(e.getMessage());
                System.exit(2);
            }
            e.printStackTrace();
            System.exit(3);
        }
    }

    private static L10N L() {
        if (_L == null) {
            _L = new L10N(ResinBoot.class);
        }
        return _L;
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(ResinBoot.class.getName());
        }
        return _log;
    }

    static {
        _commandMap = new HashMap();
        _commandMap.put(WatchdogArgs.StartMode.DEPLOY, new DeployCommand());
    }
}

