/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.VersionFactory;
import com.caucho.config.ConfigException;
import com.caucho.license.LicenseCheck;
import com.caucho.server.resin.ResinELContext;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WatchdogArgs {
    private static L10N _L;
    private static final Logger log;
    private Path _javaHome;
    private Path _resinHome;
    private Path _rootDirectory;
    private String[] _argv;
    private Path _resinConf;
    private Path _logDirectory;
    private String _serverId = "";
    private int _watchdogPort;
    private boolean _isVerbose;
    private StartMode _startMode;
    private ArrayList<String> _tailArgs = new ArrayList();
    private boolean _isDynamicServer;
    private String _dynamicCluster;
    private String _dynamicAddress;
    private int _dynamicPort;

    WatchdogArgs(String[] argv) {
        this(argv, true);
    }

    WatchdogArgs(String[] argv, boolean isTop) {
        String logLevel = System.getProperty("resin.log.level");
        if (isTop) {
            this.setLogLevel(logLevel);
        }
        this._resinHome = WatchdogArgs.calculateResinHome();
        this._rootDirectory = WatchdogArgs.calculateResinRoot(this._resinHome);
        this._javaHome = Vfs.lookup(System.getProperty("java.home"));
        this._argv = this.fillArgv(argv);
        this._resinConf = this._resinHome.lookup("conf/resin.conf");
        if (!this._resinConf.canRead()) {
            this._resinConf = this._resinHome.lookup("conf/resin.xml");
        }
        this.parseCommandLine(argv);
    }

    Path getJavaHome() {
        return this._javaHome;
    }

    Path getResinHome() {
        return this._resinHome;
    }

    Path getRootDirectory() {
        return this._rootDirectory;
    }

    Path getLogDirectory() {
        return this._logDirectory;
    }

    Path getResinConf() {
        return this._resinConf;
    }

    String getServerId() {
        return this._serverId;
    }

    String[] getArgv() {
        return this._argv;
    }

    boolean isDynamicServer() {
        return this._isDynamicServer;
    }

    String getDynamicCluster() {
        return this._dynamicCluster;
    }

    String getDynamicAddress() {
        return this._dynamicAddress;
    }

    int getDynamicPort() {
        return this._dynamicPort;
    }

    boolean isVerbose() {
        return this._isVerbose;
    }

    void setWatchdogPort(int port) {
        this._watchdogPort = port;
    }

    int getWatchdogPort() {
        return this._watchdogPort;
    }

    void setResinHome(Path resinHome) {
        this._resinHome = resinHome;
    }

    boolean isStatus() {
        return this._startMode == StartMode.STATUS;
    }

    boolean isStart() {
        return this._startMode == StartMode.START;
    }

    boolean isGui() {
        return this._startMode == StartMode.GUI;
    }

    boolean isStop() {
        return this._startMode == StartMode.STOP;
    }

    boolean isRestart() {
        return this._startMode == StartMode.RESTART;
    }

    boolean isKill() {
        return this._startMode == StartMode.KILL;
    }

    boolean isShutdown() {
        return this._startMode == StartMode.SHUTDOWN;
    }

    boolean isConsole() {
        return this._startMode == StartMode.CONSOLE;
    }

    StartMode getStartMode() {
        return this._startMode;
    }

    public ArrayList<String> getTailArgs() {
        return this._tailArgs;
    }

    public String getArg(String arg) {
        int i = 0;
        while (i + 1 < this._argv.length) {
            if (this._argv[i].equals(arg) || this._argv[i].equals("-" + arg)) {
                return this._argv[i + 1];
            }
            ++i;
        }
        return null;
    }

    public ResinELContext getELContext() {
        return new ResinBootELContext();
    }

    private void setLogLevel(String levelName) {
        Level level = Level.INFO;
        if ("off".equals(levelName)) {
            level = Level.OFF;
        } else if ("all".equals(levelName)) {
            level = Level.ALL;
        } else if ("severe".equals(levelName)) {
            level = Level.SEVERE;
        } else if ("warning".equals(levelName)) {
            level = Level.WARNING;
        } else if ("info".equals(levelName)) {
            level = Level.INFO;
        } else if ("config".equals(levelName)) {
            level = Level.CONFIG;
        } else if ("fine".equals(levelName)) {
            level = Level.FINE;
        } else if ("finer".equals(levelName)) {
            level = Level.FINER;
        } else if ("finest".equals(levelName)) {
            level = Level.FINEST;
        }
        Logger.getLogger("").setLevel(level);
    }

    private void parseCommandLine(String[] argv) {
        String resinConf = null;
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if ("-conf".equals(arg) || "--conf".equals(arg)) {
                resinConf = argv[i + 1];
                ++i;
                continue;
            }
            if ("-dynamic-server".equals(arg) || "--dynamic-server".equals(arg)) {
                String[] str = argv[i + 1].split(":");
                if (str.length != 3) {
                    System.out.println(WatchdogArgs.L().l("-dynamic server requires 'cluster:address:port' at '{0}'", argv[i + 1]));
                    System.exit(1);
                }
                this._isDynamicServer = true;
                this._dynamicCluster = str[0];
                this._dynamicAddress = str[1];
                this._dynamicPort = Integer.parseInt(str[2]);
                ++i;
                continue;
            }
            if ("-fine".equals(arg) || "--fine".equals(arg)) {
                this._isVerbose = true;
                Logger.getLogger("").setLevel(Level.FINE);
                continue;
            }
            if ("-finer".equals(arg) || "--finer".equals(arg)) {
                this._isVerbose = true;
                Logger.getLogger("").setLevel(Level.FINER);
                continue;
            }
            if ("-log-directory".equals(arg) || "--log-directory".equals(arg)) {
                this._logDirectory = this._rootDirectory.lookup(argv[i + 1]);
                ++i;
                continue;
            }
            if ("-resin-home".equals(arg) || "--resin-home".equals(arg)) {
                this._resinHome = Vfs.lookup(argv[i + 1]);
                ++i;
                continue;
            }
            if ("-root-directory".equals(arg) || "--root-directory".equals(arg)) {
                this._rootDirectory = Vfs.lookup(argv[i + 1]);
                ++i;
                continue;
            }
            if ("-server".equals(arg) || "--server".equals(arg)) {
                this._serverId = argv[i + 1];
                ++i;
                continue;
            }
            if ("-server-root".equals(arg) || "--server-root".equals(arg)) {
                this._rootDirectory = Vfs.lookup(argv[i + 1]);
                ++i;
                continue;
            }
            if ("-stage".equals(arg) || "--stage".equals(arg)) {
                ++i;
                continue;
            }
            if ("-preview".equals(arg) || "--preview".equals(arg)) continue;
            if ("-watchdog-port".equals(arg) || "--watchdog-port".equals(arg)) {
                this._watchdogPort = Integer.parseInt(argv[i + 1]);
                ++i;
                continue;
            }
            if (arg.startsWith("-J") || arg.startsWith("-D") || arg.startsWith("-X")) continue;
            if ("-debug-port".equals(arg) || "--debug-port".equals(arg)) {
                ++i;
                continue;
            }
            if ("-jmx-port".equals(arg) || "--jmx-port".equals(arg)) {
                ++i;
                continue;
            }
            if ("--dump-heap-on-exit".equals(arg)) continue;
            if ("-verbose".equals(arg) || "--verbose".equals(arg)) {
                this._isVerbose = true;
                Logger.getLogger("").setLevel(Level.CONFIG);
                continue;
            }
            if ("console".equals(arg)) {
                this._startMode = StartMode.CONSOLE;
                continue;
            }
            if ("gui".equals(arg)) {
                this._startMode = StartMode.GUI;
                continue;
            }
            if ("kill".equals(arg)) {
                this._startMode = StartMode.KILL;
                continue;
            }
            if ("deploy".equals(arg)) {
                this._startMode = StartMode.DEPLOY;
                continue;
            }
            if ("status".equals(arg)) {
                this._startMode = StartMode.STATUS;
                continue;
            }
            if ("start".equals(arg)) {
                this._startMode = StartMode.START;
                continue;
            }
            if ("stop".equals(arg)) {
                this._startMode = StartMode.STOP;
                continue;
            }
            if ("restart".equals(arg)) {
                this._startMode = StartMode.RESTART;
                continue;
            }
            if ("shutdown".equals(arg)) {
                this._startMode = StartMode.SHUTDOWN;
                continue;
            }
            if ("version".equals(arg)) {
                System.out.println(VersionFactory.getFullVersion());
                System.exit(0);
                continue;
            }
            if (this._startMode != null) {
                this._tailArgs.add(arg);
                continue;
            }
            System.out.println(WatchdogArgs.L().l("unknown argument '{0}'", argv[i]));
            System.out.println();
            WatchdogArgs.usage();
            System.exit(1);
        }
        if (this._startMode == null) {
            System.out.println(WatchdogArgs.L().l("Resin requires a command:\n  console - start Resin in console mode\n  status - watchdog status\n  start - start a Resin server\n  gui - start a Resin server with a GUI\n  stop - stop a Resin server\n  restart - restart a Resin server\n  kill - force a kill of a Resin server\n  shutdown - shutdown the watchdog"));
            System.exit(1);
        }
        if (resinConf != null) {
            this._resinConf = Vfs.getPwd().lookup(resinConf);
            if (!this._resinConf.exists() && this._rootDirectory != null) {
                this._resinConf = this._rootDirectory.lookup(resinConf);
            }
            if (!this._resinConf.exists() && this._resinHome != null) {
                this._resinConf = this._resinHome.lookup(resinConf);
            }
            if (!this._resinConf.exists()) {
                throw new ConfigException(WatchdogArgs.L().l("Resin/{0} can't find configuration file '{1}'", (Object)VersionFactory.getVersion(), this._resinConf.getNativePath()));
            }
        }
    }

    private static void usage() {
        System.err.println(WatchdogArgs.L().l("usage: java -jar resin.jar [-options] [console | status | start | gui | stop | restart | kill | shutdown]"));
        System.err.println(WatchdogArgs.L().l(""));
        System.err.println(WatchdogArgs.L().l("where options include:"));
        System.err.println(WatchdogArgs.L().l("   -conf <file>          : select a configuration file"));
        System.err.println(WatchdogArgs.L().l("   -dynamic-server <cluster:address:port> : initialize a dynamic server"));
        System.err.println(WatchdogArgs.L().l("   -log-directory <dir>  : select a logging directory"));
        System.err.println(WatchdogArgs.L().l("   -resin-home <dir>     : select a resin home directory"));
        System.err.println(WatchdogArgs.L().l("   -root-directory <dir> : select a root directory"));
        System.err.println(WatchdogArgs.L().l("   -server <id>          : select a <server> to run"));
        System.err.println(WatchdogArgs.L().l("   -watchdog-port <port> : override the watchdog-port"));
        System.err.println(WatchdogArgs.L().l("   -verbose              : print verbose starting information"));
        System.err.println(WatchdogArgs.L().l("   -preview              : run as a preview server"));
        System.err.println(WatchdogArgs.L().l("   -debug-port <port>    : configure a debug port"));
        System.err.println(WatchdogArgs.L().l("   -jmx-port <port>      : configure an unauthenticated jmx port"));
    }

    private String[] fillArgv(String[] argv) {
        ArrayList<String> args = new ArrayList<String>();
        try {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = new ObjectName("java.lang:type=Runtime");
            String[] jvmArgs = (String[])mbeanServer.getAttribute(name, "InputArguments");
            if (jvmArgs != null) {
                for (int i = 0; i < jvmArgs.length; ++i) {
                    String arg = jvmArgs[i];
                    if (args.contains(arg) || arg.startsWith("-Djava.class.path=") || !arg.startsWith("-D")) continue;
                    int eqlSignIdx = arg.indexOf(61);
                    if (eqlSignIdx == -1) {
                        args.add("-J" + arg);
                        continue;
                    }
                    String key = arg.substring(2, eqlSignIdx);
                    String value = System.getProperty(key);
                    if (value == null) {
                        value = "";
                    }
                    args.add("-J-D" + key + "=" + value);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < argv.length; ++i) {
            args.add(argv[i]);
        }
        argv = new String[args.size()];
        args.toArray(argv);
        return argv;
    }

    private static L10N L() {
        if (_L == null) {
            _L = new L10N(WatchdogArgs.class);
        }
        return _L;
    }

    static Path calculateResinHome() {
        String resinHome = System.getProperty("resin.home");
        if (resinHome != null) {
            return Vfs.lookup(resinHome);
        }
        String classPath = System.getProperty("java.class.path");
        if (classPath.indexOf("resin.jar") >= 0) {
            int q = classPath.indexOf("resin.jar") + "resin.jar".length();
            int p = classPath.lastIndexOf(File.pathSeparatorChar, q - 1);
            String resinJar = p >= 0 ? classPath.substring(p + 1, q) : classPath.substring(0, q);
            return Vfs.lookup(resinJar).lookup("../..");
        }
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        URL url = loader.getResource("com/caucho/boot/ResinBoot.class");
        String path = url.toString();
        if (!path.startsWith("jar:")) {
            throw new RuntimeException(WatchdogArgs.L().l("Resin/{0}: can't find jar for ResinBoot in {1}", (Object)VersionFactory.getVersion(), path));
        }
        int p = path.indexOf(58);
        int q = path.indexOf(33);
        path = path.substring(p + 1, q);
        Path pwd = Vfs.lookup(path).getParent().getParent();
        return pwd;
    }

    static Path calculateResinRoot(Path resinHome) {
        String resinRoot = System.getProperty("resin.root");
        if (resinRoot != null) {
            return Vfs.lookup(resinRoot);
        }
        resinRoot = System.getProperty("server.root");
        if (resinRoot != null) {
            return Vfs.lookup(resinRoot);
        }
        return resinHome;
    }

    static String calculateClassPath(Path resinHome) throws IOException {
        ArrayList<String> classPath = new ArrayList<String>();
        return WatchdogArgs.calculateClassPath(classPath, resinHome);
    }

    static String calculateClassPath(ArrayList<String> classPath, Path resinHome) throws IOException {
        Path resinLib;
        Path javaHome;
        String oldClassPath = System.getProperty("java.class.path");
        if (oldClassPath != null) {
            for (String item : oldClassPath.split("[" + File.pathSeparatorChar + "]")) {
                WatchdogArgs.addClassPath(classPath, item);
            }
        }
        if ((oldClassPath = System.getenv("CLASSPATH")) != null) {
            for (String item : oldClassPath.split("[" + File.pathSeparatorChar + "]")) {
                WatchdogArgs.addClassPath(classPath, item);
            }
        }
        if ((javaHome = Vfs.lookup(System.getProperty("java.home"))).lookup("lib/tools.jar").canRead()) {
            WatchdogArgs.addClassPath(classPath, javaHome.lookup("lib/tools.jar").getNativePath());
        } else if (javaHome.getTail().startsWith("jre")) {
            String tail = javaHome.getTail();
            tail = "jdk" + tail.substring(3);
            Path jdkHome = javaHome.getParent().lookup(tail);
            if (jdkHome.lookup("lib/tools.jar").canRead()) {
                WatchdogArgs.addClassPath(classPath, jdkHome.lookup("lib/tools.jar").getNativePath());
            }
        }
        if (javaHome.lookup("../lib/tools.jar").canRead()) {
            WatchdogArgs.addClassPath(classPath, javaHome.lookup("../lib/tools.jar").getNativePath());
        }
        if ((resinLib = resinHome.lookup("lib")).lookup("pro.jar").canRead()) {
            WatchdogArgs.addClassPath(classPath, resinLib.lookup("pro.jar").getNativePath());
        }
        WatchdogArgs.addClassPath(classPath, resinLib.lookup("resin.jar").getNativePath());
        String[] list = resinLib.list();
        for (int i = 0; i < list.length; ++i) {
            Path item;
            String pathName;
            if (!list[i].endsWith(".jar") || classPath.contains(pathName = (item = resinLib.lookup(list[i])).getNativePath())) continue;
            WatchdogArgs.addClassPath(classPath, pathName);
        }
        String cp = "";
        for (int i = 0; i < classPath.size(); ++i) {
            if (!"".equals(cp)) {
                cp = cp + File.pathSeparatorChar;
            }
            cp = cp + classPath.get(i);
        }
        return cp;
    }

    private static void addClassPath(ArrayList<String> cp, String item) {
        if (!cp.contains(item)) {
            cp.add(item);
        }
    }

    static {
        log = Logger.getLogger(WatchdogArgs.class.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum StartMode {
        CONSOLE,
        DEPLOY,
        STATUS,
        START,
        GUI,
        STOP,
        KILL,
        RESTART,
        SHUTDOWN;

    }

    public class ResinBootELContext
    extends ResinELContext {
        private boolean _isLicenseCheck;
        private boolean _isResinProfessional;

        public Path getResinHome() {
            return WatchdogArgs.this.getResinHome();
        }

        public Path getRootDirectory() {
            return WatchdogArgs.this.getRootDirectory();
        }

        public Path getResinConf() {
            return WatchdogArgs.this.getResinConf();
        }

        public String getServerId() {
            return WatchdogArgs.this.getServerId();
        }

        public boolean isResinProfessional() {
            return this.isProfessional();
        }

        public boolean isProfessional() {
            this.loadLicenses();
            return this._isResinProfessional;
        }

        private void loadLicenses() {
            if (this._isLicenseCheck) {
                return;
            }
            this._isLicenseCheck = true;
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> cl = Class.forName("com.caucho.license.LicenseCheckImpl", false, loader);
                LicenseCheck license = (LicenseCheck)cl.newInstance();
                license.requireProfessional(1);
                Vfs.initJNI();
                this._isResinProfessional = true;
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
    }
}

