/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.PidQuery;
import com.caucho.boot.WatchdogChild;
import com.caucho.boot.WatchdogChildProcess;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.thread.ThreadPool;
import com.caucho.lifecycle.Lifecycle;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

class WatchdogChildTask
implements Runnable {
    private static final Logger log = Logger.getLogger(WatchdogChildTask.class.getName());
    private final ResinSystem _system;
    private final WatchdogChild _watchdog;
    private final Lifecycle _lifecycle = new Lifecycle();
    private WatchdogChildProcess _process;

    WatchdogChildTask(ResinSystem system, WatchdogChild watchdog) {
        this._system = system;
        this._watchdog = watchdog;
        if (watchdog == null) {
            throw new NullPointerException();
        }
    }

    boolean isActive() {
        return this._lifecycle.isActive();
    }

    String getState() {
        return this._lifecycle.getStateName();
    }

    int getPid() {
        WatchdogChildProcess process = this._process;
        if (process == null) {
            return 0;
        }
        int pid = process.getPid();
        if (pid > 0) {
            return pid;
        }
        PidQuery pidQuery = new PidQuery();
        try {
            PidQuery result = (PidQuery)process.queryGet(pidQuery);
            if (result != null) {
                return result.getPid();
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return 0;
    }

    Serializable queryGet(Serializable payload) {
        WatchdogChildProcess process = this._process;
        if (process != null) {
            return process.queryGet(payload);
        }
        return null;
    }

    public void start() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        ThreadPool.getCurrent().schedule(this);
    }

    public void stop() {
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        WatchdogChildProcess process = this._process;
        this._process = null;
        if (process != null) {
            process.stop();
            process.waitForExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Thread thread = Thread.currentThread();
            thread.setName("watchdog-" + this._watchdog.getId());
            int i = 0;
            long retry = Long.MAX_VALUE;
            while (this._lifecycle.isActive() && (long)i++ < retry) {
                String id = String.valueOf(i);
                this._watchdog.notifyTaskStarted();
                log.info(this._watchdog + " starting");
                this._process = new WatchdogChildProcess(id, this._system, this._watchdog);
                try {
                    this._process.run();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
                finally {
                    WatchdogChildProcess process = this._process;
                    this._process = null;
                    if (process == null) continue;
                    process.kill();
                }
            }
            log.info(this._watchdog + " stopped");
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            this._lifecycle.toDestroy();
            this._watchdog.completeTask(this);
        }
    }

    void kill() {
        this._lifecycle.toDestroy();
        WatchdogChildProcess process = this._process;
        this._process = null;
        if (process != null) {
            process.kill();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._watchdog + "]";
    }
}

