/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bootjni;

import com.caucho.config.ConfigException;
import com.caucho.inject.Module;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.JniTroubleshoot;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class JniProcess
extends Process {
    private static final L10N L = new L10N(JniProcess.class);
    private static final JniTroubleshoot _jniTroubleshoot;
    private int _stdoutFd = -1;
    private int _pid = -1;
    private int _status = -1;
    private ReadStream _is;

    public JniProcess() {
    }

    private JniProcess(ArrayList<String> args, HashMap<String, String> env, String chroot, String pwd, String user, String group) {
        String[] argv = new String[args.size()];
        args.toArray(argv);
        String[] envp = new String[env.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : env.entrySet()) {
            envp[i++] = entry.getKey() + '=' + entry.getValue();
        }
        int fdMax = JniProcess.setFdMax();
        if (CauchoSystem.isUnix() && fdMax <= 0) {
            System.out.println(L.l("process file descriptors: {0}", fdMax));
        }
        if (!this.exec(argv, envp, chroot, pwd, user, group)) {
            throw new IllegalStateException("exec failed");
        }
        int stdoutFd = this._stdoutFd;
        this._stdoutFd = -1;
        try {
            Class<?> cl = Class.forName("com.caucho.vfs.JniFileStream", false, this.getClass().getClassLoader());
            Constructor<?> ctor = cl.getConstructor(Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
            StreamImpl stream = (StreamImpl)ctor.newInstance(stdoutFd, true, false);
            this._is = new ReadStream(stream);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public JniProcess create(ArrayList<String> args, HashMap<String, String> env, String chroot, String pwd, String user, String group) {
        _jniTroubleshoot.checkIsValid();
        assert (this.isNativeBootAvailable());
        return new JniProcess(args, env, chroot, pwd, user, group);
    }

    public boolean isEnabled() {
        return _jniTroubleshoot.isEnabled() && this.isNativeBootAvailable();
    }

    public String getTroubleshootMessage() {
        return _jniTroubleshoot.getMessage();
    }

    @Override
    public OutputStream getOutputStream() {
        return new NullOutputStream();
    }

    @Override
    public InputStream getInputStream() {
        return this._is;
    }

    @Override
    public InputStream getErrorStream() {
        return this.getInputStream();
    }

    public int getPid() {
        return this._pid;
    }

    public void chown(String path, String user, String group) {
        _jniTroubleshoot.checkIsValid();
        byte[] name = path.getBytes();
        int len = name.length;
        this.nativeChown(name, len, user, group);
    }

    @Override
    public int waitFor() {
        int pid = this._pid;
        this._pid = 0;
        if (pid > 0) {
            this._status = this.waitpid(pid, true);
        }
        return this._status;
    }

    @Override
    public int exitValue() {
        if (this._status >= 0) {
            return this._status;
        }
        if (this._pid > 0) {
            int result = this.waitpid(this._pid, false);
            if (result < 0) {
                throw new IllegalThreadStateException("Pid " + this._pid + " not yet closed");
            }
            this._pid = 0;
            this._status = result;
        }
        return this._status;
    }

    @Override
    public void destroy() {
    }

    public native boolean isNativeBootAvailable();

    public native boolean clearSaveOnExec();

    public static native int getFdMax();

    public static native int setFdMax();

    private native boolean exec(String[] var1, String[] var2, String var3, String var4, String var5, String var6);

    private native void nativeChown(byte[] var1, int var2, String var3, String var4);

    private native int waitpid(int var1, boolean var2);

    static {
        JniTroubleshoot jniTroubleshoot = null;
        try {
            System.loadLibrary("resin_os");
            jniTroubleshoot = new JniTroubleshoot(JniProcess.class, "resin_os");
        }
        catch (Throwable e) {
            jniTroubleshoot = new JniTroubleshoot(JniProcess.class, "resin_os", e);
        }
        _jniTroubleshoot = jniTroubleshoot;
    }

    static class NullOutputStream
    extends OutputStream {
        NullOutputStream() {
        }

        public void write(int ch) {
        }

        public void flush() {
        }

        public void close() {
        }
    }
}

