/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JClassLoader;
import com.caucho.bytecode.JType;
import com.caucho.bytecode.JavaClass;
import com.caucho.bytecode.TypeSignatureParser;
import com.caucho.util.L10N;
import java.net.URL;
import java.util.logging.Logger;

public class JavaClassLoader
extends JClassLoader {
    protected static final L10N L = new L10N(JavaClassLoader.class);
    protected static final Logger log = Logger.getLogger(JavaClassLoader.class.getName());
    private ClassLoader _loader;

    public JavaClassLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public JavaClassLoader(ClassLoader loader) {
        this._loader = loader;
    }

    protected JClass loadClass(String name) {
        if (name.startsWith("java.") || name.startsWith("java/")) {
            return JavaClassLoader.getStaticClassLoader().forName(name);
        }
        String classPath = name.replace('.', '/') + ".class";
        URL url = this._loader.getResource(classPath);
        if (url != null) {
            JavaClass jClass = new JavaClass(this);
            jClass.setURL(url);
            jClass.setThisClass(name.replace('.', '/'));
            return jClass;
        }
        return null;
    }

    protected JType parseParameterizedType(String type) {
        return new TypeSignatureParser(this, type).nextType();
    }

    public String toString() {
        return "JavaClassLoader[]";
    }
}

