/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.bam;

import com.caucho.bam.Broker;
import com.caucho.env.service.AbstractResinService;
import com.caucho.env.service.ResinSystem;
import com.caucho.hemp.broker.DomainManager;
import com.caucho.hemp.broker.HempBroker;
import com.caucho.hemp.broker.HempBrokerManager;
import com.caucho.hemp.servlet.ServerAuthManager;
import com.caucho.util.L10N;

public class BamService
extends AbstractResinService {
    public static final int START_PRIORITY = 40;
    private static final L10N L = new L10N(BamService.class);
    private String _jid;
    private final HempBrokerManager _brokerManager;
    private final HempBroker _broker;
    private ServerAuthManager _linkManager;

    public BamService() {
        this(null);
    }

    public BamService(String jid) {
        this._jid = jid;
        this._brokerManager = new HempBrokerManager();
        this._broker = new HempBroker(this._brokerManager, this.getJid());
        if (this.getJid() != null) {
            this._brokerManager.addBroker(this.getJid(), this._broker);
        }
        this._brokerManager.addBroker("resin.caucho", this._broker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BamService create(String jid) {
        ResinSystem server = ResinSystem.getCurrent();
        if (server == null) {
            throw new IllegalStateException(L.l("NetworkServer is not active in {0}", Thread.currentThread().getContextClassLoader()));
        }
        ResinSystem resinSystem = server;
        synchronized (resinSystem) {
            BamService service = server.getService(BamService.class);
            if (service == null) {
                service = new BamService(jid);
                server.addService(service);
            }
            return service;
        }
    }

    public static BamService getCurrent() {
        ResinSystem server = ResinSystem.getCurrent();
        if (server != null) {
            return server.getService(BamService.class);
        }
        return null;
    }

    public String getJid() {
        return this._jid;
    }

    public Broker getBroker() {
        return this._broker;
    }

    public void setDomainManager(DomainManager manager) {
        this._broker.setDomainManager(manager);
    }

    public void setLinkManager(ServerAuthManager linkManager) {
        this._linkManager = linkManager;
    }

    public ServerAuthManager getLinkManager() {
        return this._linkManager;
    }

    public int getStartPriority() {
        return 40;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._jid + "]";
    }
}

