/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.hmtp;

import com.caucho.bam.ActorStream;
import com.caucho.bam.Broker;
import com.caucho.cloud.bam.BamService;
import com.caucho.cloud.hmtp.HmtpLinkActor;
import com.caucho.hemp.broker.HempMemoryQueue;
import com.caucho.hessian.io.HessianDebugInputStream;
import com.caucho.hmtp.HmtpReader;
import com.caucho.hmtp.HmtpWriter;
import com.caucho.network.listen.AbstractProtocolConnection;
import com.caucho.network.listen.SocketLink;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HmtpRequest
extends AbstractProtocolConnection {
    private static final L10N L = new L10N(HmtpRequest.class);
    private static final Logger log = Logger.getLogger(HmtpRequest.class.getName());
    public static final int HMUX_TO_UNIDIR_HMTP = 55;
    public static final int HMUX_SWITCH_TO_HMTP = 56;
    public static final int HMUX_HMTP_OK = 57;
    private SocketLink _conn;
    private BamService _bamService;
    private ReadStream _rawRead;
    private WriteStream _rawWrite;
    private boolean _isFirst;
    private HmtpReader _hmtpReader;
    private HmtpWriter _hmtpWriter;
    private ActorStream _linkStream;
    private HmtpLinkActor _linkActor;

    public HmtpRequest(SocketLink conn, BamService bamService) {
        this._conn = conn;
        this._bamService = bamService;
        this._rawRead = conn.getReadStream();
        this._rawWrite = conn.getWriteStream();
    }

    public boolean isWaitForRead() {
        return true;
    }

    public void onStartConnection() {
        this._isFirst = true;
    }

    public boolean handleRequest() throws IOException {
        try {
            if (this._isFirst) {
                return this.handleInitialRequest();
            }
            return this.dispatchHmtp();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    private boolean handleInitialRequest() throws IOException {
        this._isFirst = false;
        ReadStream is = this._rawRead;
        int ch = is.read();
        if (ch < 0) {
            return false;
        }
        boolean isUnidir = false;
        if (ch == 55) {
            isUnidir = true;
        } else if (ch == 56) {
            isUnidir = false;
        } else {
            throw new UnsupportedOperationException(L.l("0x{0} is an invalid HMUX code.", Integer.toHexString(ch)));
        }
        int len = (is.read() << 8) + is.read();
        boolean isAdmin = is.read() != 0;
        InputStream rawIs = is;
        if (log.isLoggable(Level.FINEST)) {
            HessianDebugInputStream dIs = new HessianDebugInputStream(is, log, Level.FINEST);
            dIs.startStreaming();
            rawIs = dIs;
        }
        if (this._hmtpReader != null) {
            this._hmtpReader.init(rawIs);
        } else {
            this._hmtpReader = new HmtpReader(rawIs);
            this._hmtpReader.setId(this.getRequestId());
        }
        if (this._hmtpWriter != null) {
            this._hmtpWriter.init(this._rawWrite);
        } else {
            this._hmtpWriter = new HmtpWriter(this._rawWrite);
            this._hmtpWriter.setAutoFlush(true);
        }
        Broker broker = this._bamService.getBroker();
        ActorStream brokerStream = broker.getBrokerStream();
        this._hmtpWriter.setJid("hmtp-server-" + this._conn.getId() + "-hmtp");
        this._linkStream = new HempMemoryQueue(this._hmtpWriter, brokerStream, 1);
        this._linkActor = new HmtpLinkActor(this._linkStream, broker, this._bamService.getLinkManager(), this._conn.getRemoteHost(), isUnidir);
        return this.dispatchHmtp();
    }

    private boolean dispatchHmtp() throws IOException {
        HmtpReader in = this._hmtpReader;
        do {
            ActorStream brokerStream;
            if (in.readPacket(brokerStream = this._linkActor.getBrokerStream())) continue;
            return false;
        } while (in.isDataAvailable());
        return true;
    }

    public void onCloseConnection() {
        HmtpWriter writer;
        HmtpLinkActor linkActor = this._linkActor;
        this._linkActor = null;
        ActorStream linkStream = this._linkStream;
        this._linkStream = null;
        if (linkActor != null) {
            linkActor.onCloseConnection();
        }
        if (linkStream != null) {
            linkStream.close();
        }
        if ((writer = this._hmtpWriter) != null) {
            writer.close();
        }
    }

    protected String getRequestId() {
        return "hmtp:" + this._conn.getId();
    }

    public final String dbgId() {
        return "Hmtp[" + this._conn.getId() + "] ";
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.dbgId();
    }
}

