/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.network;

import com.caucho.cloud.network.ClusterServerAdmin;
import com.caucho.cloud.network.NetworkClusterService;
import com.caucho.cloud.topology.CloudCluster;
import com.caucho.cloud.topology.CloudPod;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.cloud.topology.TriadOwner;
import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.types.Period;
import com.caucho.management.server.ClusterServerMXBean;
import com.caucho.network.balance.ClientSocketFactory;
import com.caucho.util.Alarm;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClusterServer {
    private static final Logger log = Logger.getLogger(ClusterServer.class.getName());
    private static final int[] DECODE = new int[128];
    private final NetworkClusterService _clusterService;
    private final CloudServer _cloudServer;
    private boolean _isDynamic;
    private String _serverClusterId;
    private String _serverDomainId;
    private String _bamJid;
    private String _address = "127.0.0.1";
    private int _port = -1;
    private boolean _isSSL;
    private int _loadBalanceConnectionMin = 0;
    private long _loadBalanceIdleTime = 60000L;
    private long _loadBalanceRecoverTime = 15000L;
    private long _loadBalanceSocketTimeout = 600000L;
    private long _loadBalanceWarmupTime = 60000L;
    private long _loadBalanceConnectTimeout = 5000L;
    private int _loadBalanceWeight = 100;
    private long _clusterIdleTime = 180000L;
    private ConfigProgram _portDefaults = new ContainerProgram();
    private ContainerProgram _serverProgram = new ContainerProgram();
    private String _stage;
    private ArrayList<String> _pingUrls = new ArrayList();
    private ClientSocketFactory _serverPool;
    private AtomicBoolean _isActive = new AtomicBoolean();
    private AtomicLong _stateTimestamp = new AtomicLong();
    private AtomicLong _lastHeartbeatTime = new AtomicLong();
    private ClusterServerAdmin _admin = new ClusterServerAdmin(this);

    ClusterServer(NetworkClusterService networkService, CloudServer cloudServer) {
        this._clusterService = networkService;
        if (networkService == null) {
            throw new NullPointerException();
        }
        this._cloudServer = cloudServer;
        cloudServer.getIndex();
        if (this._clusterService == null) {
            throw new NullPointerException();
        }
        try {
            this.setAddress(cloudServer.getAddress());
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
        this.setPort(cloudServer.getPort());
        if (cloudServer.getPod() != networkService.getSelfServer().getPod()) {
            this._isActive.set(true);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ClusterServer.convert(this.getIndex()));
        sb.append(ClusterServer.convert(this.getCloudPod().getIndex()));
        sb.append(ClusterServer.convert(this.getCloudPod().getIndex() / 64));
        this._serverClusterId = sb.toString();
        String clusterId = cloudServer.getCluster().getId();
        if (clusterId.equals("")) {
            clusterId = "default";
        }
        this._serverDomainId = this._serverClusterId + "." + clusterId.replace('.', '_');
        this._bamJid = this._serverDomainId + ".admin.resin";
    }

    public String getId() {
        return this._cloudServer.getId();
    }

    public String getDebugId() {
        if ("".equals(this.getId())) {
            return "default";
        }
        return this.getId();
    }

    public CloudServer getCloudServer() {
        return this._cloudServer;
    }

    public String getServerClusterId() {
        return this._serverClusterId;
    }

    public String getServerDomainId() {
        return this._serverDomainId;
    }

    public String getBamAdminName() {
        return this._bamJid;
    }

    public CloudCluster getCluster() {
        return this._cloudServer.getCluster();
    }

    public CloudPod getCloudPod() {
        return this._cloudServer.getPod();
    }

    public boolean isTriad() {
        return this._cloudServer.isTriad();
    }

    public TriadOwner getTriadOwner() {
        return TriadOwner.getOwner(this.getIndex());
    }

    public int getIndex() {
        return this._cloudServer.getIndex();
    }

    @Configurable
    public void setAddress(String address) throws UnknownHostException {
        if ("*".equals(address)) {
            address = null;
        }
        this._address = address;
        if (address != null) {
            InetAddress.getByName(address);
        }
    }

    public String getAddress() {
        return this._address;
    }

    public boolean isSSL() {
        return this._isSSL;
    }

    public void setBackup(boolean isBackup) {
        if (isBackup) {
            this.setLoadBalanceWeight(1);
        }
    }

    public void setDynamic(boolean isDynamic) {
        this._isDynamic = isDynamic;
    }

    public boolean isDynamic() {
        return this._isDynamic;
    }

    public void setLoadBalanceConnectTimeout(Period period) {
        this._loadBalanceConnectTimeout = period.getPeriod();
    }

    public long getLoadBalanceConnectTimeout() {
        return this._loadBalanceConnectTimeout;
    }

    @Configurable
    public void setLoadBalanceConnectionMin(int min) {
        this._loadBalanceConnectionMin = min;
    }

    public int getLoadBalanceConnectionMin() {
        return this._loadBalanceConnectionMin;
    }

    public void setLoadBalanceSocketTimeout(Period period) {
        this._loadBalanceSocketTimeout = period.getPeriod();
    }

    public long getLoadBalanceSocketTimeout() {
        return this._loadBalanceSocketTimeout;
    }

    public void setLoadBalanceIdleTime(Period period) {
        this._loadBalanceIdleTime = period.getPeriod();
    }

    public long getLoadBalanceIdleTime() {
        return this._loadBalanceIdleTime;
    }

    public void setLoadBalanceRecoverTime(Period period) {
        this._loadBalanceRecoverTime = period.getPeriod();
    }

    public long getLoadBalanceRecoverTime() {
        return this._loadBalanceRecoverTime;
    }

    public long getClusterIdleTime() {
        return this._clusterIdleTime;
    }

    public void setAcceptListenBacklog(ConfigProgram program) {
        this._portDefaults.addProgram(program);
    }

    public void setAcceptThreadMin(ConfigProgram program) throws ConfigException {
        this._portDefaults.addProgram(program);
    }

    public void setAcceptThreadMax(ConfigProgram program) throws ConfigException {
        this._portDefaults.addProgram(program);
    }

    public void setConnectionMax(ConfigProgram program) {
        this._portDefaults.addProgram(program);
    }

    public void setKeepaliveMax(ConfigProgram program) {
        this._portDefaults.addProgram(program);
    }

    public void setKeepaliveTimeout(ConfigProgram program) {
        this._portDefaults.addProgram(program);
    }

    public void setKeepaliveConnectionTimeMax(ConfigProgram program) {
        this._portDefaults.addProgram(program);
    }

    public void setKeepaliveSelectEnable(ConfigProgram program) {
        this._portDefaults.addProgram(program);
    }

    public void setKeepaliveSelectMax(ConfigProgram program) {
        this._portDefaults.addProgram(program);
    }

    public void setKeepaliveSelectThreadTimeout(ConfigProgram program) {
        this._portDefaults.addProgram(program);
    }

    public void setSocketTimeout(ConfigProgram program) {
        this._portDefaults.addProgram(program);
    }

    public void setSuspendTimeMax(ConfigProgram program) {
        this._portDefaults.addProgram(program);
    }

    public void setStage(String stage) {
        this._stage = stage;
    }

    public String getStage() {
        return this._stage;
    }

    public void addPingUrl(String url) {
        this._pingUrls.add(url);
    }

    public ArrayList<String> getPingUrlList() {
        return this._pingUrls;
    }

    public void setLoadBalanceWarmupTime(Period period) {
        this._loadBalanceWarmupTime = period.getPeriod();
    }

    public long getLoadBalanceWarmupTime() {
        return this._loadBalanceWarmupTime;
    }

    public void setLoadBalanceWeight(int weight) {
        this._loadBalanceWeight = weight;
    }

    public int getLoadBalanceWeight() {
        return this._loadBalanceWeight;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public int getPort() {
        return this._port;
    }

    public boolean isSelf() {
        return this._clusterService.getSelfServer() == this.getCloudServer();
    }

    public final ClientSocketFactory getServerPool() {
        return this._serverPool;
    }

    public final boolean isActiveRemote() {
        ClientSocketFactory pool = this._serverPool;
        return pool != null && pool.isActive();
    }

    public void addPortDefault(ContainerProgram program) {
        this._portDefaults.addProgram(program);
    }

    public void addContentProgram(ConfigProgram program) {
        this._serverProgram.addProgram(program);
    }

    public ConfigProgram getServerProgram() {
        return this._serverProgram;
    }

    public ConfigProgram getPortDefaults() {
        return this._portDefaults;
    }

    public void init() {
        if (this.getCloudServer() != this._clusterService.getSelfServer() && this.getCloudServer().getPort() >= 0) {
            this._serverPool = this.createServerPool(this._clusterService.getServerId());
            this._serverPool.init();
        }
        this._admin.register();
    }

    private ClientSocketFactory createServerPool(String serverId) {
        ClientSocketFactory pool = new ClientSocketFactory(serverId, this.getId(), "Resin|Cluster", this.getStatId(), this.getAddress(), this.getPort(), this.isSSL());
        pool.setLoadBalanceConnectTimeout(this.getLoadBalanceConnectTimeout());
        pool.setLoadBalanceConnectionMin(this.getLoadBalanceConnectionMin());
        pool.setLoadBalanceSocketTimeout(this.getLoadBalanceSocketTimeout());
        pool.setLoadBalanceIdleTime(this.getClusterIdleTime());
        pool.setLoadBalanceRecoverTime(this.getLoadBalanceRecoverTime());
        pool.setLoadBalanceWarmupTime(this.getLoadBalanceWarmupTime());
        pool.setLoadBalanceWeight(this.getLoadBalanceWeight());
        return pool;
    }

    private String getStatId() {
        String targetCluster = this.getCluster().getId();
        if ("".equals(targetCluster)) {
            targetCluster = "default";
        }
        int index = this.getIndex();
        return String.format("%02x:%s", index, targetCluster);
    }

    public boolean isActive() {
        return this._isActive.get();
    }

    public long getStateTimestamp() {
        return this._stateTimestamp.get();
    }

    public long getLastHeartbeatTime() {
        return this._lastHeartbeatTime.get();
    }

    public boolean notifyStart() {
        long now = Alarm.getCurrentTime();
        this._lastHeartbeatTime.set(now);
        boolean isActive = this._isActive.getAndSet(true);
        if (isActive) {
            return false;
        }
        this._stateTimestamp.set(now);
        if (this._serverPool != null) {
            this._serverPool.notifyStart();
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " notify-start");
        }
        this._clusterService.notifyServerStart(this);
        return true;
    }

    public boolean notifyStop() {
        this._lastHeartbeatTime.set(0L);
        boolean isActive = this._isActive.getAndSet(false);
        if (!isActive) {
            return false;
        }
        this._stateTimestamp.set(Alarm.getCurrentTime());
        if (this._serverPool != null) {
            this._serverPool.notifyStop();
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " notify-stop");
        }
        this._clusterService.notifyServerStop(this);
        return true;
    }

    public void stopServer() {
        this._isActive.set(false);
        this._stateTimestamp.set(Alarm.getCurrentTime());
        if (this._serverPool != null) {
            this._serverPool.notifyStop();
        }
    }

    public void generateIdPrefix(StringBuilder cb) {
        cb.append(this.getServerClusterId());
    }

    public ClusterServerMXBean getAdmin() {
        return this._admin;
    }

    public void close() {
        if (this._serverPool != null) {
            this._serverPool.close();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.getId() + "]";
    }

    private static char convert(long code) {
        if ((code &= 0x3FL) < 26L) {
            return (char)(97L + code);
        }
        if (code < 52L) {
            return (char)(65L + code - 26L);
        }
        if (code < 62L) {
            return (char)(48L + code - 52L);
        }
        if (code == 62L) {
            return '_';
        }
        return '-';
    }

    public static int decode(int code) {
        return DECODE[code & 0x7F];
    }

    static {
        for (int i = 0; i < 64; ++i) {
            ClusterServer.DECODE[ClusterServer.convert((long)((long)i))] = i;
        }
    }
}

