/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.network;

import com.caucho.cloud.network.ClusterLinkListener;
import com.caucho.cloud.network.ClusterListener;
import com.caucho.cloud.network.ClusterServer;
import com.caucho.cloud.network.ClusterServerListener;
import com.caucho.cloud.network.ClusterServerProgram;
import com.caucho.cloud.topology.AbstractCloudClusterListener;
import com.caucho.cloud.topology.AbstractCloudPodListener;
import com.caucho.cloud.topology.AbstractCloudServerListener;
import com.caucho.cloud.topology.CloudCluster;
import com.caucho.cloud.topology.CloudPod;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.cloud.topology.CloudSystem;
import com.caucho.cloud.topology.TopologyService;
import com.caucho.env.service.AbstractResinService;
import com.caucho.env.service.ResinSystem;
import com.caucho.network.balance.ClientSocketFactory;
import com.caucho.network.listen.SocketLinkListener;
import com.caucho.server.hmux.HmuxProtocol;
import com.caucho.util.L10N;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetworkClusterService
extends AbstractResinService {
    private static final L10N L = new L10N(NetworkClusterService.class);
    private static final Logger log = Logger.getLogger(NetworkClusterService.class.getName());
    public static final int START_PRIORITY = 41;
    private final CloudServer _selfServer;
    private SocketLinkListener _clusterListener;
    private CopyOnWriteArrayList<ClusterServerListener> _serverListeners = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<ClusterLinkListener> _linkListeners = new CopyOnWriteArrayList();

    public NetworkClusterService(CloudServer selfServer) {
        this._selfServer = selfServer;
        this._selfServer.getSystem().addClusterListener(new NetworkClusterListener());
        if (this._selfServer.getPort() >= 0) {
            this._clusterListener = new ClusterListener(this._selfServer.getAddress(), this._selfServer.getPort());
        }
    }

    public static NetworkClusterService getCurrent() {
        return ResinSystem.getCurrentService(NetworkClusterService.class);
    }

    public static CloudServer getCurrentSelfServer() {
        NetworkClusterService clusterService = NetworkClusterService.getCurrent();
        if (clusterService == null) {
            throw new IllegalStateException(L.l("{0} is not available in this context", NetworkClusterService.class.getSimpleName()));
        }
        return clusterService.getSelfServer();
    }

    public CloudServer getSelfServer() {
        return this._selfServer;
    }

    public String getServerId() {
        return this.getSelfServer().getId();
    }

    public SocketLinkListener getClusterListener() {
        return this._clusterListener;
    }

    public void addServerListener(ClusterServerListener listener) {
        this._serverListeners.add(listener);
        CloudServer[] serverList = this._selfServer.getPod().getServerList();
        int serverLength = this._selfServer.getPod().getServerLength();
        for (int i = 0; i < serverLength; ++i) {
            ClusterServer server;
            CloudServer cloudServer = serverList[i];
            if (cloudServer == null || !(server = cloudServer.getData(ClusterServer.class)).isActive()) continue;
            listener.serverStart(server);
        }
    }

    public void removeServerListener(ServerListener listener) {
        this._serverListeners.remove(listener);
    }

    protected void notifyServerStart(ClusterServer server) {
        for (ClusterServerListener listener : this._serverListeners) {
            listener.serverStart(server);
        }
    }

    protected void notifyServerStop(ClusterServer server) {
        for (ClusterServerListener listener : this._serverListeners) {
            listener.serverStop(server);
        }
    }

    public void addLinkListener(ClusterLinkListener listener) {
        this._linkListeners.add(listener);
    }

    public void notifyLinkClose(Object payload) {
        for (ClusterLinkListener listener : this._linkListeners) {
            listener.onLinkClose(payload);
        }
    }

    public int getStartPriority() {
        return 41;
    }

    public void start() throws Exception {
        super.start();
        this.startClusterListener();
        ClusterServer selfServer = this._selfServer.getData(ClusterServer.class);
        selfServer.notifyStart();
        CloudSystem cloudSystem = TopologyService.getCurrent().getSystem();
        for (CloudCluster cluster : cloudSystem.getClusterList()) {
            for (CloudPod pod : cluster.getPodList()) {
                int serverLength = pod.getServerLength();
                for (int i = 0; i < serverLength; ++i) {
                    ClientSocketFactory pool;
                    ClusterServer server;
                    CloudServer cloudServer = pod.getServerList()[i];
                    if (cloudServer == null || (server = cloudServer.getData(ClusterServer.class)) == null || (pool = server.getServerPool()) == null) continue;
                    pool.start();
                }
            }
        }
    }

    public void stop() throws Exception {
        super.stop();
        try {
            if (this._clusterListener != null) {
                this._clusterListener.close();
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    private void configureServer(CloudServer cloudServer) {
        CloudCluster cluster = cloudServer.getCluster();
        CloudPod pod = cloudServer.getPod();
        ClusterServerProgram clusterServerProgram = cluster.getData(ClusterServerProgram.class);
        ClusterServerProgram podServerProgram = pod.getData(ClusterServerProgram.class);
        ClusterServerProgram serverProgram = cloudServer.getData(ClusterServerProgram.class);
        ClusterServer server = new ClusterServer(this, cloudServer);
        if (clusterServerProgram != null) {
            clusterServerProgram.getProgram().configure(server);
        }
        if (podServerProgram != null) {
            podServerProgram.getProgram().configure(server);
        }
        if (serverProgram != null) {
            serverProgram.getProgram().configure(server);
        }
        if (cloudServer.putDataIfAbsent(server) != null) {
            throw new IllegalStateException(L.l("{0} cannot be configured twice.", server));
        }
        server.init();
    }

    private void startClusterListener() throws Exception {
        SocketLinkListener listener = this._clusterListener;
        if (listener != null) {
            listener.setProtocol(new HmuxProtocol());
            listener.init();
            log.info("");
            listener.bind();
            listener.start();
            log.info("");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._clusterListener + "]";
    }

    private class ServerListener
    extends AbstractCloudServerListener {
        private ServerListener() {
        }

        public void onServerAdd(CloudServer server) {
            NetworkClusterService.this.configureServer(server);
        }
    }

    private class PodListener
    extends AbstractCloudPodListener {
        private PodListener() {
        }

        public void onPodAdd(CloudPod pod) {
            pod.addServerListener(new ServerListener());
        }
    }

    private class NetworkClusterListener
    extends AbstractCloudClusterListener {
        private NetworkClusterListener() {
        }

        public void onClusterAdd(CloudCluster cluster) {
            cluster.addPodListener(new PodListener());
        }
    }
}

