/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.network;

import com.caucho.cloud.network.NetworkListenService;
import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.network.listen.AbstractProtocol;
import com.caucho.network.listen.SocketLinkListener;
import com.caucho.server.cluster.ProtocolPort;
import com.caucho.server.cluster.ProtocolPortConfig;
import com.caucho.server.http.HttpProtocol;

public class NetworkServerConfig {
    private NetworkListenService _listenService;
    private ContainerProgram _listenerDefaults = new ContainerProgram();

    NetworkServerConfig(NetworkListenService listenService) {
        this._listenService = listenService;
    }

    private NetworkListenService getListenService() {
        return this._listenService;
    }

    @Configurable
    public SocketLinkListener createClusterPort() {
        return this.getListenService().getClusterListener();
    }

    @Configurable
    public SocketLinkListener createHttp() throws ConfigException {
        SocketLinkListener listener = new SocketLinkListener();
        this.applyPortDefaults(listener);
        HttpProtocol protocol = new HttpProtocol();
        listener.setProtocol(protocol);
        this.getListenService().addListener(listener);
        return listener;
    }

    @Configurable
    public SocketLinkListener createProtocol() {
        ProtocolPortConfig port = new ProtocolPortConfig();
        this.getListenService().addListener(port);
        return port;
    }

    @Configurable
    public SocketLinkListener createListen() {
        ProtocolPortConfig listener = new ProtocolPortConfig();
        this.getListenService().addListener(listener);
        return listener;
    }

    @Configurable
    public void add(ProtocolPort protocolPort) {
        SocketLinkListener listener = new SocketLinkListener();
        AbstractProtocol protocol = protocolPort.getProtocol();
        listener.setProtocol(protocol);
        this.applyPortDefaults(listener);
        protocolPort.getConfigProgram().configure(listener);
        this.getListenService().addListener(listener);
    }

    @Configurable
    public void addPortDefault(ContainerProgram program) {
        this.addListenDefault(program);
    }

    @Configurable
    public void addListenDefault(ConfigProgram program) {
        this._listenerDefaults.addProgram(program);
    }

    @Configurable
    public void setBindPortsAfterStart(boolean bindAtEnd) {
        this.getListenService().setBindPortsAfterStart(bindAtEnd);
    }

    @Configurable
    public void addContentProgram(ConfigProgram builder) {
        this._listenerDefaults.addProgram(builder);
    }

    private void applyPortDefaults(SocketLinkListener port) {
        this._listenerDefaults.configure(port);
    }
}

