/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.security;

import com.caucho.config.AdminLiteral;
import com.caucho.config.inject.InjectManager;
import com.caucho.env.service.AbstractResinService;
import com.caucho.env.service.ResinSystem;
import com.caucho.security.Authenticator;
import com.caucho.security.DigestCredentials;
import com.caucho.util.Base64;
import com.caucho.util.L10N;
import java.lang.reflect.Type;
import java.security.MessageDigest;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityService
extends AbstractResinService {
    public static final int START_PRIORITY = 30;
    private static final L10N L = new L10N(SecurityService.class);
    private String _signatureSecret;
    private Authenticator _authenticator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecurityService create() {
        ResinSystem server = ResinSystem.getCurrent();
        if (server == null) {
            throw new IllegalStateException(L.l("ResinSystem is not active in {0}", Thread.currentThread().getContextClassLoader()));
        }
        ResinSystem resinSystem = server;
        synchronized (resinSystem) {
            SecurityService service = server.getService(SecurityService.class);
            if (service == null) {
                service = new SecurityService();
                server.addService(service);
            }
            return service;
        }
    }

    public static SecurityService getCurrent() {
        return ResinSystem.getCurrentService(SecurityService.class);
    }

    public void setSignatureSecret(String secret) {
        this._signatureSecret = secret;
    }

    public boolean isSystemAuthKey() {
        return this._signatureSecret != null;
    }

    public void setAuthenticator(Authenticator auth) {
        this._authenticator = auth;
    }

    public Authenticator getAuthenticator() {
        return this._authenticator;
    }

    public String signSystem(String uid, String nonce) {
        try {
            String password = null;
            password = this._signatureSecret;
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            if (uid != null) {
                digest.update(uid.getBytes("UTF-8"));
            }
            digest.update(nonce.getBytes("UTF-8"));
            if (password != null) {
                digest.update(password.getBytes("UTF-8"));
            }
            return Base64.encode(digest.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String sign(String uid, String nonce, String password) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            if (uid != null) {
                digest.update(uid.getBytes("UTF-8"));
            }
            digest.update(nonce.getBytes("UTF-8"));
            if (password != null) {
                digest.update(password.getBytes("UTF-8"));
            }
            return Base64.encode(digest.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] sign(byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(data);
            if (this._signatureSecret != null) {
                digest.update(this._signatureSecret.getBytes("UTF-8"));
            }
            return digest.digest();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DigestCredentials createCredentials(String user, String password, String nonce) {
        byte[] digest = this.createDigest(user, password, nonce);
        DigestCredentials cred = new DigestCredentials(user, nonce, digest);
        cred.setRealm("resin");
        return cred;
    }

    public byte[] createDigest(String user, String password, String nonce) {
        try {
            String realm = "resin";
            MessageDigest md = MessageDigest.getInstance("MD5");
            if (user != null) {
                md.update(user.getBytes("UTF-8"));
            }
            md.update((byte)58);
            md.update(realm.getBytes("UTF-8"));
            md.update((byte)58);
            if (password != null) {
                md.update(password.getBytes("UTF-8"));
            }
            byte[] digest = md.digest();
            md.reset();
            this.updateHex(md, digest);
            md.update((byte)58);
            md.update(nonce.getBytes("UTF-8"));
            return md.digest();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void updateHex(MessageDigest md, byte[] digest) {
        for (int i = 0; i < digest.length; ++i) {
            this.updateHex(md, digest[i] >> 4);
            this.updateHex(md, digest[i]);
        }
    }

    private void updateHex(MessageDigest md, int digit) {
        if ((digit &= 0xF) < 10) {
            md.update((byte)(digit + 48));
        } else {
            md.update((byte)(digit - 10 + 97));
        }
    }

    @Override
    public int getStartPriority() {
        return 30;
    }

    @Override
    public void start() {
        Bean<Authenticator> bean;
        InjectManager cdiManager = InjectManager.getCurrent();
        if (this._authenticator == null && (bean = this.findAuthenticator(cdiManager)) != null) {
            CreationalContext<Authenticator> env = cdiManager.createCreationalContext(bean);
            this._authenticator = (Authenticator)cdiManager.getReference(bean, (Type)((Object)Authenticator.class), env);
        }
    }

    private Bean<Authenticator> findAuthenticator(InjectManager cdiManager) {
        Set beans = cdiManager.getBeans((Type)((Object)Authenticator.class), new AdminLiteral());
        if (beans.size() > 0) {
            return cdiManager.resolve(beans);
        }
        return null;
    }
}

