/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.topology;

import com.caucho.cloud.topology.CloudCluster;
import com.caucho.cloud.topology.CloudClusterListener;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.util.L10N;
import java.util.concurrent.CopyOnWriteArrayList;

public class CloudSystem {
    private static final L10N L = new L10N(CloudSystem.class);
    private CloudCluster[] _clusterArray = new CloudCluster[0];
    private final String _id;
    private final CopyOnWriteArrayList<CloudClusterListener> _listeners = new CopyOnWriteArrayList();

    public CloudSystem(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public CloudCluster[] getClusterList() {
        return this._clusterArray;
    }

    public CloudCluster findCluster(String id) {
        for (CloudCluster cluster : this.getClusterList()) {
            if (!id.equals(cluster.getId())) continue;
            return cluster;
        }
        return null;
    }

    public CloudServer findServer(String id) {
        for (CloudCluster cluster : this.getClusterList()) {
            CloudServer server = cluster.findServer(id);
            if (server == null) continue;
            return server;
        }
        return null;
    }

    public CloudServer findServer(String address, int port) {
        for (CloudCluster cluster : this.getClusterList()) {
            CloudServer server = cluster.findServer(address, port);
            if (server == null) continue;
            return server;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloudCluster createCluster(String id) {
        CloudCluster cluster;
        CloudSystem cloudSystem = this;
        synchronized (cloudSystem) {
            cluster = this.findCluster(id);
            if (cluster != null) {
                throw new IllegalStateException(L.l("'{0}' is a duplicate cluster id", id));
            }
            cluster = new CloudCluster(this, id);
            CloudCluster[] clusterArray = new CloudCluster[this._clusterArray.length + 1];
            System.arraycopy(this._clusterArray, 0, clusterArray, 0, this._clusterArray.length);
            clusterArray[this._clusterArray.length] = cluster;
            this._clusterArray = clusterArray;
        }
        cluster.init();
        for (CloudClusterListener listener : this._listeners) {
            listener.onClusterAdd(cluster);
        }
        return cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCluster(String id) {
        CloudCluster cluster = null;
        CloudSystem cloudSystem = this;
        synchronized (cloudSystem) {
            int index;
            for (index = this._clusterArray.length - 1; index >= 0; --index) {
                if (!this._clusterArray[index].getId().equals(id)) continue;
                cluster = this._clusterArray[index];
                break;
            }
            if (cluster == null) {
                return false;
            }
            if (cluster.getPodList().length != 0) {
                throw new IllegalStateException(L.l("{0} may not be removed because it has a non-empty pod list", cluster));
            }
            CloudCluster[] clusterArray = new CloudCluster[this._clusterArray.length - 1];
            System.arraycopy(this._clusterArray, 0, clusterArray, 0, index);
            if (index < clusterArray.length) {
                System.arraycopy(this._clusterArray, index + 1, clusterArray, index, this._clusterArray.length - index - 1);
            }
            this._clusterArray = clusterArray;
        }
        for (CloudClusterListener listener : this._listeners) {
            listener.onClusterRemove(cluster);
        }
        cluster.destroy();
        return true;
    }

    public void addClusterListener(CloudClusterListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
        for (CloudCluster cluster : this.getClusterList()) {
            listener.onClusterAdd(cluster);
        }
    }

    public void removeClusterListener(CloudClusterListener listener) {
        this._listeners.remove(listener);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getId() + "]";
    }
}

