/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.topology;

import com.caucho.cloud.topology.CloudCluster;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.cloud.topology.CloudSystem;
import com.caucho.env.service.AbstractResinService;
import com.caucho.env.service.ResinSystem;
import com.caucho.util.L10N;

public class TopologyService
extends AbstractResinService {
    private static final L10N L = new L10N(TopologyService.class);
    public static final int START_PRIORITY = 40;
    private final CloudSystem _system;

    public TopologyService(String systemId) {
        this._system = new CloudSystem(systemId);
    }

    public static TopologyService getCurrent() {
        return ResinSystem.getCurrentService(TopologyService.class);
    }

    public static CloudSystem getCurrentSystem() {
        TopologyService topology = TopologyService.getCurrent();
        if (topology == null) {
            throw new IllegalStateException(L.l("{0} needs an active {1}", (Object)TopologyService.class.getSimpleName(), ResinSystem.class.getSimpleName()));
        }
        return topology.getSystem();
    }

    public static CloudCluster findCluster(String id) {
        TopologyService topology = TopologyService.getCurrent();
        if (topology == null) {
            throw new IllegalStateException(L.l("TopologyService must be active in the ResinSystem"));
        }
        return topology.getSystem().findCluster(id);
    }

    public static CloudServer findServer(String id) {
        TopologyService topology = TopologyService.getCurrent();
        if (topology == null) {
            throw new IllegalStateException(L.l("TopologyService must be active in the ResinSystem"));
        }
        return topology.getSystem().findServer(id);
    }

    public CloudSystem getSystem() {
        return this._system;
    }

    public int getStartPriority() {
        return 40;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._system + "]";
    }
}

