/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.attribute;

import com.caucho.config.ConfigException;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.TypeFactory;
import com.caucho.config.types.AnnotationConfig;
import com.caucho.config.xml.XmlBeanConfig;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.enterprise.context.spi.CreationalContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddAttribute<T>
extends Attribute {
    private static final L10N L = new L10N(AddAttribute.class);
    public static final AddAttribute<XmlBeanConfig> ATTR = new AddAttribute<XmlBeanConfig>(XmlBeanConfig.class);
    private final ConfigType<T> _configType;
    private final Method _setMethod;

    private AddAttribute(Class<T> cl) {
        this(null, TypeFactory.getType(cl));
    }

    public AddAttribute(Method setMethod, ConfigType<T> configType) {
        this._configType = configType;
        this._setMethod = setMethod;
    }

    public ConfigType<T> getConfigType() {
        return this._configType;
    }

    public Method getMethod() {
        return this._setMethod;
    }

    @Override
    public Object create(Object parent, QName qName) throws ConfigException {
        Class<?> cl = TypeFactory.loadClass(qName);
        if (cl == null) {
            ConfigType<?> type = TypeFactory.getFactory().getEnvironmentType(qName);
            if (type != null) {
                return type.create(parent, qName);
            }
            throw new ConfigException(L.l("'{0}.{1}' is an unknown class for element '{2}'", qName.getNamespaceURI(), qName.getLocalName(), qName));
        }
        if (Annotation.class.isAssignableFrom(cl)) {
            return new AnnotationConfig(cl);
        }
        XmlBeanConfig config = new XmlBeanConfig(qName, cl);
        config.setInlineBean(true);
        return config;
    }

    @Override
    public void setText(Object bean, QName name, String value) throws ConfigException {
        Object objValue = this.create(bean, name);
        if (objValue instanceof XmlBeanConfig) {
            XmlBeanConfig config = (XmlBeanConfig)objValue;
            if (!value.trim().equals("")) {
                config.addArg(new TextArgProgram(value));
            }
            config.init();
        }
        this.setValue(bean, name, objValue);
    }

    @Override
    public void setValue(Object bean, QName name, Object value) throws ConfigException {
        try {
            if (value instanceof XmlBeanConfig) {
                XmlBeanConfig config = (XmlBeanConfig)value;
                value = config.toObject();
            } else if (value instanceof AnnotationConfig) {
                AnnotationConfig config = (AnnotationConfig)value;
                value = config.replace();
            }
            if (this._setMethod != null && value != null) {
                if (!this._setMethod.getParameterTypes()[0].isAssignableFrom(value.getClass())) {
                    throw new ConfigException(L.l("'{0}.{1}' is not assignable from {2}", this._setMethod.getDeclaringClass().getSimpleName(), this._setMethod.getName(), value));
                }
                this._setMethod.invoke(bean, value);
            }
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TextArgProgram
    extends ConfigProgram {
        private String _arg;

        TextArgProgram(String arg) {
            this._arg = arg;
        }

        @Override
        public <T> void inject(T bean, CreationalContext<T> env) {
            throw new UnsupportedOperationException(this.getClass().getName());
        }

        public Object configure(ConfigType<?> type, CreationalContext<?> env) throws ConfigException {
            return type.valueOf(this._arg);
        }
    }
}

