/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.attribute;

import com.caucho.config.ConfigException;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.RawStringArrayType;
import com.caucho.config.type.RawStringType;
import com.caucho.config.type.TypeFactory;
import com.caucho.config.types.AnnotationConfig;
import com.caucho.util.L10N;
import com.caucho.xml.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationAttribute<T>
extends Attribute {
    private static final L10N L = new L10N(AnnotationAttribute.class);
    private String _name;
    private ConfigType<T> _type;

    public AnnotationAttribute(String name, Class<T> type, boolean isEL) {
        this._name = name;
        this._type = isEL ? TypeFactory.getType(type) : (String.class.equals(type) ? RawStringType.TYPE : (String[].class.equals(type) ? RawStringArrayType.TYPE : TypeFactory.getType(type)));
    }

    public ConfigType<T> getConfigType() {
        return this._type;
    }

    @Override
    public Object create(Object parent, QName name) throws ConfigException {
        return this._type.create(parent, name);
    }

    @Override
    public void setText(Object bean, QName name, String value) throws ConfigException {
        try {
            AnnotationConfig ann = (AnnotationConfig)bean;
            ann.setAttribute(name.getLocalName(), this._type.valueOf(value));
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    @Override
    public void setValue(Object bean, QName name, Object value) throws ConfigException {
        try {
            AnnotationConfig ann = (AnnotationConfig)bean;
            ann.setAttribute(name.getLocalName(), value);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }
}

