/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.bytecode;

import com.caucho.bytecode.CodeWriterAttribute;
import com.caucho.bytecode.JavaClass;
import com.caucho.bytecode.JavaClassLoader;
import com.caucho.bytecode.JavaField;
import com.caucho.bytecode.JavaMethod;
import com.caucho.config.ConfigException;
import com.caucho.config.bytecode.ScopeProxy;
import com.caucho.config.gen.CandiUtil;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.reflect.AnnotatedTypeUtil;
import com.caucho.config.reflect.BaseType;
import com.caucho.inject.Module;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.ProxyClassLoader;
import com.caucho.util.L10N;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Remove;
import javax.enterprise.inject.spi.Bean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class ScopeAdapter {
    private static final L10N L = new L10N(ScopeAdapter.class);
    private static final Logger log = Logger.getLogger(ScopeAdapter.class.getName());
    private final Class<?> _beanClass;
    private final Class<?> _cl;
    private final Class<?>[] _types;
    private Class<?> _proxyClass;
    private Constructor<?> _proxyCtor;
    private static HashMap<Class<?>, String> _prim = new HashMap();

    private ScopeAdapter(Class<?> beanClass, Class<?> cl, Class<?>[] types) {
        this._types = types;
        this._beanClass = beanClass;
        this._cl = cl;
        this.generateProxy(this._cl, types);
    }

    public static ScopeAdapter create(Bean<?> bean) {
        Set types = bean.getTypes();
        ArrayList classList = new ArrayList();
        Class beanClass = bean.getBeanClass();
        Class<?> cl = null;
        for (Type type : types) {
            Class<?> rawClass = CandiUtil.getRawClass(type);
            if (rawClass.equals(Object.class)) continue;
            classList.add(rawClass);
            if (cl != null && !cl.isAssignableFrom(rawClass) && (!cl.isInterface() || rawClass.isInterface()) && (!cl.getName().startsWith("java") || rawClass.getName().startsWith("java"))) continue;
            cl = rawClass;
        }
        Class[] classes = new Class[classList.size()];
        classList.toArray(classes);
        return new ScopeAdapter(beanClass, cl, classes);
    }

    public static ScopeAdapter create(Class<?> cl) {
        ScopeAdapter adapter = new ScopeAdapter(cl, cl, new Class[]{cl});
        return adapter;
    }

    public static void validateType(Type type) {
        BaseType baseType = InjectManager.getCurrent().createTargetBaseType(type);
        Class<?> rawType = baseType.getRawClass();
        if (rawType.isPrimitive()) {
            throw new ConfigException(L.l("'{0}' is an invalid @NormalScope bean because it's a Java primitive.", baseType));
        }
        if (rawType.isArray()) {
            throw new ConfigException(L.l("'{0}' is an invalid @NormalScope bean because it's a Java array.", baseType));
        }
    }

    public <X> X wrap(InjectManager.ReferenceFactory<X> factory) {
        try {
            Object v = this._proxyCtor.newInstance(factory);
            return (X)v;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    private void generateProxy(Class<?> cl, Class<?>[] types) {
        try {
            String typeClassName;
            String thisClassName;
            Constructor<?> zeroCtor = null;
            for (Constructor<?> ctorItem : cl.getDeclaredConstructors()) {
                if (ctorItem.getParameterTypes().length != 0) continue;
                zeroCtor = ctorItem;
                break;
            }
            if (zeroCtor == null && !cl.isInterface()) {
                throw new ConfigException(L.l("'{0}' does not have a zero-arg public or protected constructor.  Scope adapter components need a zero-arg constructor, e.g. @RequestScoped stored in @ApplicationScoped.", cl.getName()));
            }
            if (zeroCtor != null) {
                zeroCtor.setAccessible(true);
            }
            if ((thisClassName = (typeClassName = cl.getName().replace('.', '/')) + "__ResinScopeProxy").startsWith("java")) {
                thisClassName = "cdi/" + thisClassName;
            }
            String cleanName = thisClassName.replace('/', '.');
            boolean isPackagePrivate = false;
            if (!Modifier.isPublic(cl.getModifiers()) && !Modifier.isProtected(cl.getModifiers())) {
                isPackagePrivate = true;
            }
            DynamicClassLoader loader = isPackagePrivate ? (DynamicClassLoader)cl.getClassLoader() : (DynamicClassLoader)Thread.currentThread().getContextClassLoader();
            try {
                this._proxyClass = Class.forName(cleanName, false, loader);
            }
            catch (ClassNotFoundException e) {
                log.log(Level.FINEST, e.toString(), e);
            }
            if (this._proxyClass == null) {
                JavaClassLoader jLoader = new JavaClassLoader(cl.getClassLoader());
                JavaClass jClass = new JavaClass(jLoader);
                jClass.setAccessFlags(1);
                jClass.setWrite(true);
                jClass.setMajor(49);
                jClass.setMinor(0);
                String superClassName = !cl.isInterface() ? typeClassName : "java/lang/Object";
                jClass.setSuperClass(superClassName);
                jClass.setThisClass(thisClassName);
                for (Class<?> iface : types) {
                    if (!iface.isInterface()) continue;
                    jClass.addInterface(iface.getName().replace('.', '/'));
                }
                jClass.addInterface(ScopeProxy.class.getName().replace('.', '/'));
                JavaField factoryField = jClass.createField("_factory", "Lcom/caucho/config/inject/InjectManager$ReferenceFactory;");
                factoryField.setAccessFlags(2);
                JavaMethod ctor = jClass.createMethod("<init>", "(Lcom/caucho/config/inject/InjectManager$ReferenceFactory;)V");
                ctor.setAccessFlags(1);
                CodeWriterAttribute code = ctor.createCodeWriter();
                code.setMaxLocals(3);
                code.setMaxStack(4);
                code.pushObjectVar(0);
                code.pushObjectVar(1);
                code.putField(thisClassName, factoryField.getName(), factoryField.getDescriptor());
                code.pushObjectVar(0);
                code.invokespecial(superClassName, "<init>", "()V", 1, 0);
                code.addReturn();
                code.close();
                this.createGetDelegateMethod(jClass);
                this.createSerialize(jClass);
                for (Method method : this.getMethods(this._types)) {
                    if (Modifier.isStatic(method.getModifiers()) || Modifier.isFinal(method.getModifiers())) continue;
                    if (this.isRemoveMethod(this._beanClass, method)) {
                        this.createRemoveProxyMethod(jClass, method, method.getDeclaringClass().isInterface());
                        continue;
                    }
                    this.createProxyMethod(jClass, method, method.getDeclaringClass().isInterface());
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                WriteStream out = Vfs.openWrite(bos);
                jClass.write(out);
                out.close();
                byte[] buffer = bos.toByteArray();
                if (isPackagePrivate) {
                    this._proxyClass = loader.loadClass(cleanName, buffer);
                } else {
                    ProxyClassLoader proxyLoader = new ProxyClassLoader(loader);
                    this._proxyClass = proxyLoader.loadClass(cleanName, buffer);
                }
            }
            this._proxyCtor = this._proxyClass.getConstructors()[0];
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ArrayList<Method> getMethods(Class<?>[] types) {
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (Class<?> type : types) {
            if (Object.class.equals(type)) continue;
            for (Method method : type.getMethods()) {
                if (Modifier.isStatic(method.getModifiers()) || Modifier.isPrivate(method.getModifiers())) continue;
                Method oldMethod = AnnotatedTypeUtil.findMethod(methodList, method);
                if (oldMethod == null) {
                    methodList.add(method);
                    continue;
                }
                if (method.getDeclaringClass().isAssignableFrom(oldMethod.getDeclaringClass())) continue;
                methodList.remove(oldMethod);
                methodList.add(method);
            }
        }
        return methodList;
    }

    private boolean isRemoveMethod(Class<?> beanClass, Method method) {
        if (method.isAnnotationPresent(Remove.class)) {
            return true;
        }
        try {
            Method beanMethod = beanClass.getMethod(method.getName(), method.getParameterTypes());
            return beanMethod.isAnnotationPresent(Remove.class);
        }
        catch (Exception e) {
            log.log(Level.FINEST, e.toString(), e);
            return false;
        }
    }

    private void createProxyMethod(JavaClass jClass, Method method, boolean isInterface) {
        if (method.getName().equals("writeReplace") && method.getParameterTypes().length == 0) {
            return;
        }
        String descriptor = this.createDescriptor(method);
        JavaMethod jMethod = jClass.createMethod(method.getName(), descriptor);
        jMethod.setAccessFlags(1);
        Class<?>[] parameterTypes = method.getParameterTypes();
        CodeWriterAttribute code = jMethod.createCodeWriter();
        code.setMaxLocals(1 + 2 * parameterTypes.length);
        code.setMaxStack(3 + 2 * parameterTypes.length);
        code.pushObjectVar(0);
        code.getField(jClass.getThisClass(), "_factory", "Lcom/caucho/config/inject/InjectManager$ReferenceFactory;");
        code.invoke("com/caucho/config/inject/InjectManager$ReferenceFactory", "create", "()Ljava/lang/Object;", 3, 1);
        code.cast(method.getDeclaringClass().getName().replace('.', '/'));
        int stack = 1;
        int index = 1;
        for (Class<?> type : parameterTypes) {
            if (Boolean.TYPE.equals(type) || Byte.TYPE.equals(type) || Short.TYPE.equals(type) || Integer.TYPE.equals(type)) {
                code.pushIntVar(index);
                ++index;
                ++stack;
                continue;
            }
            if (Long.TYPE.equals(type)) {
                code.pushLongVar(index);
                index += 2;
                stack += 2;
                continue;
            }
            if (Float.TYPE.equals(type)) {
                code.pushFloatVar(index);
                ++index;
                ++stack;
                continue;
            }
            if (Double.TYPE.equals(type)) {
                code.pushDoubleVar(index);
                index += 2;
                stack += 2;
                continue;
            }
            code.pushObjectVar(index);
            ++index;
            ++stack;
        }
        if (isInterface) {
            code.invokeInterface(method.getDeclaringClass().getName().replace('.', '/'), method.getName(), this.createDescriptor(method), stack, 1);
        } else {
            code.invoke(method.getDeclaringClass().getName().replace('.', '/'), method.getName(), this.createDescriptor(method), stack, 1);
        }
        Class<?> retType = method.getReturnType();
        if (Boolean.TYPE.equals(retType) || Byte.TYPE.equals(retType) || Short.TYPE.equals(retType) || Integer.TYPE.equals(retType)) {
            code.addIntReturn();
        } else if (Long.TYPE.equals(retType)) {
            code.addLongReturn();
        } else if (Float.TYPE.equals(retType)) {
            code.addFloatReturn();
        } else if (Double.TYPE.equals(retType)) {
            code.addDoubleReturn();
        } else if (Void.TYPE.equals(retType)) {
            code.addReturn();
        } else {
            code.addObjectReturn();
        }
        code.close();
    }

    private void createRemoveProxyMethod(JavaClass jClass, Method method, boolean isInterface) {
        String descriptor = this.createDescriptor(method);
        JavaMethod jMethod = jClass.createMethod(method.getName(), descriptor);
        jMethod.setAccessFlags(1);
        Class<?>[] parameterTypes = method.getParameterTypes();
        CodeWriterAttribute code = jMethod.createCodeWriter();
        code.setMaxLocals(1 + 2 * parameterTypes.length);
        code.setMaxStack(3 + 2 * parameterTypes.length);
        code.newInstance("java/lang/UnsupportedOperationException");
        code.dup();
        code.invokespecial("java/lang/UnsupportedOperationException", "<init>", "()V", 3, 1);
        code.addThrow();
        code.close();
    }

    private void createGetDelegateMethod(JavaClass jClass) {
        String descriptor = "()Ljava/lang/Object;";
        JavaMethod jMethod = jClass.createMethod("__caucho_getDelegate", descriptor);
        jMethod.setAccessFlags(1);
        CodeWriterAttribute code = jMethod.createCodeWriter();
        code.setMaxLocals(1);
        code.setMaxStack(3);
        code.pushObjectVar(0);
        code.getField(jClass.getThisClass(), "_factory", "Lcom/caucho/config/inject/InjectManager$ReferenceFactory;");
        code.invoke("com/caucho/config/inject/InjectManager$ReferenceFactory", "create", "()Ljava/lang/Object;", 3, 1);
        code.addObjectReturn();
        code.close();
    }

    private void createSerialize(JavaClass jClass) {
        String descriptor = "()Ljava/lang/Object;";
        JavaMethod jMethod = jClass.createMethod("writeReplace", descriptor);
        jMethod.setAccessFlags(2);
        CodeWriterAttribute code = jMethod.createCodeWriter();
        code.setMaxLocals(1);
        code.setMaxStack(3);
        code.newInstance("com/caucho/config/bytecode/ScopeProxyHandle");
        code.dup();
        code.pushObjectVar(0);
        code.getField(jClass.getThisClass(), "_factory", "Lcom/caucho/config/inject/InjectManager$ReferenceFactory;");
        code.invokespecial("com/caucho/config/bytecode/ScopeProxyHandle", "<init>", "(Lcom/caucho/config/inject/InjectManager$ReferenceFactory;)V", 3, 1);
        code.addObjectReturn();
        code.close();
    }

    private String createDescriptor(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (Class<?> param : method.getParameterTypes()) {
            sb.append(this.createDescriptor(param));
        }
        sb.append(")");
        sb.append(this.createDescriptor(method.getReturnType()));
        return sb.toString();
    }

    private String createDescriptor(Class<?> cl) {
        if (cl.isArray()) {
            return "[" + this.createDescriptor(cl.getComponentType());
        }
        String primValue = _prim.get(cl);
        if (primValue != null) {
            return primValue;
        }
        return "L" + cl.getName().replace('.', '/') + ";";
    }

    static {
        _prim.put(Boolean.TYPE, "Z");
        _prim.put(Byte.TYPE, "B");
        _prim.put(Character.TYPE, "C");
        _prim.put(Short.TYPE, "S");
        _prim.put(Integer.TYPE, "I");
        _prim.put(Long.TYPE, "J");
        _prim.put(Float.TYPE, "F");
        _prim.put(Double.TYPE, "D");
        _prim.put(Void.TYPE, "V");
    }
}

