/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.event;

import com.caucho.inject.Module;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import javax.enterprise.event.Event;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Qualifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class EventImpl<T>
implements Event<T>,
Serializable {
    private static final L10N L = new L10N(EventImpl.class);
    private final BeanManager _manager;
    private final Type _type;
    private final Annotation[] _bindings;

    public EventImpl(BeanManager manager, Type type, Annotation[] bindings) {
        this._manager = manager;
        this._type = type;
        this._bindings = bindings;
    }

    public void fire(T event) {
        this._manager.fireEvent(event, this._bindings);
    }

    public Event<T> select(Annotation ... bindings) {
        if (bindings == null) {
            return this;
        }
        this.validateBindings(bindings);
        return new EventImpl<T>(this._manager, this._type, bindings);
    }

    public <U extends T> Event<U> select(Class<U> subtype, Annotation ... bindings) {
        this.validateType(subtype);
        this.validateBindings(bindings);
        return new EventImpl<T>(this._manager, subtype, bindings);
    }

    public <U extends T> Event<U> select(TypeLiteral<U> subtype, Annotation ... bindings) {
        this.validateType(subtype.getType());
        this.validateBindings(bindings);
        return new EventImpl<T>(this._manager, subtype.getType(), bindings);
    }

    private void validateType(Type type) {
        if (type instanceof Class) {
            Class cl = (Class)type;
            if (cl.getTypeParameters().length > 0) {
                throw new IllegalArgumentException(L.l("Generic class '{0}' is not allowed in select.", type));
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            for (Type param : pType.getActualTypeArguments()) {
                if (!(param instanceof TypeVariable)) continue;
                throw new IllegalArgumentException(L.l("Generic class '{0}' is not allowed in select.", type));
            }
        }
    }

    private void validateBindings(Annotation ... bindings) {
        if (bindings == null) {
            return;
        }
        for (int i = 0; i < bindings.length; ++i) {
            Class<? extends Annotation> annType = bindings[i].annotationType();
            if (!annType.isAnnotationPresent(Qualifier.class)) {
                throw new IllegalArgumentException(L.l("select with non-@Qualifier annotation '{0}' is not allowed.", bindings[i]));
            }
            for (int j = i + 1; j < bindings.length; ++j) {
                if (!annType.equals(bindings[j].annotationType())) continue;
                throw new IllegalArgumentException(L.l("select with duplicate Qualifier '{0}' is not allowed.", bindings[i]));
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._type + "]";
    }
}

