/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.gen;

import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class AspectGeneratorUtil {
    public static void generateHeader(JavaWriter out, boolean isOverride, String accessModifier, String prefix, Method method, String suffix, Class<?>[] exnList) throws IOException {
        out.println();
        if (isOverride) {
            out.println("@Override");
        }
        if (accessModifier != null) {
            out.print(accessModifier);
            out.print(" ");
        }
        out.printClass(method.getReturnType());
        out.print(" ");
        out.print(prefix + method.getName() + suffix);
        out.print("(");
        Class<?>[] types = method.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            if (i != 0) {
                out.print(", ");
            }
            if (i == types.length - 1 && type.isArray() && method.isVarArgs()) {
                out.printClass(type.getComponentType());
                out.print("...");
            } else {
                out.printClass(type);
            }
            out.print(" a" + i);
        }
        out.println(")");
        AspectGeneratorUtil.generateThrows(out, exnList);
    }

    protected static void generateThrows(JavaWriter out, Class<?>[] exnCls) throws IOException {
        if (exnCls.length == 0) {
            return;
        }
        out.print(" throws ");
        for (int i = 0; i < exnCls.length; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.printClass(exnCls[i]);
        }
        out.println();
    }
}

