/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.gen;

import com.caucho.config.gen.AspectBeanFactory;
import com.caucho.config.gen.AspectGenerator;
import com.caucho.config.gen.CandiUtil;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.DependencyComponent;
import com.caucho.java.gen.GenClass;
import com.caucho.make.ClassDependency;
import com.caucho.make.VersionDependency;
import com.caucho.vfs.PersistentDependency;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public abstract class BeanGenerator<X>
extends GenClass {
    private final AnnotatedType<X> _beanType;
    private DependencyComponent _dependency = new DependencyComponent();

    protected BeanGenerator(String fullClassName, AnnotatedType<X> beanType) {
        super(fullClassName);
        this._beanType = beanType;
        this.addDependency(new VersionDependency());
        this.addDependency(beanType.getJavaClass());
    }

    public AnnotatedType<X> getBeanType() {
        return this._beanType;
    }

    protected void addDependency(PersistentDependency depend) {
        this._dependency.addDependency(depend);
    }

    protected void addDependency(Class<?> cl) {
        this._dependency.addDependency(new ClassDependency(cl));
    }

    public String getBeanClassName() {
        return this.getBeanType().getJavaClass().getName();
    }

    public String getViewClassName() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public boolean isRemote() {
        return false;
    }

    public boolean isProxy() {
        return false;
    }

    public ArrayList<AspectGenerator<X>> getMethods() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    protected abstract AspectBeanFactory<X> getAspectBeanFactory();

    public void introspect() {
    }

    public void generateClassStaticFields(JavaWriter out) throws IOException {
        out.println("private static final java.util.logging.Logger __caucho_log");
        out.println("  = java.util.logging.Logger.getLogger(\"" + this.getFullClassName() + "\");");
        out.println("private static RuntimeException __caucho_exception;");
        out.println();
        out.println("public static RuntimeException __caucho_getException()");
        out.println("{");
        out.println("  return __caucho_exception;");
        out.println("}");
    }

    public void generateDestroyViews(JavaWriter out) throws IOException {
    }

    public void generateContextObjectConstructor(JavaWriter out) throws IOException {
    }

    public void generateTimer(JavaWriter out) throws IOException {
    }

    public void generateFreeInstance(JavaWriter out, String name) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void generateDestroy(JavaWriter out, HashMap<String, Object> map) throws IOException {
        this.generatePreDestroy(out, map);
        out.println();
        out.println("public void __caucho_destroy(com.caucho.config.inject.CreationalContextImpl env)");
        out.println("{");
        out.pushDepth();
        this.generateDestroyImpl(out);
        out.println("__caucho_preDestroy();");
        out.popDepth();
        out.println("}");
    }

    protected void generateDestroyImpl(JavaWriter out) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (AspectGenerator<X> method : this.getMethods()) {
            method.generateDestroy(out, map);
        }
    }

    public void generateProxyConstructor(JavaWriter out) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.generateProxyConstructor(out, map);
    }

    public void generateProxyConstructor(JavaWriter out, HashMap<String, Object> map) throws IOException {
        for (AspectGenerator<X> method : this.getMethods()) {
            method.generateProxyConstructor(out, map);
        }
    }

    public void generateBeanConstructor(JavaWriter out) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.generateBeanConstructor(out, map);
    }

    public void generateBeanConstructor(JavaWriter out, HashMap<String, Object> map) throws IOException {
        for (AspectGenerator<X> method : this.getMethods()) {
            method.generateBeanConstructor(out, map);
        }
    }

    public void generateBeanPrologue(JavaWriter out, HashMap<String, Object> map) throws IOException {
        for (AspectGenerator<X> method : this.getMethods()) {
            method.generateBeanPrologue(out, map);
        }
    }

    protected void generateInject(JavaWriter out, HashMap<String, Object> map) throws IOException {
        out.println();
        out.println("public void __caucho_inject(Object []delegates, com.caucho.config.inject.CreationalContextImpl<?> parentEnv)");
        out.println("{");
        out.pushDepth();
        this.generateInjectContent(out, map);
        out.popDepth();
        out.println("}");
    }

    protected void generateInjectContent(JavaWriter out, HashMap<String, Object> map) throws IOException {
        for (AspectGenerator<X> method : this.getMethods()) {
            method.generateInject(out, map);
        }
        this.getAspectBeanFactory().generateInject(out, map);
    }

    protected void generateDelegate(JavaWriter out, HashMap<String, Object> map) throws IOException {
        out.println();
        out.println("public Object __caucho_getDelegate()");
        out.println("{");
        out.print("  return ");
        out.print(this.getAspectBeanFactory().getBeanInstance());
        out.println(";");
        out.println("}");
    }

    protected void generatePostConstruct(JavaWriter out, HashMap<String, Object> map) throws IOException {
        ArrayList<Method> postConstructMethods = this.getLifecycleMethods(PostConstruct.class);
        out.println();
        out.println("public void __caucho_postConstruct()");
        out.println("{");
        out.pushDepth();
        for (AspectGenerator<X> method : this.getMethods()) {
            method.generatePostConstruct(out, map);
        }
        this.getAspectBeanFactory().generatePostConstruct(out, map);
        out.popDepth();
        out.println("}");
        this.generateLifecycleMethodReflection(out, postConstructMethods, "postConstruct");
        out.println();
        out.println("private void __caucho_postConstructImpl()");
        out.println("  throws Exception");
        out.println("{");
        out.pushDepth();
        this.generateLifecycleMethods(out, postConstructMethods, "postConstruct");
        out.popDepth();
        out.println("}");
    }

    private void generatePreDestroy(JavaWriter out, HashMap<String, Object> map) throws IOException {
        ArrayList<Method> preDestroyMethods = this.getLifecycleMethods(PreDestroy.class);
        out.println();
        out.println("public void __caucho_preDestroy()");
        out.println("{");
        out.pushDepth();
        for (AspectGenerator<X> method : this.getMethods()) {
            method.generatePreDestroy(out, map);
        }
        this.getAspectBeanFactory().generatePreDestroy(out, map);
        out.popDepth();
        out.println("}");
        this.generateLifecycleMethodReflection(out, preDestroyMethods, "preDestroy");
        out.println();
        out.println("private void __caucho_preDestroyImplConstructImpl()");
        out.println("  throws Exception");
        out.println("{");
        out.pushDepth();
        this.generateLifecycleMethods(out, preDestroyMethods, "preDestroy");
        out.popDepth();
        out.println("}");
    }

    protected void generateLifecycleMethodReflection(JavaWriter out, ArrayList<Method> methods, String lifecycleType) throws IOException {
        for (int i = 0; i < methods.size(); ++i) {
            Method method = methods.get(i);
            out.println();
            out.println("java.lang.reflect.Method __caucho_" + lifecycleType + "_" + i + " = ");
            out.print("  ");
            out.printClass(CandiUtil.class);
            out.print(".findMethod(");
            out.printClass(method.getDeclaringClass());
            out.print(".class, \"");
            out.print(method.getName());
            out.println("\");");
        }
    }

    protected void generateLifecycleMethods(JavaWriter out, ArrayList<Method> methods, String lifecycleType) throws IOException {
        for (int i = 0; i < methods.size(); ++i) {
            out.println("try {");
            out.pushDepth();
            out.print("__caucho_" + lifecycleType + "_" + i + ".invoke(");
            out.print(this.getAspectBeanFactory().getBeanInstance());
            out.println(");");
            out.popDepth();
            out.println("} catch (java.lang.reflect.InvocationTargetException ex) {");
            out.println("  if (ex.getCause() instanceof Exception)");
            out.println("    throw (Exception) ex.getCause();");
            out.println("  else");
            out.println("    throw ex;");
            out.println("}");
        }
    }

    protected ArrayList<Method> getLifecycleMethods(Class<? extends Annotation> annType) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (AnnotatedMethod method : this.getBeanType().getMethods()) {
            if (!method.isAnnotationPresent(annType) || method.getParameters().size() != 0) continue;
            methods.add(method.getJavaMember());
        }
        Collections.sort(methods, new PostConstructComparator());
        return methods;
    }

    protected void generateEpilogue(JavaWriter out, HashMap<String, Object> map) throws IOException {
        this.getAspectBeanFactory().generateEpilogue(out, map);
    }

    public void generateBusinessMethods(JavaWriter out, HashMap<String, Object> map) throws IOException {
        for (AspectGenerator<X> method : this.getMethods()) {
            method.generate(out, map);
        }
    }

    protected void generateDependency(JavaWriter out) throws IOException {
        this._dependency.generate(out);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._beanType.getJavaClass().getSimpleName() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PostConstructComparator
    implements Comparator<Method> {
        PostConstructComparator() {
        }

        @Override
        public int compare(Method a, Method b) {
            Class<?> classB;
            Class<?> classA = a.getDeclaringClass();
            if (classA == (classB = b.getDeclaringClass())) {
                return a.getName().compareTo(b.getName());
            }
            if (classA.isAssignableFrom(classB)) {
                return -1;
            }
            if (classB.isAssignableFrom(classA)) {
                return 1;
            }
            return a.getName().compareTo(b.getName());
        }
    }
}

