/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.gen;

import com.caucho.config.ConfigException;
import com.caucho.config.gen.AbstractAspectGenerator;
import com.caucho.config.gen.AspectGenerator;
import com.caucho.config.gen.AspectGeneratorUtil;
import com.caucho.config.gen.CandiInvocationContext;
import com.caucho.config.gen.CandiUtil;
import com.caucho.config.gen.InterceptorFactory;
import com.caucho.config.gen.NullGenerator;
import com.caucho.config.inject.DependentCreationalContext;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.InterceptorBean;
import com.caucho.config.inject.InterceptorRuntimeBean;
import com.caucho.config.inject.InterceptorSelfBean;
import com.caucho.config.reflect.AnnotatedTypeUtil;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.util.Nonbinding;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InterceptorBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class InterceptorGenerator<X>
extends AbstractAspectGenerator<X> {
    private static final Logger log = Logger.getLogger(InterceptorGenerator.class.getName());
    private static final String INTERCEPTOR_MAP = "caucho.interceptor.map";
    private static final Method _nullMethod;
    private InterceptorFactory<X> _factory;
    private String _uniqueName;
    private String _chainName;
    private boolean _isChainNew;
    private InterceptionType _interceptionType = InterceptionType.AROUND_INVOKE;
    private ArrayList<Annotation> _interceptorBinding = new ArrayList();
    private ArrayList<Class<?>> _interceptors = new ArrayList();
    private boolean _isEpilogue;
    private InterceptionBinding _bindingEntry;
    private HashMap<Interceptor<?>, String> _interceptorVarMap = new HashMap();
    private ArrayList<Class<?>> _ownInterceptors = new ArrayList();
    private HashSet<Class<?>> _decoratorSet;
    private final String _decoratorClass = "__caucho_decorator_class";
    private final String _decoratorBeansVar = "__caucho_decorator_beans";
    private final String _decoratorIndexVar = "__caucho_delegates";
    private final String _decoratorLocalVar = "__caucho_decorator_class_tl";
    private final String _delegateVar = "__caucho_delegate";
    private String _decoratorSetName;

    public InterceptorGenerator(InterceptorFactory<X> factory, AnnotatedMethod<? super X> method, AspectGenerator<X> next, InterceptionType type, HashSet<Class<?>> methodInterceptors, HashMap<Class<?>, Annotation> methodInterceptorMap, HashSet<Class<?>> decoratorSet, boolean isExcludeClassInterceptors) {
        super(factory, method, next);
        this._factory = factory;
        this._interceptionType = type;
        if (methodInterceptors != null) {
            this._interceptors.addAll(methodInterceptors);
        }
        if (methodInterceptorMap != null) {
            this._interceptorBinding.addAll(methodInterceptorMap.values());
        }
        this._decoratorSet = decoratorSet;
        this.introspect();
    }

    public InterceptorGenerator(InterceptorFactory<X> factory, HashSet<Class<?>> lifecycleInterceptors, InterceptionType type) {
        super(factory, null, NullGenerator.NULL);
        this._factory = factory;
        if (lifecycleInterceptors != null) {
            this._interceptors.addAll(lifecycleInterceptors);
        }
        this._interceptionType = type;
        if (factory.getClassInterceptorBindings() != null) {
            this._interceptorBinding.addAll(factory.getClassInterceptorBindings().values());
        }
        this._isEpilogue = true;
    }

    public ArrayList<Class<?>> getInterceptors() {
        return this._interceptors;
    }

    private AnnotatedMethod<? super X> getAroundInvokeMethod() {
        return this._factory.getAroundInvokeMethod();
    }

    private boolean isProxy() {
        return this._factory.getAspectBeanFactory().isProxy();
    }

    private void introspect() {
        this.introspectInterceptors();
    }

    private void introspectInterceptors() {
    }

    public void generateClassPostConstruct(JavaWriter out, HashMap<String, Object> map) throws IOException {
        super.generatePostConstruct(out, map);
        this._uniqueName = (String)map.get("caucho.interceptor.postConstructName");
        this.generateInterceptorCall(out, map);
        map.put("caucho.interceptor.postConstructName", this._uniqueName);
    }

    public void generateClassPreDestroy(JavaWriter out, HashMap<String, Object> map) throws IOException {
        super.generatePreDestroy(out, map);
        this._uniqueName = (String)map.get("caucho.interceptor.preDestroyName");
        this.generateInterceptorCall(out, map);
        map.put("caucho.interceptor.preDestroyName", this._uniqueName);
    }

    @Override
    public void generateEpilogue(JavaWriter out, HashMap<String, Object> map) throws IOException {
        super.generateEpilogue(out, map);
        String key = null;
        if (this._interceptionType == InterceptionType.POST_CONSTRUCT) {
            key = "caucho.interceptor.postConstructName";
        } else if (this._interceptionType == InterceptionType.PRE_DESTROY) {
            key = "caucho.interceptor.preDestroyName";
        }
        this._uniqueName = (String)map.get(key);
        this.generateBeanPrologue(out, map);
        this.generateMethodPrologue(out, map);
        out.println("static {");
        out.pushDepth();
        out.println("try {");
        out.pushDepth();
        out.print(CandiUtil.class.getName());
        out.print(".createInterceptors(__caucho_manager, __caucho_interceptor_beans");
        for (int i = 0; i < this._interceptorBinding.size(); ++i) {
            out.print(", ");
            this.generateAnnotation(out, this._interceptorBinding.get(i));
        }
        out.println(");");
        if (this._factory.isPassivating()) {
            String beanClassName = this.getFactory().getAspectBeanFactory().getInstanceClassName();
            out.println();
            out.print("com.caucho.config.gen.CandiUtil.validatePassivating(");
            out.print(beanClassName + ".class, ");
            out.println("__caucho_interceptor_beans);");
        }
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.println("  __caucho_log.log(java.util.logging.Level.WARNING, e.toString(), e);");
        out.println("  __caucho_exception = com.caucho.config.ConfigException.create(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
        map.put(key, this._uniqueName);
    }

    @Override
    public void generateBeanPrologue(JavaWriter out, HashMap<String, Object> map) throws IOException {
        super.generateBeanPrologue(out, map);
        if (map.get("__caucho_interceptor_objects") == null) {
            map.put("__caucho_interceptor_objects", true);
            out.println();
            out.print("private transient Object []");
            out.println("__caucho_interceptor_objects;");
            out.println("Object []_caucho_getInterceptorObjects()");
            out.println("{ return __caucho_interceptor_objects; }");
        }
        this.generateBeanInterceptorChain(out, map);
        this.generateTail(out);
    }

    @Override
    public void generateBeanConstructor(JavaWriter out, HashMap<String, Object> map) throws IOException {
        super.generateBeanConstructor(out, map);
        if (this.hasDecorator()) {
            this.generateDecoratorBeanConstructor(out, map);
        }
    }

    @Override
    public void generateInject(JavaWriter out, HashMap<String, Object> map) throws IOException {
        super.generateInject(out, map);
        if (this.hasInterceptor()) {
            this.generateInterceptorBeanInject(out, map);
        }
        if (this.hasDecorator()) {
            this.generateDecoratorBeanInject(out, map);
        }
    }

    @Override
    public void generateProxyConstructor(JavaWriter out, HashMap<String, Object> map) throws IOException {
        super.generateProxyConstructor(out, map);
        if (this.hasDecorator()) {
            // empty if block
        }
    }

    private void generateInterceptorBeanInject(JavaWriter out, HashMap<String, Object> map) throws IOException {
        if (map.get("interceptor_object_init") != null) {
            return;
        }
        map.put("interceptor_object_init", true);
        out.println("int size = __caucho_interceptor_beans.size();");
        out.println("Object []objects = new Object[size];");
        out.println();
        out.println();
        out.println("for (int i = 0; i < size; i++) {");
        out.pushDepth();
        out.println("javax.enterprise.inject.spi.Bean bean");
        out.println("  = __caucho_interceptor_beans.get(i);");
        out.println("javax.enterprise.context.spi.CreationalContext env");
        out.println("  = new " + DependentCreationalContext.class.getName() + "(bean, parentEnv, null);");
        out.print("objects[i] = ");
        out.println("__caucho_manager.getReference(bean, bean.getBeanClass(), env);");
        out.print("if (objects[i] == null && (bean instanceof ");
        out.printClass(InterceptorSelfBean.class);
        out.println("))");
        out.print("  objects[i] = ");
        out.print(this.getBeanFactory().getBeanInstance());
        out.println(";");
        out.println("else if (objects[i] == null)");
        out.println("  throw new NullPointerException(String.valueOf(bean));");
        out.popDepth();
        out.println("}");
        out.println("__caucho_interceptor_objects = objects;");
        for (Class<?> iClass : this._ownInterceptors) {
            String var = this._interceptorVarMap.get(iClass);
            out.println("if (" + var + "_f == null)");
            out.println("  " + var + "_f = __caucho_manager.createTransient(" + iClass.getName() + ".class);");
            out.print(var + " = (");
            out.printClass(iClass);
            out.println(") __caucho_manager.getInstance(" + var + "_f);");
        }
    }

    private void generateBeanInterceptorChain(JavaWriter out, HashMap<String, Object> map) throws IOException {
        List interceptors;
        this._chainName = this.getChainName(out, map);
        if (this._interceptors.size() > 0 && (interceptors = (List)map.get("@Interceptors")) == null) {
            ArrayList arrayList = new ArrayList();
        }
    }

    @Override
    public void generateMethodPrologue(JavaWriter out, HashMap<String, Object> map) throws IOException {
        super.generateMethodPrologue(out, map);
        if (map.get("__caucho_manager") == null) {
            map.put("__caucho_manager", true);
            out.println();
            out.print("private static ");
            out.printClass(InjectManager.class);
            out.println(" __caucho_manager");
            out.print(" = ");
            out.printClass(InjectManager.class);
            out.println(".create();");
        }
        if (this.hasInterceptor()) {
            this.generateInterceptorMethodPrologue(out, map);
        }
        if (this.hasDecorator()) {
            this.generateDecoratorMethodPrologue(out, map);
        }
    }

    @Override
    public void generatePreTry(JavaWriter out) throws IOException {
        super.generatePreTry(out);
        if (this.hasDecorator()) {
            this.generateDecoratorPreTry(out);
        }
    }

    @Override
    public void generatePreCall(JavaWriter out) throws IOException {
        if (this.hasDecorator()) {
            this.generateDecoratorPreCall(out);
        }
    }

    @Override
    public void generateCall(JavaWriter out) throws IOException {
        if (this.hasInterceptor()) {
            HashMap<String, Object> map = null;
            this.generateInterceptorCall(out, map);
        } else if (this.hasDecorator()) {
            this.generateDecoratorCall(out);
        } else {
            throw new IllegalStateException(this.toString());
        }
    }

    @Override
    public void generateFinally(JavaWriter out) throws IOException {
        super.generateFinally(out);
        if (this.hasDecorator()) {
            this.generateDecoratorFinally(out);
        }
    }

    @Override
    protected Method getJavaMethod() {
        AnnotatedMethod method = this.getMethod();
        if (method != null) {
            return method.getJavaMember();
        }
        return _nullMethod;
    }

    private void generateInterceptorMethodPrologue(JavaWriter out, HashMap<String, Object> map) throws IOException {
        if (map.get("__caucho_interceptor_beans") == null) {
            map.put("__caucho_interceptor_beans", true);
            out.println();
            out.print("private static final ");
            out.print("java.util.ArrayList<");
            out.printClass(InterceptorRuntimeBean.class);
            out.println("<?>> __caucho_interceptor_static_beans");
            out.print("  = new java.util.ArrayList<");
            out.printClass(InterceptorRuntimeBean.class);
            out.println("<?>>();");
            out.println();
            out.print("private static final ");
            out.print("java.util.ArrayList<");
            out.printClass(Interceptor.class);
            out.println("<?>> __caucho_interceptor_beans");
            out.print("  = new java.util.ArrayList<");
            out.printClass(Interceptor.class);
            out.println("<?>>();");
        }
        this.generateInterceptorMethod(out, map);
        this.generateInterceptorChain(out, map);
    }

    private void generateInterceptorMethod(JavaWriter out, HashMap<String, Object> map) throws IOException {
        String className;
        Method javaMethod = this.getJavaMethod();
        out.println();
        out.println("private static java.lang.reflect.Method " + this.getUniqueName(out) + "_method;");
        out.println("private static java.lang.reflect.Method " + this.getUniqueName(out) + "_implMethod;");
        boolean isAroundInvokePrologue = false;
        if (this.getAroundInvokeMethod() != null && map.get("ejb.around-invoke") == null) {
            isAroundInvokePrologue = true;
            map.put("ejb.around-invoke", "_caucho_aroundInvokeMethod");
            out.println("private static java.lang.reflect.Method __caucho_aroundInvokeMethod;");
        }
        out.println();
        out.println("static {");
        out.pushDepth();
        out.println("try {");
        out.pushDepth();
        out.print(this.getUniqueName(out) + "_method = ");
        this.generateGetMethod(out, javaMethod.getDeclaringClass().getName(), javaMethod.getName(), javaMethod.getParameterTypes());
        out.println(";");
        out.println(this.getUniqueName(out) + "_method.setAccessible(true);");
        String superMethodName = this.getSuperMethodName();
        out.print(this.getUniqueName(out) + "_implMethod = ");
        if (javaMethod.getDeclaringClass().equals(this.getClass())) {
            className = InterceptorGenerator.class.getName();
            superMethodName = javaMethod.getName();
        } else {
            className = this.getBeanFactory().getInstanceClassName();
            if (this.getBeanFactory().isProxy()) {
                superMethodName = javaMethod.getName();
            }
        }
        this.generateGetMethod(out, className, superMethodName, javaMethod.getParameterTypes());
        out.println(";");
        if (isAroundInvokePrologue) {
            AnnotatedMethod<X> aroundInvoke = this.getAroundInvokeMethod();
            out.print("__caucho_aroundInvokeMethod = ");
            this.generateGetMethod(out, aroundInvoke.getJavaMember().getDeclaringClass().getName(), aroundInvoke.getJavaMember().getName(), aroundInvoke.getJavaMember().getParameterTypes());
            out.println(";");
            out.println("__caucho_aroundInvokeMethod.setAccessible(true);");
        }
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.println("  __caucho_log.log(java.util.logging.Level.WARNING, e.toString(), e);");
        out.println("  __caucho_exception = com.caucho.config.ConfigException.create(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    private String getSuperMethodName() {
        Method javaMethod = this.getJavaMethod();
        if (this.hasDecorator()) {
            return "__caucho_" + javaMethod.getName() + "_decorator";
        }
        if (this.isProxy()) {
            return javaMethod.getName();
        }
        return "__caucho_" + javaMethod.getName() + "_" + this._interceptionType;
    }

    private String getChainName(JavaWriter out, HashMap<String, Object> map) {
        if (this._chainName != null) {
            return this._chainName;
        }
        HashMap<InterceptionBinding, String> bindingMap = (HashMap<InterceptionBinding, String>)map.get(INTERCEPTOR_MAP);
        if (bindingMap == null) {
            bindingMap = new HashMap<InterceptionBinding, String>();
            map.put(INTERCEPTOR_MAP, bindingMap);
        }
        this._bindingEntry = new InterceptionBinding(this._interceptionType, this._interceptorBinding, this._interceptors);
        this._chainName = (String)bindingMap.get(this._bindingEntry);
        if (this._chainName != null) {
            return this._chainName;
        }
        this._chainName = this.getUniqueName(out);
        this._isChainNew = true;
        bindingMap.put(this._bindingEntry, this._chainName);
        return this._chainName;
    }

    private void generateInterceptorChain(JavaWriter out, HashMap<String, Object> map) throws IOException {
        String chainName = this.getChainName(out, map);
        if (!this._isChainNew) {
            return;
        }
        if (this._interceptors.size() > 0) {
            ArrayList interceptors = (ArrayList)map.get("@Interceptors");
            if (interceptors == null) {
                interceptors = new ArrayList();
                map.put("@Interceptors", interceptors);
            }
            ArrayList<Integer> indexChain = new ArrayList<Integer>();
            out.println("static {");
            out.pushDepth();
            for (int i = 0; i < this._interceptors.size(); ++i) {
                Class iClass = this._interceptors.get(i);
                int index = interceptors.indexOf(iClass);
                if (index > -1) {
                    indexChain.add(index);
                    continue;
                }
                indexChain.add(interceptors.size());
                interceptors.add(iClass);
                if (iClass.isAssignableFrom(this.getJavaClass())) {
                    out.print("__caucho_interceptor_static_beans.add(new ");
                    out.printClass(InterceptorSelfBean.class);
                    out.print("(");
                    out.printClass(this.getJavaClass());
                    out.println(".class));");
                    continue;
                }
                out.print("__caucho_interceptor_static_beans.add(new ");
                out.printClass(InterceptorBean.class);
                out.print("(");
                out.printClass(iClass);
                out.println(".class));");
            }
            out.popDepth();
            out.println("}");
            out.println();
            out.print("private static int []" + chainName + "_objectIndexStaticChain = new int[] {");
            Iterator i$ = indexChain.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                out.print(i);
                out.print(',');
            }
            out.println("};");
        } else {
            out.println("private static int []" + chainName + "_objectIndexStaticChain;");
        }
        out.println("private static int []" + chainName + "_objectIndexChain;");
        out.println("private static javax.enterprise.inject.spi.Interceptor []" + chainName + "_methodChain;");
        out.println();
        out.println("static {");
        out.pushDepth();
        out.println("try {");
        out.pushDepth();
        this.generateMethodChain(out, map);
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.println("  __caucho_log.log(java.util.logging.Level.WARNING, e.toString(), e);");
        out.println("  __caucho_exception = com.caucho.config.ConfigException.create(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    private void generateMethodChain(JavaWriter out, HashMap<String, Object> map) throws IOException {
        String chainName = this.getChainName(out, map);
        out.println(chainName + "_objectIndexChain =");
        out.println("  com.caucho.config.gen.CandiUtil.createInterceptors(");
        out.println("    __caucho_manager,");
        out.println("    __caucho_interceptor_static_beans,");
        out.println("    __caucho_interceptor_beans,");
        out.println("    " + chainName + "_objectIndexStaticChain,");
        out.print("    " + InterceptionType.class.getName() + "." + this._interceptionType);
        for (int i = 0; i < this._interceptorBinding.size(); ++i) {
            out.println(",");
            out.pushDepth();
            out.pushDepth();
            this.generateAnnotation(out, this._interceptorBinding.get(i));
            out.popDepth();
            out.popDepth();
        }
        out.println(");");
        if (this._factory.isPassivating()) {
            String beanClassName = this.getFactory().getAspectBeanFactory().getInstanceClassName();
            out.println();
            out.print("com.caucho.config.gen.CandiUtil.validatePassivating(");
            out.print(beanClassName + ".class, ");
            out.println("__caucho_interceptor_beans);");
        }
        out.println();
        out.println(chainName + "_methodChain = ");
        out.println("  com.caucho.config.gen.CandiUtil.createMethods(");
        out.println("    __caucho_interceptor_beans,");
        out.println("    " + InterceptionType.class.getName() + "." + this._interceptionType + ",");
        out.println("    " + chainName + "_objectIndexChain);");
    }

    private void generateInterceptorCall(JavaWriter out, HashMap<String, Object> map) throws IOException {
        Class<?>[] paramTypes;
        Method javaMethod = this.getJavaMethod();
        String uniqueName = this.getUniqueName(out);
        String chainName = this.getChainName(out, map);
        out.println("try {");
        out.pushDepth();
        if (javaMethod != null && !Void.TYPE.equals(javaMethod.getReturnType())) {
            out.print("result = (");
            this.printCastClass(out, javaMethod.getReturnType());
            out.print(") ");
        }
        out.print("new ");
        out.printClass(CandiInvocationContext.class);
        out.println("(");
        out.pushDepth();
        out.pushDepth();
        out.printClass(InterceptionType.class);
        out.println("." + this._interceptionType + ", ");
        out.print(this._factory.getAspectBeanFactory().getBeanInstance());
        out.println(", ");
        if (this._interceptionType == InterceptionType.AROUND_INVOKE) {
            out.println(uniqueName + "_method, ");
        } else {
            out.println("null, ");
        }
        out.println(uniqueName + "_implMethod, ");
        out.println(chainName + "_methodChain, ");
        out.print(this._factory.getAspectBeanFactory().getBeanInfo());
        out.println("._caucho_getInterceptorObjects(), ");
        out.println(chainName + "_objectIndexChain, ");
        Class<?>[] classArray = paramTypes = javaMethod != null ? javaMethod.getParameterTypes() : null;
        if (paramTypes == null || paramTypes.length == 0) {
            out.println("com.caucho.config.gen.CandiUtil.NULL_OBJECT_ARRAY");
        } else {
            out.print("new Object[] { ");
            for (int i = 0; i < javaMethod.getParameterTypes().length; ++i) {
                out.print("a" + i + ", ");
            }
            out.println("}");
        }
        out.println(").proceed();");
        out.popDepth();
        out.popDepth();
        out.popDepth();
        out.println("} catch (RuntimeException e) {");
        out.println("  throw e;");
        boolean isException = false;
        Class<Object>[] exnList = javaMethod != null ? javaMethod.getExceptionTypes() : new Class[]{};
        for (Class<Exception> clazz : exnList) {
            if (RuntimeException.class.isAssignableFrom(clazz) || !this.isMostGeneralException(exnList, clazz)) continue;
            if (clazz.isAssignableFrom(Exception.class)) {
                isException = true;
            }
            out.println("} catch (" + clazz.getName() + " e) {");
            out.println("  throw e;");
        }
        if (!isException) {
            out.println("} catch (Exception e) {");
            out.println("  throw new RuntimeException(e);");
        }
        out.println("}");
    }

    private void generateDecoratorBeanConstructor(JavaWriter out, HashMap<String, Object> map) throws IOException {
    }

    private void generateDecoratorBeanInject(JavaWriter out, HashMap<String, Object> map) throws IOException {
        if (this._decoratorSet == null) {
            return;
        }
        out.println("__caucho_delegates = delegates;");
    }

    private void generateDecoratorMethodPrologue(JavaWriter out, HashMap<String, Object> map) throws IOException {
        this.generateDecoratorClass(out, map);
        String decoratorSetName = this.getDecoratorSetName(out, map);
        if (this.hasInterceptor()) {
            this.generateDecoratorMethod(out);
        }
        if (map.get("decorator_bean_" + decoratorSetName) != null) {
            return;
        }
        map.put("decorator_bean_" + decoratorSetName, true);
        if (map.get("decorator_delegate_decl") == null) {
            map.put("decorator_delegate_decl", true);
            out.print("private static ");
            out.print("__caucho_decorator_class");
            out.println(" __caucho_delegate;");
            out.println();
            out.println("private static java.util.List<javax.enterprise.inject.spi.Decorator<?>> __caucho_decorator_beans;");
            out.println();
            out.println("static final ThreadLocal<__caucho_decorator_class> __caucho_decorator_class_tl");
            out.println("  = new ThreadLocal<__caucho_decorator_class>();");
            out.println();
            out.println("private transient Object [] __caucho_delegates;");
            out.println();
            out.println("final Object []__caucho_getDelegates()");
            out.println("{");
            out.println("  return __caucho_delegates;");
            out.println("}");
            this.generateDecoratorInit(out);
        }
    }

    private void generateDecoratorInit(JavaWriter out) throws IOException {
        out.println();
        out.println("public static Object __caucho_decorator_init()");
        out.println("{");
        out.pushDepth();
        out.println("if (__caucho_delegate == null)");
        out.println("  __caucho_delegate = new __caucho_decorator_class(0, null, null);");
        out.println();
        out.println("return __caucho_delegate;");
        out.popDepth();
        out.println("}");
    }

    private void generateDecoratorClass(JavaWriter out, HashMap<String, Object> map) throws IOException {
        if (map.get("decorator_class_decl") != null) {
            return;
        }
        map.put("decorator_class_decl", true);
        String className = "__caucho_decorator_class";
        ArrayList<Method> methodList = new ArrayList<Method>();
        HashMap apiMap = new HashMap();
        for (Class<?> clazz : this._factory.getDecoratorClasses()) {
            for (Method method : clazz.getMethods()) {
                if (Modifier.isFinal(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || Modifier.isPrivate(method.getModifiers()) || method.getDeclaringClass() == Object.class || this.containsMethod(methodList, method)) continue;
                methodList.add(method);
            }
        }
        for (Method method : methodList) {
            this.generateDecoratorMethodDecl(out, method);
        }
        out.println();
        out.println("public static void __caucho_init_decorators(java.util.List<javax.enterprise.inject.spi.Decorator<?>> decoratorList)");
        out.println("{");
        out.pushDepth();
        for (Method method : methodList) {
            out.print("_caucho_decorator_" + method.getName() + "_m");
            out.print(" = com.caucho.config.gen.CandiUtil.createDecoratorMethods(decoratorList, ");
            out.print("\"" + method.getName() + "\"");
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                out.print(", ");
                out.printClass(method.getParameterTypes()[i]);
                out.print(".class");
            }
            out.println(");");
        }
        if (this._factory.isPassivating()) {
            String beanClassName = this.getFactory().getAspectBeanFactory().getInstanceClassName();
            out.println();
            out.print("com.caucho.config.gen.CandiUtil.validatePassivatingDecorators(");
            out.print(beanClassName + ".class, ");
            out.println("decoratorList);");
        }
        out.popDepth();
        out.println("}");
        out.println();
        out.print("static class ");
        out.print(className);
        out.print(" ");
        for (Class<Object> clazz : this._factory.getDecoratorClasses()) {
            if (clazz.isInterface()) continue;
            out.print(" extends ");
            out.printClass(clazz);
        }
        boolean isFirst = true;
        for (Class<?> cl : this._factory.getDecoratorClasses()) {
            if (!cl.isInterface()) continue;
            if (isFirst) {
                out.print(" implements ");
            } else {
                out.print(", ");
            }
            isFirst = false;
            out.printClass(cl);
        }
        out.println(" {");
        out.pushDepth();
        String string = this._factory.getInstanceClassName();
        out.println("private int _index;");
        out.println("private " + string + " _bean;");
        out.println("private Object [] _delegates;");
        out.println();
        out.print(className + "(int index, " + string + " bean, Object []delegates)");
        out.println("{");
        out.println("  _index = index;");
        out.println("  _bean = bean;");
        out.println("  _delegates = delegates;");
        out.println("}");
        out.println();
        out.println("final " + string + " __caucho_getBean()");
        out.println("{");
        out.println("  return _bean;");
        out.println("}");
        for (Method method : methodList) {
            this.generateDecoratorMethod(out, method, apiMap);
        }
        out.popDepth();
        out.println("}");
        for (Map.Entry entry : apiMap.entrySet()) {
            ArrayList apis = (ArrayList)entry.getKey();
            String name = (String)entry.getValue();
            out.println();
            out.println("static final Class []" + name + " = new Class[] {");
            out.pushDepth();
            for (int i = 0; i < apis.size(); ++i) {
                out.printClass((Class)apis.get(i));
                out.println(".class,");
            }
            out.popDepth();
            out.println("};");
        }
    }

    private void generateDecoratorMethodDecl(JavaWriter out, Method method) throws IOException {
        out.println("static java.lang.reflect.Method []_caucho_decorator_" + method.getName() + "_m;");
    }

    private void generateDecoratorMethod(JavaWriter out, Method method, HashMap<ArrayList<Class<?>>, String> apiMap) throws IOException {
        AnnotatedMethod annMethod = AnnotatedTypeUtil.findMethod(this.getBeanType(), method.getName(), method.getParameterTypes());
        String uniqueName = this.getUniqueName(out);
        ArrayList<Class<?>> apis = this.getMethodApis(method);
        String apiName = apiMap.get(apis);
        if (apiName == null && apis.size() > 1) {
            apiName = uniqueName + "_api_" + apiMap.size();
            apiMap.put(apis, apiName);
        }
        Class<?> decoratorType = apis.get(0);
        out.println();
        out.print("public ");
        out.printClass(method.getReturnType());
        out.print(" ");
        out.print(method.getName());
        out.print("(");
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.printClass(paramTypes[i]);
            out.print(" a" + i);
        }
        out.println(")");
        Class<?>[] exnTypes = method.getExceptionTypes();
        if (exnTypes.length > 0) {
            out.print("  throws ");
            for (int i = 0; i < exnTypes.length; ++i) {
                if (i != 0) {
                    out.print(", ");
                }
                out.printClass(exnTypes[i]);
            }
        }
        out.println("{");
        out.pushDepth();
        if (annMethod != null && annMethod.isAnnotationPresent(Inject.class)) {
            out.println("__caucho_decorator_class var = __caucho_decorator_class_tl.get();");
            this.printDecoratorSuperCall(out, method, annMethod);
        } else {
            out.println("__caucho_decorator_class var = __caucho_decorator_class_tl.get();");
            out.println("Object []delegates = var._delegates;");
            out.println();
            out.print("var._index = com.caucho.config.gen.CandiUtil.nextDelegate(");
            out.print("delegates, ");
            out.print("_caucho_decorator_" + method.getName() + "_m");
            out.println(", var._index);");
            out.println();
            out.println("if (var._index >= 0) {");
            out.pushDepth();
            out.println("Object delegate = delegates[var._index];");
            for (int j = 0; j < apis.size(); ++j) {
                if (j > 0) {
                    out.print("else ");
                }
                if (j + 1 < apis.size()) {
                    out.print("if (delegate instanceof ");
                    out.printClass(apis.get(j));
                    out.print(")");
                }
                if (apis.size() > 1) {
                    out.println();
                    out.print("  ");
                }
                if (!Void.TYPE.equals(method.getReturnType())) {
                    out.print("return (");
                    out.printClass(method.getReturnType());
                    out.print(") ");
                }
                out.print("com.caucho.config.gen.CandiUtil.invoke(");
                out.print("_caucho_decorator_" + method.getName() + "_m[");
                out.print("var._index");
                out.print("], delegate");
                for (int i = 0; i < paramTypes.length; ++i) {
                    out.print(", ");
                    out.print("a" + i);
                }
                out.println(");");
            }
            out.popDepth();
            out.println("}");
            out.println("else");
            out.pushDepth();
            this.printDecoratorSuperCall(out, method, annMethod);
        }
        out.popDepth();
        out.println("}");
    }

    private void printDecoratorSuperCall(JavaWriter out, Method method, AnnotatedMethod<? super X> annMethod) throws IOException {
        Class<?>[] paramTypes = method.getParameterTypes();
        if (!Void.TYPE.equals(method.getReturnType())) {
            out.print("return ");
        }
        if (this.isProxy() || annMethod != null && annMethod.isAnnotationPresent(Inject.class)) {
            out.print("var.__caucho_getBean().");
            out.print(method.getName());
        } else {
            out.print("var.__caucho_getBean().");
            out.print("__caucho_" + method.getName() + "_" + this._interceptionType);
        }
        out.print("(");
        for (int i = 0; i < paramTypes.length; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.print("a" + i);
        }
        out.println(");");
        out.popDepth();
    }

    private void generateDecoratorMethod(JavaWriter out) throws IOException {
        Method javaMethod = this.getJavaMethod();
        out.println();
        out.print("private ");
        out.printClass(javaMethod.getReturnType());
        out.print(" __caucho_");
        out.print(javaMethod.getName());
        out.print("_decorator(");
        Class<?>[] types = javaMethod.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            if (i != 0) {
                out.print(", ");
            }
            out.printClass(type);
            out.print(" a" + i);
        }
        out.println(")");
        AspectGeneratorUtil.generateThrows(out, javaMethod.getExceptionTypes());
        out.println("{");
        out.pushDepth();
        if (!Void.TYPE.equals(javaMethod.getReturnType())) {
            out.printClass(javaMethod.getReturnType());
            out.println(" result;");
        }
        this.generateDecoratorCall(out);
        if (!Void.TYPE.equals(javaMethod.getReturnType())) {
            out.println("return result;");
        }
        out.popDepth();
        out.println("}");
    }

    private void generateDecoratorPreTry(JavaWriter out) throws IOException {
        out.print("__caucho_decorator_class oldDecorator = ");
        out.println("__caucho_decorator_class_tl.get();");
    }

    private void generateDecoratorPreCall(JavaWriter out) throws IOException {
        String decoratorSetName = this._decoratorSetName;
        assert (decoratorSetName != null);
        out.println();
        out.print("__caucho_decorator_class delegate = ");
        out.print("new __caucho_decorator_class(");
        out.print("__caucho_delegates.length, ");
        out.print(this._factory.getAspectBeanFactory().getBeanInstance() + ", ");
        out.print(this.getBeanFactory().getBeanInfo() + ".__caucho_getDelegates()");
        out.println(");");
        out.print("__caucho_decorator_class_tl");
        out.println(".set(delegate);");
    }

    private void generateDecoratorCall(JavaWriter out) throws IOException {
        String decoratorSetName = this._decoratorSetName;
        assert (decoratorSetName != null);
        Method javaMethod = this.getJavaMethod();
        if (!Void.TYPE.equals(javaMethod.getReturnType())) {
            out.print("result = ");
        }
        out.print("__caucho_delegate.");
        out.print(javaMethod.getName());
        out.print("(");
        for (int i = 0; i < javaMethod.getParameterTypes().length; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.print("a" + i);
        }
        out.println(");");
    }

    private void generateDecoratorFinally(JavaWriter out) throws IOException {
        out.print("__caucho_decorator_class_tl");
        out.println(".set(oldDecorator);");
    }

    private String getUniqueName(JavaWriter out) {
        if (this._uniqueName == null) {
            String name = this.getJavaMethod().getName();
            this._uniqueName = "_" + name + "_" + this._interceptionType + "_" + out.generateId();
        }
        return this._uniqueName;
    }

    private String getDecoratorSetName(JavaWriter out, Map<String, Object> map) {
        String name;
        if (this._decoratorSetName != null) {
            return this._decoratorSetName;
        }
        HashMap nameMap = (HashMap)map.get("decorator_name_map");
        if (nameMap == null) {
            nameMap = new HashMap();
            map.put("decorator_name_map", nameMap);
        }
        if ((name = (String)nameMap.get(this._decoratorSet)) == null) {
            name = "__caucho_decorator_" + out.generateId();
            nameMap.put(this._decoratorSet, name);
        }
        this._decoratorSetName = name;
        return name;
    }

    private void generateAnnotation(JavaWriter out, Annotation ann) throws IOException {
        out.print("new javax.enterprise.util.AnnotationLiteral<");
        out.printClass(ann.annotationType());
        out.print(">() {");
        boolean isFirst = true;
        for (Method method : ann.annotationType().getMethods()) {
            if (method.getDeclaringClass().equals(Object.class) || method.getDeclaringClass().equals(Annotation.class) || method.getName().equals("annotationType") || method.getParameterTypes().length > 0 || Void.TYPE.equals(method.getReturnType()) || method.isAnnotationPresent(Nonbinding.class)) continue;
            out.pushDepth();
            if (!isFirst) {
                out.print(",");
            }
            isFirst = false;
            out.println();
            out.print("public ");
            out.printClass(method.getReturnType());
            out.print(" " + method.getName() + "() { return ");
            Object value = null;
            try {
                method.setAccessible(true);
                value = method.invoke((Object)ann, new Object[0]);
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
            this.printValue(out, value);
            out.println("; }");
            out.popDepth();
        }
        out.print("}");
    }

    private void printValue(JavaWriter out, Object value) throws IOException {
        if (value == null) {
            out.print("null");
        } else if (value instanceof String) {
            out.print("\"");
            out.printJavaString((String)value);
            out.print("\"");
        } else if (value instanceof Character) {
            out.print("'");
            out.printJavaString(String.valueOf(value));
            out.print("'");
        } else if (value instanceof Enum) {
            out.printClass(value.getClass());
            out.print("." + value);
        } else {
            out.print(value);
        }
    }

    private ArrayList<Class<?>> getMethodApis(Method method) {
        ArrayList apis = new ArrayList();
        for (Class<?> decoratorClass : this._factory.getDecoratorClasses()) {
            if (!this.containsMethod(decoratorClass.getMethods(), method) || apis.contains(decoratorClass)) continue;
            apis.add(decoratorClass);
        }
        return apis;
    }

    private boolean hasInterceptor() {
        return this._interceptors != null && this._interceptors.size() > 0 || this._interceptorBinding != null && this._interceptorBinding.size() > 0 || this.getAroundInvokeMethod() != null || this._factory.isSelfInterceptor() || this._isEpilogue;
    }

    private boolean hasDecorator() {
        return this._decoratorSet != null;
    }

    private void generateTail(JavaWriter out) throws IOException {
        Method javaMethod = this.getJavaMethod();
        out.println();
        out.print("private ");
        out.printClass(javaMethod.getReturnType());
        out.print(" __caucho_");
        out.print(javaMethod.getName() + "_" + this._interceptionType);
        out.print("(");
        Class<?>[] types = javaMethod.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            if (i != 0) {
                out.print(", ");
            }
            out.printClass(type);
            out.print(" a" + i);
        }
        out.println(")");
        AspectGeneratorUtil.generateThrows(out, javaMethod.getExceptionTypes());
        out.println();
        out.println("{");
        out.pushDepth();
        if (!Void.TYPE.equals(javaMethod.getReturnType())) {
            out.printClass(javaMethod.getReturnType());
            out.println(" result;");
        }
        this.generateTailCall(out, this.getFactory().getAspectBeanFactory().getBeanSuper());
        if (!Void.TYPE.equals(javaMethod.getReturnType())) {
            out.println("return result;");
        }
        out.popDepth();
        out.println("}");
    }

    private void generateNullTail(JavaWriter out) throws IOException {
        out.println();
        out.println("private void __caucho_nullPostConstruct()");
        out.println("{");
        out.pushDepth();
        out.popDepth();
        out.println("}");
        out.println();
        out.println("private void __caucho_nullPreDestroy()");
        out.println("{");
        out.pushDepth();
        out.popDepth();
        out.println("}");
    }

    public void generateTailCall(JavaWriter out, String superVar) throws IOException {
        Method javaMethod = this.getJavaMethod();
        if (Modifier.isStatic(javaMethod.getModifiers())) {
            superVar = javaMethod.getDeclaringClass().getName();
        }
        out.println();
        if (!Void.TYPE.equals(javaMethod.getReturnType())) {
            out.print("result = ");
        }
        out.print(superVar + "." + javaMethod.getName() + "(");
        Class<?>[] types = javaMethod.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.print(" a" + i);
        }
        out.println(");");
    }

    private boolean containsMethod(ArrayList<Method> methodList, Method method) {
        for (Method oldMethod : methodList) {
            if (!this.isMatch(oldMethod, method)) continue;
            return true;
        }
        return false;
    }

    private void addInterceptorBindings(HashMap<Class<?>, Annotation> interceptorTypes, Annotation ann) {
        Class<? extends Annotation> annType = ann.annotationType();
        if (annType.isAnnotationPresent(InterceptorBinding.class)) {
            interceptorTypes.put(ann.annotationType(), ann);
        }
        if (annType.isAnnotationPresent(Stereotype.class)) {
            for (Annotation subAnn : annType.getAnnotations()) {
                this.addInterceptorBindings(interceptorTypes, subAnn);
            }
        }
    }

    private boolean containsMethod(Method[] methodList, Method method) {
        for (Method oldMethod : methodList) {
            if (!this.isMatch(oldMethod, method)) continue;
            return true;
        }
        return false;
    }

    private boolean isMostGeneralException(Class<?>[] exnList, Class<?> cl) {
        for (Class<?> exn : exnList) {
            if (exn == cl || !exn.isAssignableFrom(cl)) continue;
            return false;
        }
        return true;
    }

    private Method findInterceptorMethod(Class<?> cl) {
        if (cl == null) {
            return null;
        }
        for (Method method : cl.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(AroundInvoke.class)) continue;
            return method;
        }
        return this.findInterceptorMethod(cl.getSuperclass());
    }

    private boolean isMatch(Method methodA, Method methodB) {
        Class<?>[] paramB;
        if (!methodA.getName().equals(methodB.getName())) {
            return false;
        }
        Class<?>[] paramA = methodA.getParameterTypes();
        if (paramA.length != (paramB = methodB.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < paramA.length; ++i) {
            if (paramA[i].equals(paramB[i])) continue;
            return false;
        }
        return true;
    }

    private void generateGetMethod(JavaWriter out, String className, String methodName, Class<?>[] paramTypes) throws IOException {
        if (this._interceptionType == InterceptionType.POST_CONSTRUCT) {
            out.printClass(CandiUtil.class);
            out.print(".getMethod(");
            out.print(this._factory.getGeneratedClassName());
            out.print(".class, \"__caucho_postConstructImpl\");");
        } else {
            out.printClass(CandiUtil.class);
            out.print(".getMethod(");
            out.print(className);
            out.print(".class, \"" + methodName + "\"");
            for (Class<?> type : paramTypes) {
                out.print(", ");
                out.printClass(type);
                out.print(".class");
            }
            out.print(")");
        }
    }

    protected void printCastClass(JavaWriter out, Class<?> type) throws IOException {
        if (!type.isPrimitive()) {
            out.printClass(type);
        } else if (Boolean.TYPE.equals(type)) {
            out.print("Boolean");
        } else if (Character.TYPE.equals(type)) {
            out.print("Character");
        } else if (Byte.TYPE.equals(type)) {
            out.print("Byte");
        } else if (Short.TYPE.equals(type)) {
            out.print("Short");
        } else if (Integer.TYPE.equals(type)) {
            out.print("Integer");
        } else if (Long.TYPE.equals(type)) {
            out.print("Long");
        } else if (Float.TYPE.equals(type)) {
            out.print("Float");
        } else if (Double.TYPE.equals(type)) {
            out.print("Double");
        } else {
            throw new IllegalStateException(type.getName());
        }
    }

    public static void nullMethod() {
    }

    static {
        Method nullMethod = null;
        try {
            nullMethod = InterceptorGenerator.class.getMethod("nullMethod", new Class[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.log(Level.WARNING, e.toString(), e);
        }
        _nullMethod = nullMethod;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InterceptionBinding {
        private final InterceptionType _type;
        private final ArrayList<Annotation> _binding;
        private final ArrayList<Class<?>> _interceptors;

        public InterceptionBinding(InterceptionType type, ArrayList<Annotation> binding, ArrayList<Class<?>> interceptors) {
            this._type = type;
            this._binding = binding;
            this._interceptors = interceptors;
        }

        public int hashCode() {
            int hashCode = this._type.hashCode() * 65521;
            if (this._binding != null) {
                hashCode += this._binding.hashCode();
            }
            if (this._interceptors != null) {
                hashCode += this._interceptors.hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InterceptionBinding)) {
                return false;
            }
            InterceptionBinding binding = (InterceptionBinding)o;
            if (!this._type.equals((Object)binding._type)) {
                return false;
            }
            if (!(this._binding == binding._binding || this._binding != null && this._binding.equals(binding._binding))) {
                return false;
            }
            return this._interceptors == binding._interceptors || this._interceptors != null && this._interceptors.equals(binding._interceptors);
        }
    }
}

