/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.ConfigException;
import com.caucho.config.Names;
import com.caucho.config.inject.CurrentLiteral;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.InjectionPointArg;
import com.caucho.config.inject.InjectionPointImpl;
import com.caucho.config.inject.ProducesFieldBean;
import com.caucho.config.inject.ProducesMethodBean;
import com.caucho.config.program.Arg;
import com.caucho.config.program.BeanArg;
import com.caucho.inject.Module;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Qualifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class ProducesBuilder {
    private static final Logger log = Logger.getLogger(ProducesBuilder.class.getName());
    private static final L10N L = new L10N(ProducesBuilder.class);
    private InjectManager _manager;

    public ProducesBuilder(InjectManager manager) {
        this._manager = manager;
    }

    public <X> void introspectProduces(Bean<X> bean, AnnotatedType<X> beanType) {
        AnnotatedMethod<X> disposesMethod;
        HashSet<AnnotatedMethod<X>> disposesSet = new HashSet<AnnotatedMethod<X>>();
        for (AnnotatedMethod beanMethod : beanType.getMethods()) {
            if (!beanMethod.isAnnotationPresent(Produces.class)) continue;
            disposesMethod = this.findDisposesMethod(beanType, beanMethod.getBaseType(), this.getQualifiers((Annotated)beanMethod));
            this.addProducesMethod(bean, beanType, beanMethod, disposesMethod);
            if (disposesMethod == null) continue;
            disposesSet.add(disposesMethod);
        }
        for (AnnotatedField beanField : beanType.getFields()) {
            if (!beanField.isAnnotationPresent(Produces.class)) continue;
            disposesMethod = this.findDisposesMethod(beanType, beanField.getBaseType(), this.getQualifiers((Annotated)beanField));
            this.addProduces(bean, beanType, beanField);
            if (disposesMethod == null) continue;
            disposesSet.add(disposesMethod);
        }
        for (AnnotatedMethod beanMethod : beanType.getMethods()) {
            if (!this.isDisposes(beanMethod) || disposesSet.contains(beanMethod)) continue;
            throw new ConfigException(L.l("{0}.{1} is an invalid disposes method because it doesn't match a @Produces method", (Object)beanMethod.getJavaMember().getDeclaringClass().getName(), beanMethod.getJavaMember().getName()));
        }
    }

    protected <X, T> void addProducesMethod(Bean<X> bean, AnnotatedType<X> beanType, AnnotatedMethod<? super X> producesMethod, AnnotatedMethod<? super X> disposesMethod) {
        ProducesMethodBean producesBean;
        Arg<? super X>[] producesArgs = this.introspectArguments(bean, producesMethod);
        Arg<X>[] disposesArgs = null;
        if (disposesMethod != null) {
            disposesArgs = this.introspectDisposesArgs(disposesMethod, disposesMethod.getParameters());
        }
        if ((producesBean = ProducesMethodBean.create(this._manager, bean, producesMethod, producesArgs, disposesMethod, disposesArgs)).isAlternative() && !this._manager.isEnabled(producesBean)) {
            return;
        }
        this._manager.addProducesBean(producesBean);
    }

    protected <X> void addProduces(Bean<X> bean, AnnotatedType<X> beanType, AnnotatedField<?> beanField) {
        Class beanClass = beanType.getJavaClass();
        if (beanField.getJavaMember().getDeclaringClass() != beanClass && !beanClass.isAnnotationPresent(Specializes.class)) {
            return;
        }
        AnnotatedMethod<X> disposesMethod = this.findDisposesMethod(beanType, beanField.getBaseType(), this.getQualifiers((Annotated)beanField));
        Arg[] disposesArgs = null;
        if (disposesMethod != null) {
            disposesArgs = this.introspectDisposesArgs(disposesMethod, disposesMethod.getParameters());
        }
        ProducesFieldBean producesFieldBean = ProducesFieldBean.create(this._manager, bean, beanField, disposesMethod, disposesArgs);
        this._manager.addProducesFieldBean(producesFieldBean);
    }

    private <X> AnnotatedMethod<? super X> findDisposesMethod(AnnotatedType<X> beanType, Type producesBaseType, Annotation[] qualifiers) {
        for (AnnotatedMethod beanMethod : beanType.getMethods()) {
            Annotation[] testQualifiers;
            AnnotatedParameter param;
            List params = beanMethod.getParameters();
            if (params.size() == 0 || !(param = (AnnotatedParameter)params.get(0)).isAnnotationPresent(Disposes.class) || !producesBaseType.equals(param.getBaseType()) || !this.isQualifierMatch(qualifiers, testQualifiers = this.getQualifiers((Annotated)param))) continue;
            Method javaMethod = beanMethod.getJavaMember();
            if (beanMethod.isAnnotationPresent(Inject.class)) {
                throw new ConfigException(L.l("{0}.{1} is an invalid @Disposes method because it has an @Inject annotation", (Object)javaMethod.getDeclaringClass().getName(), javaMethod.getName()));
            }
            return beanMethod;
        }
        return null;
    }

    protected <X, T> Arg<T>[] introspectArguments(Bean<X> bean, AnnotatedMethod<T> method) {
        List params = method.getParameters();
        Method javaMethod = method.getJavaMember();
        Arg[] args = new Arg[params.size()];
        for (int i = 0; i < args.length; ++i) {
            AnnotatedParameter param = (AnnotatedParameter)params.get(i);
            if (param.isAnnotationPresent(Disposes.class)) {
                throw new ConfigException(L.l("'{0}.{1}' is an invalid producer method because a parameter is annotated with @Disposes", (Object)javaMethod.getDeclaringClass().getName(), javaMethod.getName()));
            }
            InjectionPointImpl<X> ip = new InjectionPointImpl<X>(this._manager, bean, param);
            args[i] = InjectionPoint.class.equals((Object)param.getBaseType()) ? new InjectionPointArg() : new BeanArg(this._manager, param.getBaseType(), this.getQualifiers((Annotated)param), ip);
        }
        return args;
    }

    protected <X> Arg<X>[] introspectDisposesArgs(AnnotatedMethod<?> method, List<AnnotatedParameter<X>> params) {
        Arg[] args = new Arg[params.size()];
        boolean hasDisposes = false;
        for (int i = 0; i < args.length; ++i) {
            AnnotatedParameter<X> param = params.get(i);
            InjectionPoint ip = null;
            if (param.isAnnotationPresent(Disposes.class)) {
                if (hasDisposes) {
                    throw new ConfigException(L.l("{0}.{1} is an invalid @Disposes method because two parameters are marked @Disposes", (Object)method.getJavaMember().getDeclaringClass().getName(), method.getJavaMember().getName()));
                }
                hasDisposes = true;
                args[i] = null;
                continue;
            }
            args[i] = new BeanArg(this._manager, param.getBaseType(), this.getQualifiers((Annotated)param), ip);
        }
        return args;
    }

    protected boolean isDisposes(AnnotatedMethod<?> method) {
        List params = method.getParameters();
        for (int i = 0; i < params.size(); ++i) {
            AnnotatedParameter param = (AnnotatedParameter)params.get(i);
            if (!param.isAnnotationPresent(Disposes.class)) continue;
            return true;
        }
        return false;
    }

    private boolean isQualifierMatch(Annotation[] aList, Annotation[] bList) {
        for (Annotation a : aList) {
            if (this.isQualifierPresent(a, bList)) continue;
            return false;
        }
        return true;
    }

    private boolean isQualifierPresent(Annotation a, Annotation[] list) {
        for (Annotation ann : list) {
            if (!ann.annotationType().equals(a.annotationType())) continue;
            return true;
        }
        return false;
    }

    private Annotation[] getQualifiers(Annotated annotated) {
        ArrayList<Annotation> qualifierList = new ArrayList<Annotation>();
        for (Annotation ann : annotated.getAnnotations()) {
            if (ann.annotationType().equals(Named.class)) {
                Named named = (Named)ann;
                String namedValue = named.value();
                if ("".equals(namedValue)) {
                    String name = ((Class)annotated.getBaseType()).getSimpleName();
                    ann = Names.create(name);
                }
                qualifierList.add(ann);
                continue;
            }
            if (!ann.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            qualifierList.add(ann);
        }
        if (qualifierList.size() == 0) {
            qualifierList.add((Annotation)CurrentLiteral.CURRENT);
        }
        Annotation[] qualifiers = new Annotation[qualifierList.size()];
        qualifierList.toArray(qualifiers);
        return qualifiers;
    }
}

