/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.ConfigException;
import com.caucho.inject.Module;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Any;
import javax.enterprise.util.Nonbinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class QualifierBinding {
    private static final L10N L = new L10N(QualifierBinding.class);
    private static final Logger log = Logger.getLogger(QualifierBinding.class.getName());
    private static final Class<?>[] NULL_ARG = new Class[0];
    private Annotation _ann;
    private Class<? extends Annotation> _annType;
    private ArrayList<Method> _methodList = new ArrayList();

    public QualifierBinding(Annotation ann) {
        this._ann = ann;
        this._annType = ann.annotationType();
        QualifierBinding.validateQualifier(this._annType, this._methodList);
    }

    public static void validateQualifier(Class<?> cl, ArrayList<Method> methodList) {
        for (Method method : cl.getMethods()) {
            if (method.getName().equals("annotationType") || method.isAnnotationPresent(Nonbinding.class) || method.getParameterTypes().length > 0 || Object.class.equals(method.getDeclaringClass()) || Annotation.class.equals(method.getDeclaringClass())) continue;
            Class<?> type = method.getReturnType();
            if (type.isArray()) {
                throw new ConfigException(L.l("@{0} is an invalid qualifier because its member '{1}' has an array value and is missing @Nonbinding", (Object)cl.getSimpleName(), method.getName()));
            }
            if (Annotation.class.isAssignableFrom(type)) {
                throw new ConfigException(L.l("@{0} is an invalid qualifier because its member '{1}' has an annotation value and is missing @Nonbinding", (Object)cl.getSimpleName(), method.getName()));
            }
            method.setAccessible(true);
            if (methodList == null) continue;
            methodList.add(method);
        }
    }

    public boolean isAny() {
        return this._annType == Any.class;
    }

    public boolean isMatch(Annotation[] annList) {
        for (Annotation ann : annList) {
            if (!this.isMatch(ann)) continue;
            return true;
        }
        return false;
    }

    boolean isMatch(Annotation ann) {
        Class<? extends Annotation> annType = ann.annotationType();
        if (!this._annType.equals(annType)) {
            return false;
        }
        for (int i = 0; i < this._methodList.size(); ++i) {
            Method method = this._methodList.get(i);
            try {
                Object b;
                Object a = method.invoke((Object)this._ann, new Object[0]);
                if (method.getDeclaringClass().isAssignableFrom(ann.getClass())) {
                    b = method.invoke((Object)ann, new Object[0]);
                } else {
                    Method bMethod = null;
                    try {
                        bMethod = ann.getClass().getMethod(method.getName(), NULL_ARG);
                    }
                    catch (NoSuchMethodException e) {
                        log.log(Level.FINEST, e.toString(), e);
                    }
                    if (bMethod != null) {
                        bMethod.setAccessible(true);
                        b = bMethod.invoke((Object)ann, new Object[0]);
                    } else {
                        b = method.getDefaultValue();
                    }
                }
                if (a == b) continue;
                if (a == null) {
                    return false;
                }
                if (a.equals(b)) continue;
                return false;
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._ann + "]";
    }
}

