/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.inject.InjectManager;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.Bean;

public class SingletonHandle
implements Serializable {
    private static final L10N L = new L10N(SingletonHandle.class);
    private static final Logger log = Logger.getLogger(SingletonHandle.class.getName());
    private final String _id;

    private SingletonHandle() {
        this._id = null;
    }

    public SingletonHandle(String id) {
        this._id = id;
    }

    public Object readResolve() {
        try {
            InjectManager inject = InjectManager.create();
            Bean<?> bean = inject.getPassivationCapableBean(this._id);
            if (bean == null) {
                throw new IllegalStateException(L.l("'{0}' is an unknown SingletonHandle bean.  Unserializing this bean requires an equivalent Managed Bean to be registered.", this._id));
            }
            return inject.getReference(bean);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "]";
    }
}

