/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.program;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ValueGenerator;
import com.caucho.util.L10N;
import java.lang.reflect.Field;
import javax.enterprise.context.spi.CreationalContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldGeneratorProgram
extends ConfigProgram {
    private static final L10N L = new L10N(FieldGeneratorProgram.class);
    private Field _field;
    private ValueGenerator _gen;

    public FieldGeneratorProgram(Field field, ValueGenerator gen) {
        this._field = field;
        this._field.setAccessible(true);
        this._gen = gen;
    }

    @Override
    public String getName() {
        return this._field.getName();
    }

    Class<?> getType() {
        return this._field.getType();
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this._field.getDeclaringClass();
    }

    @Override
    public <T> void inject(T bean, CreationalContext<T> env) throws ConfigException {
        Object value = null;
        try {
            value = this._gen.create();
            this._field.set(bean, value);
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (ClassCastException e) {
            throw ConfigException.create(L.l("{0}: value {1} be cast to {2}", this.location(), value, this._field.getType().getName()), (Throwable)e);
        }
        catch (Exception e) {
            throw ConfigException.create(this.location(), (Throwable)e);
        }
    }

    private String location() {
        return this._field.getDeclaringClass().getName() + "." + this._field.getName() + ": ";
    }
}

