/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.program;

import com.caucho.config.ConfigException;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.TypeFactory;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import javax.enterprise.context.spi.CreationalContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyValueProgram
extends ConfigProgram {
    private static final L10N L = new L10N(PropertyValueProgram.class);
    private final String _name;
    private final QName _qName;
    private final Object _value;
    private Attribute _attr;

    public PropertyValueProgram(String name, Object value) {
        this(null, name, value);
    }

    public PropertyValueProgram(Class<?> type, String name, Object value) {
        this._name = name;
        this._qName = new QName(name);
        this._value = value;
        if (type != null) {
            ConfigType<?> configType = TypeFactory.getType(type);
            this._attr = configType.getAttribute(this._qName);
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public <T> void inject(T bean, CreationalContext<T> env) {
        try {
            Attribute attr = this._attr;
            if (attr == null) {
                ConfigType<?> type = TypeFactory.getType(bean.getClass());
                attr = type.getAttribute(this._qName);
            }
            if (attr == null) {
                throw new ConfigException(L.l("'{0}' is an unknown attribute of '{1}'", (Object)this._qName.getName(), bean.getClass().getName()));
            }
            attr.setValue(bean, this._qName, attr.getConfigType().valueOf(this._value));
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    @Override
    public <T> T create(ConfigType<T> type, CreationalContext<T> env) throws ConfigException {
        return (T)type.valueOf(this._value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._name + "," + this._value + "]";
    }
}

