/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.reflect;

import com.caucho.config.reflect.AnnotatedElementImpl;
import com.caucho.config.reflect.AnnotatedParameterImpl;
import com.caucho.inject.Module;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class AnnotatedConstructorImpl<T>
extends AnnotatedElementImpl
implements AnnotatedConstructor<T> {
    private final AnnotatedType<T> _declaringType;
    private final Constructor<T> _ctor;
    private final ArrayList<AnnotatedParameter<T>> _parameterList = new ArrayList();

    public AnnotatedConstructorImpl(AnnotatedType<T> declaringType, Constructor<T> ctor) {
        super(declaringType.getBaseType(), null, ctor.getAnnotations());
        this._declaringType = declaringType;
        this._ctor = ctor;
        this.introspect(ctor);
    }

    public AnnotatedType<T> getDeclaringType() {
        return this._declaringType;
    }

    public Constructor<T> getJavaMember() {
        return this._ctor;
    }

    public List<AnnotatedParameter<T>> getParameters() {
        return this._parameterList;
    }

    public boolean isStatic() {
        return false;
    }

    private void introspect(Constructor<T> ctor) {
        Type[] paramTypes = ctor.getGenericParameterTypes();
        Annotation[][] annTypes = ctor.getParameterAnnotations();
        for (int i = 0; i < paramTypes.length; ++i) {
            AnnotatedParameterImpl param = new AnnotatedParameterImpl(this, paramTypes[i], annTypes[i], i);
            this._parameterList.add(param);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._ctor + "]";
    }
}

