/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.reflect;

import com.caucho.config.inject.InjectManager;
import com.caucho.config.reflect.AnnotationSet;
import com.caucho.config.reflect.BaseType;
import com.caucho.inject.Module;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class AnnotatedElementImpl
implements Annotated {
    private static final AnnotationSet NULL_ANN_SET = new AnnotationSet();
    private Type _type;
    private Set<Type> _typeSet;
    private AnnotationSet _annSet;

    public AnnotatedElementImpl(Type type, Annotated annotated, Annotation[] annList) {
        this._type = type;
        if (annotated != null) {
            Set annSet = annotated.getAnnotations();
            if (annSet != null && annSet.size() > 0) {
                this._annSet = new AnnotationSet(annSet);
            }
        } else if (annList != null && annList.length > 0) {
            this._annSet = new AnnotationSet();
            for (Annotation ann : annList) {
                this._annSet.add(ann);
            }
        }
    }

    public AnnotatedElementImpl(Annotated annotated) {
        this(annotated.getBaseType(), annotated, null);
    }

    public Type getBaseType() {
        return this._type;
    }

    public Set<Type> getTypeClosure() {
        if (this._typeSet == null) {
            InjectManager manager = InjectManager.getCurrent();
            BaseType type = manager.createSourceBaseType(this._type);
            this._typeSet = type.getTypeClosure(manager);
        }
        return this._typeSet;
    }

    public void addAnnotations(Collection<Annotation> annSet) {
        for (Annotation ann : annSet) {
            this.addAnnotation(ann);
        }
    }

    public void addAnnotations(Annotation[] annSet) {
        for (Annotation ann : annSet) {
            this.addAnnotation(ann);
        }
    }

    public void addAnnotation(Annotation newAnn) {
        if (this._annSet == null) {
            this._annSet = new AnnotationSet();
        }
        this._annSet.replace(newAnn);
    }

    public void addAnnotationIfAbsent(Annotation newAnn) {
        if (!this.isAnnotationPresent(newAnn.annotationType())) {
            this.addAnnotation(newAnn);
        }
    }

    public void removeAnnotation(Annotation ann) {
        if (this._annSet == null) {
            return;
        }
        this._annSet.remove(ann);
    }

    public void clearAnnotations() {
        if (this._annSet != null) {
            this._annSet.clear();
        }
    }

    public Set<Annotation> getAnnotations() {
        if (this._annSet != null) {
            return this._annSet;
        }
        return NULL_ANN_SET;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annType) {
        if (this._annSet == null) {
            return null;
        }
        return (T)this._annSet.getAnnotation(annType);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annType) {
        if (this._annSet == null) {
            return false;
        }
        return this._annSet.isAnnotationPresent(annType);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._type + "]";
    }
}

