/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.reflect;

import com.caucho.config.reflect.AnnotatedConstructorImpl;
import com.caucho.config.reflect.AnnotatedElementImpl;
import com.caucho.config.reflect.AnnotatedMethodImpl;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.NormalScope;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.inject.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedTypeImpl<X>
extends AnnotatedElementImpl
implements AnnotatedType<X> {
    private static final Logger log = Logger.getLogger(AnnotatedTypeImpl.class.getName());
    private Class<X> _javaClass;
    private Set<AnnotatedConstructor<X>> _constructorSet = new CopyOnWriteArraySet<AnnotatedConstructor<X>>();
    private Set<AnnotatedField<? super X>> _fieldSet = new CopyOnWriteArraySet<AnnotatedField<? super X>>();
    private Set<AnnotatedMethod<? super X>> _methodSet = new CopyOnWriteArraySet<AnnotatedMethod<? super X>>();

    public AnnotatedTypeImpl(Class<X> javaClass) {
        this(javaClass, javaClass);
    }

    public AnnotatedTypeImpl(Type type, Class<X> javaClass) {
        super(type, null, javaClass.getDeclaredAnnotations());
        this._javaClass = javaClass;
        this.introspect(javaClass);
    }

    public AnnotatedTypeImpl(AnnotatedType<X> annType) {
        super((Annotated)annType);
        this._javaClass = annType.getJavaClass();
        this._constructorSet.addAll(annType.getConstructors());
        this._fieldSet.addAll(annType.getFields());
        for (AnnotatedMethod annMethod : annType.getMethods()) {
            if (annMethod.getDeclaringType() == annType) {
                this._methodSet.add(new AnnotatedMethodImpl(this, (Annotated)annMethod, annMethod.getJavaMember()));
                continue;
            }
            this._methodSet.add(annMethod);
        }
    }

    public static <X> AnnotatedTypeImpl<X> create(AnnotatedType<X> annType) {
        if (annType instanceof AnnotatedTypeImpl) {
            return (AnnotatedTypeImpl)annType;
        }
        return new AnnotatedTypeImpl<X>(annType);
    }

    public Class<X> getJavaClass() {
        return this._javaClass;
    }

    public Set<AnnotatedConstructor<X>> getConstructors() {
        return this._constructorSet;
    }

    public Set<AnnotatedMethod<? super X>> getMethods() {
        return this._methodSet;
    }

    public AnnotatedMethod<? super X> createMethod(Method method) {
        for (AnnotatedMethod<? super X> annotatedMethod : this._methodSet) {
            if (!AnnotatedMethodImpl.isMatch(annotatedMethod.getJavaMember(), method)) continue;
            return annotatedMethod;
        }
        AnnotatedMethodImpl annMethod = new AnnotatedMethodImpl(this, null, method);
        this._methodSet.add(annMethod);
        return annMethod;
    }

    public Set<AnnotatedField<? super X>> getFields() {
        return this._fieldSet;
    }

    private void introspect(Class<X> cl) {
        this.introspectInheritedAnnotations(cl.getSuperclass());
        this.introspectFields(cl);
        this.introspectMethods(cl);
        if (!cl.isInterface()) {
            for (Constructor<?> ctor : cl.getDeclaredConstructors()) {
                this._constructorSet.add(new AnnotatedConstructorImpl(this, ctor));
            }
            if (this._constructorSet.size() == 0) {
                try {
                    Constructor<X> ctor = cl.getConstructor(new Class[0]);
                    this._constructorSet.add(new AnnotatedConstructorImpl<X>(this, ctor));
                }
                catch (NoSuchMethodException e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
        }
    }

    private void introspectFields(Class<?> cl) {
        throw new UnsupportedOperationException();
    }

    private void introspectMethods(Class<?> cl) {
        throw new UnsupportedOperationException();
    }

    private void introspectInheritedAnnotations(Class<?> cl) {
        this.introspectInheritedAnnotations(cl, false);
    }

    private void introspectInheritedAnnotations(Class<?> cl, boolean isScope) {
        if (cl == null) {
            return;
        }
        for (Annotation ann : cl.getDeclaredAnnotations()) {
            Class<? extends Annotation> annType = ann.annotationType();
            if (!annType.isAnnotationPresent(Inherited.class) || this.isAnnotationPresent(annType)) continue;
            if (ann.annotationType().isAnnotationPresent(Scope.class) || ann.annotationType().isAnnotationPresent(NormalScope.class)) {
                if (isScope) continue;
                isScope = true;
            }
            this.addAnnotation(ann);
        }
        this.introspectInheritedAnnotations(cl.getSuperclass(), isScope);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._javaClass + "]";
    }
}

