/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.reflect;

import com.caucho.inject.Module;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class AnnotatedTypeUtil {
    public static <X> AnnotatedMethod<? super X> findMethod(AnnotatedType<X> type, AnnotatedMethod<?> method) {
        Method javaMethod = method.getJavaMember();
        return AnnotatedTypeUtil.findMethod(type, javaMethod.getName(), javaMethod.getParameterTypes());
    }

    public static <X> AnnotatedMethod<? super X> findMethod(AnnotatedType<X> type, Method javaMethod) {
        return AnnotatedTypeUtil.findMethod(type, javaMethod.getName(), javaMethod.getParameterTypes());
    }

    public static <X> AnnotatedMethod<? super X> findMethod(AnnotatedType<X> type, String methodName, Class<?>[] param) {
        for (AnnotatedMethod annMethod : type.getMethods()) {
            Method method = annMethod.getJavaMember();
            if (!method.getName().equals(methodName) || !AnnotatedTypeUtil.isMatch(param, method.getParameterTypes())) continue;
            return annMethod;
        }
        return null;
    }

    public static <X> AnnotatedMethod<? super X> findMethod(Set<AnnotatedMethod<? super X>> methods, Method method) {
        return AnnotatedTypeUtil.findMethod(methods, method.getName(), method.getParameterTypes());
    }

    public static <X> AnnotatedMethod<? super X> findMethod(Set<AnnotatedMethod<? super X>> methods, String methodName, Class<?>[] param) {
        for (AnnotatedMethod<X> annotatedMethod : methods) {
            Method method = annotatedMethod.getJavaMember();
            if (!method.getName().equals(methodName) || !AnnotatedTypeUtil.isMatch(param, method.getParameterTypes())) continue;
            return annotatedMethod;
        }
        return null;
    }

    public static Method findDeclaredMethod(Class<?> cl, Method testMethod) {
        if (cl == null) {
            return null;
        }
        for (Method method : cl.getDeclaredMethods()) {
            if (!AnnotatedTypeUtil.isMatch(method, testMethod)) continue;
            return method;
        }
        return null;
    }

    public static Method findMethod(Method[] methods, Method testMethod) {
        for (Method method : methods) {
            if (!AnnotatedTypeUtil.isMatch(method, testMethod)) continue;
            return method;
        }
        return null;
    }

    public static Method findMethod(Collection<Method> methods, Method testMethod) {
        for (Method method : methods) {
            if (!AnnotatedTypeUtil.isMatch(method, testMethod)) continue;
            return method;
        }
        return null;
    }

    public static boolean isMatch(AnnotatedMethod<?> methodA, AnnotatedMethod<?> methodB) {
        if (methodA == methodB) {
            return true;
        }
        if (methodA == null || methodB == null) {
            return false;
        }
        return AnnotatedTypeUtil.isMatch(methodA.getJavaMember(), methodB.getJavaMember());
    }

    public static boolean isMatch(AnnotatedMethod<?> method, String name, Class<?>[] param) {
        Method javaMethod = method.getJavaMember();
        if (!javaMethod.getName().equals(name)) {
            return false;
        }
        Class<?>[] mparam = javaMethod.getParameterTypes();
        return AnnotatedTypeUtil.isMatch(mparam, param);
    }

    public static boolean isMatch(Method javaMethod, String name, Class<?>[] param) {
        if (!javaMethod.getName().equals(name)) {
            return false;
        }
        Class<?>[] mparam = javaMethod.getParameterTypes();
        return AnnotatedTypeUtil.isMatch(mparam, param);
    }

    public static boolean isMatch(Method methodA, Method methodB) {
        if (!methodA.getName().equals(methodB.getName())) {
            return false;
        }
        return AnnotatedTypeUtil.isMatch(methodA.getParameterTypes(), methodB.getParameterTypes());
    }

    public static boolean isMatch(Class<?>[] paramA, Class<?>[] paramB) {
        if (paramA.length != paramB.length) {
            return false;
        }
        for (int i = paramA.length - 1; i >= 0; --i) {
            if (paramA[i].equals(paramB[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean hasException(AnnotatedMethod<?> method, Class<?> exn) {
        Class<?>[] methodExceptions = method.getJavaMember().getExceptionTypes();
        for (int j = 0; j < methodExceptions.length; ++j) {
            if (!methodExceptions[j].isAssignableFrom(exn)) continue;
            return true;
        }
        return false;
    }
}

