/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.reflect;

import com.caucho.config.inject.InjectManager;
import com.caucho.config.reflect.ArrayType;
import com.caucho.config.reflect.ClassType;
import com.caucho.config.reflect.GenericParamType;
import com.caucho.config.reflect.ObjectType;
import com.caucho.config.reflect.ParamType;
import com.caucho.config.reflect.TargetObjectType;
import com.caucho.config.reflect.VarType;
import com.caucho.config.reflect.WildcardTypeImpl;
import com.caucho.inject.Module;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public abstract class BaseType {
    private static final BaseType[] NULL_PARAM = new BaseType[0];
    private LinkedHashSet<Type> _typeSet;

    public static BaseType createForTarget(Type type, HashMap<String, BaseType> paramMap) {
        return BaseType.create(type, paramMap, true);
    }

    public static BaseType createForSource(Type type, HashMap<String, BaseType> paramMap) {
        return BaseType.create(type, paramMap, false);
    }

    public static BaseType create(Type type, HashMap<String, BaseType> paramMap, boolean isClassFillParamObject) {
        return BaseType.create(type, paramMap, null, isClassFillParamObject);
    }

    public static BaseType create(Type type, HashMap<String, BaseType> paramMap, Type parentType, boolean isClassFillParamObject) {
        if (type instanceof Class) {
            Class cl = (Class)type;
            TypeVariable<Class<T>>[] typeParam = cl.getTypeParameters();
            if (typeParam == null || typeParam.length == 0) {
                return ClassType.create(cl);
            }
            if (!isClassFillParamObject) {
                return BaseType.createClass(cl);
            }
            BaseType[] args = new BaseType[typeParam.length];
            HashMap<String, BaseType> newParamMap = new HashMap<String, BaseType>();
            for (int i = 0; i < args.length; ++i) {
                args[i] = TargetObjectType.OBJECT_TYPE;
                if (args[i] == null) {
                    throw new NullPointerException("unsupported BaseType: " + type);
                }
                newParamMap.put(typeParam[i].getName(), args[i]);
            }
            return new GenericParamType(cl, args, newParamMap);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Class rawType = (Class)pType.getRawType();
            Type[] typeArgs = pType.getActualTypeArguments();
            BaseType[] args = new BaseType[typeArgs.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = BaseType.create(typeArgs[i], paramMap, type, true);
                if (args[i] != null) continue;
                throw new NullPointerException("unsupported BaseType: " + type);
            }
            HashMap<String, BaseType> newParamMap = new HashMap<String, BaseType>();
            TypeVariable<Class<T>>[] typeVars = rawType.getTypeParameters();
            for (int i = 0; i < typeVars.length; ++i) {
                newParamMap.put(typeVars[i].getName(), args[i]);
            }
            return new ParamType(rawType, args, newParamMap);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType aType = (GenericArrayType)type;
            BaseType baseType = BaseType.create(aType.getGenericComponentType(), paramMap, isClassFillParamObject);
            Class<?> rawType = Array.newInstance(baseType.getRawClass(), 0).getClass();
            return new ArrayType(baseType, rawType);
        }
        if (type instanceof TypeVariable) {
            BaseType[] baseBounds;
            TypeVariable aType = (TypeVariable)type;
            BaseType actualType = null;
            if (paramMap != null) {
                actualType = paramMap.get(aType.getName());
            }
            if (actualType != null) {
                return actualType;
            }
            if (aType.getBounds() != null) {
                Type[] bounds = aType.getBounds();
                baseBounds = new BaseType[bounds.length];
                for (int i = 0; i < bounds.length; ++i) {
                    baseBounds[i] = bounds[i] != parentType ? BaseType.create(bounds[i], paramMap, type, true) : ObjectType.OBJECT_TYPE;
                }
            } else {
                baseBounds = new BaseType[]{};
            }
            return new VarType(aType.getName(), baseBounds);
        }
        if (type instanceof WildcardType) {
            WildcardType aType = (WildcardType)type;
            BaseType[] lowerBounds = BaseType.toBaseType(aType.getLowerBounds(), paramMap);
            BaseType[] upperBounds = BaseType.toBaseType(aType.getUpperBounds(), paramMap);
            return new WildcardTypeImpl(lowerBounds, upperBounds);
        }
        throw new IllegalStateException("unsupported BaseType: " + type + " " + (type != null ? type.getClass() : null));
    }

    public static BaseType createClass(Class<?> type) {
        TypeVariable<Class<?>>[] typeParam = type.getTypeParameters();
        if (typeParam == null || typeParam.length == 0) {
            return ClassType.create(type);
        }
        BaseType[] args = new BaseType[typeParam.length];
        HashMap<String, BaseType> newParamMap = new HashMap<String, BaseType>();
        for (int i = 0; i < args.length; ++i) {
            args[i] = BaseType.create(typeParam[i], newParamMap, true);
            if (args[i] == null) {
                throw new NullPointerException("unsupported BaseType: " + type);
            }
            newParamMap.put(typeParam[i].getName(), args[i]);
        }
        return new GenericParamType(type, args, newParamMap);
    }

    private static BaseType[] toBaseType(Type[] types, HashMap<String, BaseType> paramMap) {
        if (types == null) {
            return NULL_PARAM;
        }
        BaseType[] baseTypes = new BaseType[types.length];
        for (int i = 0; i < types.length; ++i) {
            baseTypes[i] = BaseType.create(types[i], paramMap, true);
        }
        return baseTypes;
    }

    public abstract Class<?> getRawClass();

    public HashMap<String, BaseType> getParamMap() {
        return null;
    }

    public BaseType[] getParameters() {
        return NULL_PARAM;
    }

    public boolean isWildcard() {
        return false;
    }

    public boolean isGeneric() {
        return false;
    }

    public boolean isGenericVariable() {
        return this.isVariable();
    }

    public boolean isVariable() {
        return false;
    }

    public boolean isGenericRaw() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    protected BaseType[] getWildcardBounds() {
        return NULL_PARAM;
    }

    public boolean isAssignableFrom(BaseType type) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public boolean isParamAssignableFrom(BaseType type) {
        return this.equals(type);
    }

    public Type toType() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public BaseType fill(BaseType ... baseType) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public final Set<Type> getTypeClosure(InjectManager manager) {
        if (this._typeSet == null) {
            LinkedHashSet<Type> typeSet = new LinkedHashSet<Type>();
            this.fillTypeClosure(manager, typeSet);
            this._typeSet = typeSet;
        }
        return this._typeSet;
    }

    public final Set<BaseType> getBaseTypeClosure(InjectManager manager) {
        LinkedHashSet<BaseType> baseTypeSet = new LinkedHashSet<BaseType>();
        for (Type type : this.getTypeClosure(manager)) {
            baseTypeSet.add(manager.createSourceBaseType(type));
        }
        return baseTypeSet;
    }

    protected void fillTypeClosure(InjectManager manager, Set<Type> typeSet) {
        typeSet.add(this.toType());
    }

    public String getSimpleName() {
        return this.getRawClass().getSimpleName();
    }

    public String toString() {
        return this.getRawClass().getName();
    }
}

