/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.reflect;

import com.caucho.config.reflect.BaseType;
import com.caucho.inject.Module;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class WildcardTypeImpl
extends BaseType
implements WildcardType {
    private BaseType[] _lowerBounds;
    private BaseType[] _upperBounds;

    public WildcardTypeImpl(BaseType[] lowerBounds, BaseType[] upperBounds) {
        this._lowerBounds = lowerBounds;
        this._upperBounds = upperBounds;
    }

    @Override
    public Type[] getLowerBounds() {
        Type[] lowerBounds = new Type[this._lowerBounds.length];
        for (int i = 0; i < lowerBounds.length; ++i) {
            lowerBounds[i] = this._lowerBounds[i].toType();
        }
        return lowerBounds;
    }

    @Override
    public Type[] getUpperBounds() {
        Type[] upperBounds = new Type[this._upperBounds.length];
        for (int i = 0; i < upperBounds.length; ++i) {
            upperBounds[i] = this._upperBounds[i].toType();
        }
        return upperBounds;
    }

    @Override
    public boolean isWildcard() {
        return true;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    protected BaseType[] getWildcardBounds() {
        return this._upperBounds;
    }

    @Override
    public Class<?> getRawClass() {
        return Object.class;
    }

    public Type getGenericComponentType() {
        return null;
    }

    @Override
    public Type toType() {
        return this;
    }

    @Override
    public boolean isAssignableFrom(BaseType type) {
        for (BaseType bound : this._lowerBounds) {
            if (type.isAssignableFrom(bound)) continue;
            return false;
        }
        for (BaseType bound : this._upperBounds) {
            if (bound.isAssignableFrom(type)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isParamAssignableFrom(BaseType type) {
        for (BaseType bound : this._lowerBounds) {
            if (type.isAssignableFrom(bound)) continue;
            return false;
        }
        for (BaseType bound : this._upperBounds) {
            if (bound.isAssignableFrom(type)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return 17;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof WildcardType;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("?");
        for (BaseType type : this._lowerBounds) {
            sb.append(" super ").append(type);
        }
        for (BaseType type : this._upperBounds) {
            sb.append(" extends ").append(type);
        }
        return sb.toString();
    }
}

