/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.scope;

import com.caucho.config.inject.HandleAware;
import com.caucho.config.inject.SingletonHandle;
import com.caucho.config.scope.AbstractScopeContext;
import com.caucho.config.scope.ContextContainer;
import com.caucho.config.scope.DestructionListener;
import com.caucho.inject.Module;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.inject.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class SingletonScope
extends AbstractScopeContext {
    private ContextContainer _context = new ContextContainer();

    public SingletonScope() {
        Environment.addCloseListener(this._context);
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return Singleton.class;
    }

    @Override
    protected ContextContainer getContextContainer() {
        return this._context;
    }

    @Override
    protected ContextContainer createContextContainer() {
        return this._context;
    }

    @Override
    protected <T> T create(Contextual<T> bean, CreationalContext<T> env) {
        T instance = super.create(bean, env);
        if (instance instanceof HandleAware && bean instanceof PassivationCapable) {
            HandleAware handleAware = (HandleAware)instance;
            PassivationCapable passiveBean = (PassivationCapable)bean;
            handleAware.setSerializationHandle(new SingletonHandle(passiveBean.getId()));
        }
        return instance;
    }

    public <T> void addDestructor(Contextual<T> comp, T value) {
        EnvironmentClassLoader loader = Environment.getEnvironmentClassLoader();
        if (loader != null) {
            DestructionListener listener = (DestructionListener)loader.getAttribute("caucho.destroy");
            if (listener == null) {
                listener = new DestructionListener();
                loader.setAttribute("caucho.destroy", listener);
                loader.addListener(listener);
            }
            listener.addValue(comp, value);
        }
    }
}

