/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.timer;

import com.caucho.config.ConfigException;
import com.caucho.config.timer.TimeoutCaller;
import com.caucho.config.timer.TimeoutInvoker;
import com.caucho.util.L10N;
import java.lang.reflect.Method;
import javax.ejb.Timer;

public class MethodTimeoutInvoker
extends TimeoutInvoker {
    private static final L10N L = new L10N(MethodTimeoutInvoker.class);
    private TimeoutCaller _caller;
    private Method _method;
    private boolean _isTimer;

    MethodTimeoutInvoker(TimeoutCaller caller, Method method) {
        this._caller = caller;
        this._method = method;
        Class<?>[] param = method.getParameterTypes();
        if (param.length != 0) {
            if (param.length == 1 && param[0].isAssignableFrom(Timer.class)) {
                this._isTimer = true;
            } else {
                throw new ConfigException(L.l("'{0}' is an invalid schedule method", method));
            }
        }
    }

    public void timeout(Timer timer) {
        try {
            if (this._isTimer) {
                this._caller.timeout(this._method, timer);
            } else {
                this._caller.timeout(this._method);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._method + "]";
    }
}

