/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.ConfigException;
import com.caucho.config.type.ConfigType;
import com.caucho.util.L10N;
import java.lang.reflect.Array;
import java.util.Date;
import java.util.HashMap;

public final class ClassType
extends ConfigType {
    private static final L10N L = new L10N(ClassType.class);
    public static final ClassType TYPE = new ClassType();
    private static final HashMap<String, Class> _primitiveTypes = new HashMap();

    private ClassType() {
    }

    public Class getType() {
        return Class.class;
    }

    public Object valueOf(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        Class type = _primitiveTypes.get(text);
        if (type != null) {
            return type;
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            int bracketIdx = text.indexOf(91);
            if (bracketIdx > 0) {
                String componentTypeName = text.substring(0, bracketIdx);
                Class<?> componentClass = _primitiveTypes.get(componentTypeName);
                if (componentClass == null) {
                    componentClass = Class.forName(componentTypeName, false, loader);
                }
                while (bracketIdx > 0) {
                    componentClass = Array.newInstance(componentClass, 0).getClass();
                    bracketIdx = text.indexOf(91, bracketIdx + 1);
                }
                return componentClass;
            }
            return Class.forName(text, false, loader);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public Object valueOf(Object value) {
        if (value instanceof Class) {
            return value;
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.valueOf((String)value);
        }
        throw new ConfigException(L.l("'{0}' cannot be converted to an Class", value));
    }

    static {
        _primitiveTypes.put("void", Void.TYPE);
        _primitiveTypes.put("boolean", Boolean.TYPE);
        _primitiveTypes.put("char", Character.TYPE);
        _primitiveTypes.put("byte", Byte.TYPE);
        _primitiveTypes.put("short", Short.TYPE);
        _primitiveTypes.put("int", Integer.TYPE);
        _primitiveTypes.put("long", Long.TYPE);
        _primitiveTypes.put("float", Float.TYPE);
        _primitiveTypes.put("double", Double.TYPE);
        _primitiveTypes.put(Boolean.class.getName(), Boolean.class);
        _primitiveTypes.put(Character.class.getName(), Character.class);
        _primitiveTypes.put(Byte.class.getName(), Byte.class);
        _primitiveTypes.put(Short.class.getName(), Short.class);
        _primitiveTypes.put(Integer.class.getName(), Integer.class);
        _primitiveTypes.put(Long.class.getName(), Long.class);
        _primitiveTypes.put(Float.class.getName(), Float.class);
        _primitiveTypes.put(Double.class.getName(), Double.class);
        _primitiveTypes.put(String.class.getName(), String.class);
        _primitiveTypes.put(Class.class.getName(), Class.class);
        _primitiveTypes.put("Boolean", Boolean.class);
        _primitiveTypes.put("Character", Character.class);
        _primitiveTypes.put("Byte", Byte.class);
        _primitiveTypes.put("Short", Short.class);
        _primitiveTypes.put("Integer", Integer.class);
        _primitiveTypes.put("Long", Long.class);
        _primitiveTypes.put("Float", Float.class);
        _primitiveTypes.put("Double", Double.class);
        _primitiveTypes.put("String", String.class);
        _primitiveTypes.put("Date", Date.class);
        _primitiveTypes.put("Class", Class.class);
    }
}

