/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.ConfigException;
import com.caucho.config.type.ConfigType;
import com.caucho.util.L10N;
import java.util.HashMap;
import java.util.Locale;

public final class LocaleType
extends ConfigType {
    private static final L10N L = new L10N(LocaleType.class);
    public static final LocaleType TYPE = new LocaleType();
    private final HashMap<String, Locale> _localeMap = new HashMap();

    private LocaleType() {
    }

    public Class getType() {
        return Locale.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object valueOf(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        HashMap<String, Locale> hashMap = this._localeMap;
        synchronized (hashMap) {
            Locale locale = this._localeMap.get(text);
            if (locale == null) {
                String[] values = text.split("[-_]");
                if (values.length == 1) {
                    locale = new Locale(values[0]);
                } else if (values.length == 2) {
                    locale = new Locale(values[0], values[1]);
                } else if (values.length == 3) {
                    locale = new Locale(values[0], values[1], values[2]);
                } else {
                    throw new ConfigException(L.l("'{0}' is an invalid Locale", text));
                }
                this._localeMap.put(text, locale);
            }
            return locale;
        }
    }

    public Object valueOf(Object value) {
        if (value instanceof Locale) {
            return value;
        }
        if (value == null) {
            return null;
        }
        return this.valueOf(String.valueOf(value));
    }
}

