/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.Config;
import com.caucho.config.type.ConfigType;
import com.caucho.el.ELParser;
import com.caucho.el.Expr;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import javax.el.ELContext;
import javax.el.ELException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathType
extends ConfigType<Path> {
    private static final L10N L = new L10N(PathType.class);
    public static final PathType TYPE = new PathType();

    private PathType() {
    }

    @Override
    public Class<Path> getType() {
        return Path.class;
    }

    @Override
    public Object valueOf(String text) {
        return PathType.lookupPath(text);
    }

    @Override
    public Object valueOf(Object value) {
        if (value instanceof Path) {
            return value;
        }
        if (value instanceof String) {
            return this.valueOf((String)value);
        }
        if (value == null) {
            return null;
        }
        return this.valueOf(String.valueOf(value));
    }

    public static Path lookupPath(String string) throws ELException {
        return PathType.lookupPath(string, Config.getEnvironment(), Vfs.lookup());
    }

    public static Path lookupPath(String string, ELContext env) throws ELException {
        return PathType.lookupPath(string, env, Vfs.lookup());
    }

    public static Path lookupPath(String string, ELContext env, Path pwd) throws ELException {
        Expr expr;
        Object obj;
        if (env == null) {
            env = Config.getEnvironment();
        }
        if ((obj = (expr = new ELParser(env, string = PathType.rewritePathString(string)).parse()).evalObject(env)) == null) {
            throw new NullPointerException(L.l("Path '{0}' evaluated to null.", string));
        }
        if (obj instanceof Path) {
            return (Path)obj;
        }
        String value = Expr.toString(obj, env);
        if (pwd != null) {
            return pwd.lookup(value);
        }
        return Vfs.lookup(value);
    }

    public static String rewritePathString(String pathName) {
        if (pathName == null) {
            return ".";
        }
        StringBuilder cb = new StringBuilder();
        int length = pathName.length();
        for (int i = 0; i < length; ++i) {
            char ch = pathName.charAt(i);
            if (ch != '$') {
                cb.append(ch);
                continue;
            }
            if (i + 1 == length) {
                cb.append('$');
                continue;
            }
            ch = pathName.charAt(i + 1);
            if ('0' <= ch && ch <= '9') {
                int value = 0;
                ++i;
                while (i < length && (ch = pathName.charAt(i)) >= '0' && ch <= '9') {
                    value = 10 * value + ch - 48;
                    ++i;
                }
                --i;
                cb.append("${regexp[" + value + "]}");
                continue;
            }
            if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z') {
                int tail;
                for (tail = i + 1; tail < length && (ch = pathName.charAt(tail)) != '/' && ch != '\\' && ch != '$'; ++tail) {
                }
                cb.append("${" + pathName.substring(i + 1, tail) + "}");
                i = tail - 1;
                continue;
            }
            cb.append('$');
        }
        return cb.toString();
    }
}

