/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.attribute.EnvironmentAttribute;
import com.caucho.config.attribute.FlowAttribute;
import com.caucho.config.attribute.ListValueAttribute;
import com.caucho.config.attribute.SetValueAttribute;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.program.PropertyStringProgram;
import com.caucho.config.type.AbstractBeanType;
import com.caucho.config.type.AnnotationInterfaceType;
import com.caucho.config.type.ArrayType;
import com.caucho.config.type.BooleanPrimitiveType;
import com.caucho.config.type.BooleanType;
import com.caucho.config.type.BytePrimitiveType;
import com.caucho.config.type.ByteType;
import com.caucho.config.type.CharacterPrimitiveType;
import com.caucho.config.type.CharacterType;
import com.caucho.config.type.ClassType;
import com.caucho.config.type.ConfigProgramType;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.DateType;
import com.caucho.config.type.DoublePrimitiveType;
import com.caucho.config.type.DoubleType;
import com.caucho.config.type.EnumType;
import com.caucho.config.type.EnvironmentBeanType;
import com.caucho.config.type.ExprType;
import com.caucho.config.type.FileType;
import com.caucho.config.type.FloatPrimitiveType;
import com.caucho.config.type.FloatType;
import com.caucho.config.type.FlowBean;
import com.caucho.config.type.FlowBeanType;
import com.caucho.config.type.InlineBeanType;
import com.caucho.config.type.IntegerPrimitiveType;
import com.caucho.config.type.IntegerType;
import com.caucho.config.type.InterfaceType;
import com.caucho.config.type.LevelBuilder;
import com.caucho.config.type.ListType;
import com.caucho.config.type.LocaleType;
import com.caucho.config.type.LongPrimitiveType;
import com.caucho.config.type.LongType;
import com.caucho.config.type.MapType;
import com.caucho.config.type.MethodExpressionType;
import com.caucho.config.type.NodeType;
import com.caucho.config.type.NotFoundConfigType;
import com.caucho.config.type.ObjectType;
import com.caucho.config.type.PathType;
import com.caucho.config.type.PatternType;
import com.caucho.config.type.PropertiesType;
import com.caucho.config.type.PropertyEditorType;
import com.caucho.config.type.QDateType;
import com.caucho.config.type.RawStringType;
import com.caucho.config.type.SetType;
import com.caucho.config.type.ShortPrimitiveType;
import com.caucho.config.type.ShortType;
import com.caucho.config.type.StringArrayType;
import com.caucho.config.type.StringType;
import com.caucho.config.type.UrlType;
import com.caucho.config.types.AnnotationConfig;
import com.caucho.config.types.RawString;
import com.caucho.config.xml.XmlBeanConfig;
import com.caucho.config.xml.XmlBeanType;
import com.caucho.el.Expr;
import com.caucho.loader.AddLoaderListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.xml.QName;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.el.MethodExpression;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeFactory
implements AddLoaderListener {
    private static final Logger log = Logger.getLogger(TypeFactory.class.getName());
    private static L10N L = new L10N(TypeFactory.class);
    private static final String RESIN_NS = "http://caucho.com/ns/resin";
    private static final HashMap<Class<?>, ConfigType<?>> _primitiveTypes = new HashMap();
    private static final EnvironmentLocal<TypeFactory> _localFactory = new EnvironmentLocal();
    private static final ClassLoader _systemClassLoader;
    private static final Object _introspectLock;
    private final EnvironmentClassLoader _loader;
    private final TypeFactory _parent;
    private final HashSet<URL> _configSet = new HashSet();
    private final HashMap<String, ArrayList<String>> _packageImportMap = new HashMap();
    private final HashMap<String, ConfigType> _typeMap = new HashMap();
    private final HashMap<String, XmlBeanType> _customBeanMap = new HashMap();
    private final ConcurrentHashMap<QName, ConfigType> _attrMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<QName, Class<?>> _customClassMap = new ConcurrentHashMap();
    private final HashMap<QName, Attribute> _listAttrMap = new HashMap();
    private final HashMap<QName, Attribute> _setAttrMap = new HashMap();
    private final ConcurrentHashMap<QName, Attribute> _envAttrMap = new ConcurrentHashMap();
    private final HashMap<String, NamespaceConfig> _nsMap = new HashMap();
    private final HashSet<URL> _driverTypeSet = new HashSet();
    private final HashMap<String, HashMap<String, String>> _driverTypeMap = new HashMap();
    private final AtomicBoolean _isInInit = new AtomicBoolean();

    private TypeFactory(ClassLoader loader) {
        this._loader = Environment.getEnvironmentClassLoader(loader);
        _localFactory.set(this, loader);
        if (this._loader != null) {
            this._parent = TypeFactory.getFactory(this._loader.getParent());
            this._loader.addLoaderListener(this);
        } else {
            this._parent = null;
        }
        this.init(loader);
    }

    public static ConfigType<?> getType(Object bean) {
        if (bean instanceof XmlBeanConfig) {
            return ((XmlBeanConfig)bean).getConfigType();
        }
        if (bean instanceof AnnotationConfig) {
            return ((AnnotationConfig)bean).getConfigType();
        }
        return TypeFactory.getType(bean.getClass());
    }

    public static <T> ConfigType<T> getType(Class<T> type) {
        TypeFactory factory = TypeFactory.getFactory(type.getClassLoader());
        return factory.getConfigTypeImpl(type);
    }

    public static ConfigType<?> getType(Type type) {
        return TypeFactory.getType((Class)type);
    }

    public static Class<?> loadClass(QName qName) {
        return TypeFactory.getFactory().loadClassImpl(qName);
    }

    public static Class<?> loadClass(String pkg, String name) {
        return TypeFactory.getFactory().loadClassImpl(pkg, name);
    }

    public static TypeFactory create() {
        return TypeFactory.getFactory();
    }

    public static TypeFactory getFactory() {
        return TypeFactory.getFactory(Thread.currentThread().getContextClassLoader());
    }

    public static TypeFactory getFactory(ClassLoader loader) {
        TypeFactory factory;
        if (loader == null) {
            loader = _systemClassLoader;
        }
        if ((factory = _localFactory.getLevel(loader)) == null) {
            factory = new TypeFactory(loader);
            _localFactory.set(factory, loader);
            factory.init(loader);
        }
        return factory;
    }

    public ConfigType<?> getEnvironmentType(QName name) {
        ConfigType type = this._attrMap.get(name);
        if (type != null) {
            return type == NotFoundConfigType.NULL ? null : type;
        }
        type = this.getEnvironmentTypeRec(name);
        if (type != null) {
            return type;
        }
        if (!"".equals(name.getNamespaceURI()) && (type = this.getEnvironmentType(new QName(name.getLocalName()))) != null) {
            this._attrMap.put(name, type);
            return type;
        }
        this._attrMap.put(name, NotFoundConfigType.NULL);
        return null;
    }

    protected ConfigType getEnvironmentTypeRec(QName name) {
        String className;
        String pkg;
        Class<?> cl;
        ConfigType<?> type = this._attrMap.get(name);
        if (type != null) {
            return type == NotFoundConfigType.NULL ? null : type;
        }
        if (this._parent != null) {
            type = this._parent.getEnvironmentTypeRec(name);
        }
        if (type != null) {
            this._attrMap.put(name, type);
            return type;
        }
        String uri = name.getNamespaceURI();
        NamespaceConfig ns = this._nsMap.get(uri);
        if (ns != null) {
            ns.loadBeans();
            type = ns.getBean(name.getLocalName());
            if (type != null) {
                this._attrMap.put(name, type);
                return type;
            }
        }
        if (RESIN_NS.equals(uri)) {
            uri = "urn:java:ee";
        }
        if (uri != null && uri.startsWith("urn:java:") && (cl = this.loadClassImpl(pkg = uri.substring("urn:java:".length()), className = name.getLocalName())) != null) {
            type = TypeFactory.getType(cl);
            this._attrMap.put(name, type);
            return type;
        }
        this._attrMap.put(name, NotFoundConfigType.NULL);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attribute getListAttribute(QName name) {
        HashMap<QName, Attribute> hashMap = this._listAttrMap;
        synchronized (hashMap) {
            Attribute attr = this._listAttrMap.get(name);
            if (attr != null) {
                return attr;
            }
            ConfigType<?> type = this.getEnvironmentType(name);
            if (type == null) {
                return null;
            }
            attr = new ListValueAttribute(type);
            this._listAttrMap.put(name, attr);
            return attr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attribute getSetAttribute(QName name) {
        HashMap<QName, Attribute> hashMap = this._setAttrMap;
        synchronized (hashMap) {
            Attribute attr = this._setAttrMap.get(name);
            if (attr != null) {
                return attr;
            }
            ConfigType<?> type = this.getEnvironmentType(name);
            if (type == null) {
                return null;
            }
            attr = new SetValueAttribute(type);
            this._setAttrMap.put(name, attr);
            return attr;
        }
    }

    public Attribute getEnvironmentAttribute(QName name) {
        EnvironmentAttribute attr = this._envAttrMap.get(name);
        if (attr != null) {
            return attr;
        }
        ConfigType<?> type = this.getEnvironmentType(name);
        if (type == null) {
            return null;
        }
        attr = type instanceof FlowBeanType ? new FlowAttribute((ConfigType)type) : new EnvironmentAttribute(type);
        this._envAttrMap.put(name, attr);
        return attr;
    }

    private Class<?> loadClassImpl(QName qName) {
        Class<?> cl = this._customClassMap.get(qName);
        if (cl != null) {
            return cl == Void.TYPE ? null : cl;
        }
        String uri = qName.getNamespaceURI();
        String localName = qName.getLocalName();
        if (!uri.startsWith("urn:java:")) {
            throw new IllegalStateException(L.l("'{0}' is an unexpected namespace, expected 'urn:java:...'", uri));
        }
        String packageName = uri.substring("uri:java:".length());
        cl = this.loadClassImpl(packageName, localName);
        if (cl != null) {
            this._customClassMap.put(qName, cl);
        } else {
            this._customClassMap.put(qName, Void.TYPE);
        }
        return cl;
    }

    private Class<?> loadClassImpl(String pkg, String name) {
        ClassLoader loader = this._loader;
        if (this._loader == null) {
            loader = _systemClassLoader;
        }
        ArrayList<String> pkgList = this.loadPackageList(pkg);
        DynamicClassLoader dynLoader = null;
        if (loader instanceof DynamicClassLoader) {
            dynLoader = loader;
        }
        for (String pkgName : pkgList) {
            try {
                Class<?> cl = dynLoader != null ? dynLoader.loadClassImpl(pkgName + '.' + name, false) : Class.forName(pkgName + '.' + name, false, loader);
                if (cl == null) continue;
                return cl;
            }
            catch (ClassNotFoundException e) {
                log.log(Level.ALL, e.toString(), e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList<String> loadPackageList(String pkg) {
        HashMap<String, ArrayList<String>> hashMap = this._packageImportMap;
        synchronized (hashMap) {
            ArrayList<String> pkgList;
            block12: {
                pkgList = this._packageImportMap.get(pkg);
                if (pkgList != null) {
                    return pkgList;
                }
                pkgList = new ArrayList();
                pkgList.add(pkg);
                InputStream is = null;
                try {
                    try {
                        ClassLoader loader = this._loader;
                        if (loader == null) {
                            loader = _systemClassLoader;
                        }
                        if ((is = ((ClassLoader)loader).getResourceAsStream(pkg.replace('.', '/') + "/namespace")) != null) {
                            String line;
                            ReadStream in = Vfs.openRead(is);
                            while ((line = in.readLine()) != null) {
                                for (String name : line.split("[ \t\r\n]+")) {
                                    if ("".equals(name) || pkgList.contains(name)) continue;
                                    pkgList.add(name);
                                }
                            }
                        }
                        Object var13_13 = null;
                    }
                    catch (IOException e) {
                        log.log(Level.FINE, e.toString(), e);
                        Object var13_14 = null;
                        IoUtil.close(is);
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    IoUtil.close(is);
                    throw throwable;
                }
                IoUtil.close(is);
            }
            this._packageImportMap.put(pkg, pkgList);
            return pkgList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigType getConfigTypeImpl(Class type) {
        Object object = _introspectLock;
        synchronized (object) {
            ConfigType strategy = this._typeMap.get(type.getName());
            if (strategy == null) {
                strategy = _primitiveTypes.get(type);
                if (strategy == null) {
                    strategy = this.createType(type);
                }
                this._typeMap.put(type.getName(), strategy);
                strategy.introspect();
            }
            return strategy;
        }
    }

    private ConfigType createType(Class<?> type) {
        PropertyEditor editor = null;
        if (ConfigType.class.isAssignableFrom(type)) {
            try {
                return (ConfigType)type.newInstance();
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
        }
        editor = TypeFactory.findEditor(type);
        if (editor != null) {
            return new PropertyEditorType(type, editor);
        }
        if (type.getEnumConstants() != null) {
            return new EnumType(type);
        }
        if (Set.class.isAssignableFrom(type)) {
            return new SetType(type);
        }
        if (Collection.class.isAssignableFrom(type) && !Queue.class.isAssignableFrom(type)) {
            return new ListType(type);
        }
        if (Map.class.isAssignableFrom(type) && type.getName().startsWith("java.util")) {
            return new MapType(type);
        }
        if (EnvironmentBean.class.isAssignableFrom(type)) {
            return new EnvironmentBeanType((Class)type);
        }
        if (FlowBean.class.isAssignableFrom(type)) {
            return new FlowBeanType((Class)type);
        }
        if (type.isArray()) {
            Class<?> compType = type.getComponentType();
            return new ArrayType(TypeFactory.getType(compType), compType);
        }
        if (Annotation.class.isAssignableFrom(type)) {
            return new AnnotationInterfaceType(type);
        }
        if (type.isInterface()) {
            return new InterfaceType(type);
        }
        if (type == ConfigProgram.class) {
            return new ConfigProgramType(type);
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            return new AbstractBeanType((Class)type);
        }
        return new InlineBeanType(type);
    }

    private static PropertyEditor findEditor(Class<?> type) {
        if (type.getName().startsWith("com.caucho")) {
            return null;
        }
        return PropertyEditorManager.findEditor(type);
    }

    public static <T> XmlBeanType<T> getCustomBeanType(Class<T> type) {
        TypeFactory factory = TypeFactory.getFactory(type.getClassLoader());
        return factory.getCustomBeanTypeImpl(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> XmlBeanType<T> getCustomBeanTypeImpl(Class<T> type) {
        HashMap<String, XmlBeanType> hashMap = this._customBeanMap;
        synchronized (hashMap) {
            XmlBeanType<T> beanType = this._customBeanMap.get(type.getName());
            if (beanType == null) {
                beanType = new XmlBeanType<T>(type);
                this._customBeanMap.put(type.getName(), beanType);
            }
            return beanType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(ClassLoader loader) {
        if (!this._isInInit.getAndSet(true)) {
            return;
        }
        try {
            try {
                this._nsMap.clear();
                this._driverTypeSet.clear();
                this._driverTypeMap.clear();
                Enumeration<URL> urls = loader.getResources("META-INF/caucho/com.caucho.config.namespace.xml");
                while (urls.hasMoreElements()) {
                    Object var6_7;
                    URL url = urls.nextElement();
                    if (this.hasConfig(url)) continue;
                    this._configSet.add(url);
                    InputStream is = url.openStream();
                    try {
                        new Config(loader).configure((Object)this, is);
                        var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        var6_7 = null;
                        is.close();
                        throw throwable;
                    }
                    is.close();
                    {
                    }
                }
                Object var8_9 = null;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
            this._isInInit.set(false);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this._isInInit.set(false);
            throw throwable;
        }
    }

    protected boolean hasConfig(URL url) {
        if (this._configSet.contains(url)) {
            return true;
        }
        if (this._parent != null) {
            return this._parent.hasConfig(url);
        }
        return false;
    }

    public Class getDriverClassByUrl(Class api, String url) {
        int p = url.indexOf(58);
        String scheme = p >= 0 ? url.substring(0, p) : url;
        String typeName = this.getDriverType(api.getName(), scheme);
        if (typeName == null) {
            ArrayList<String> schemes = new ArrayList<String>();
            this.getDriverSchemes(schemes, api.getName());
            Collections.sort(schemes);
            throw new ConfigException(L.l("'{0}' is an unknown scheme for driver '{1}'.  The available schemes are '{2}'", scheme, api.getName(), schemes));
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cl = Class.forName(typeName, false, loader);
            if (!api.isAssignableFrom(cl)) {
                throw new ConfigException(L.l("'{0}' is not assignable to '{1}' for scheme '{2}'", cl.getName(), api.getName(), scheme));
            }
            return cl;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigException(L.l("'{0}' is an undefined class for scheme '{1}'", (Object)typeName, scheme), e);
        }
    }

    public Class getDriverClassByScheme(Class api, String scheme) {
        String typeName = this.getDriverType(api.getName(), scheme);
        if (typeName == null) {
            ArrayList<String> schemes = new ArrayList<String>();
            this.getDriverSchemes(schemes, api.getName());
            Collections.sort(schemes);
            throw new ConfigException(L.l("'{0}' is an unknown scheme for driver '{1}'.  The available schemes are '{2}'", scheme, api.getName(), schemes));
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cl = Class.forName(typeName, false, loader);
            if (!api.isAssignableFrom(cl)) {
                throw new ConfigException(L.l("'{0}' is not assignable to '{1}' for scheme '{2}'", cl.getName(), api.getName(), scheme));
            }
            return cl;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigException(L.l("'{0}' is an undefined class for scheme '{1}'", (Object)typeName, scheme), e);
        }
    }

    public ContainerProgram getUrlProgram(String url) {
        String properties = "";
        int p = url.indexOf(58);
        if (p < 0) {
            return null;
        }
        properties = url.substring(p + 1);
        String[] props = properties.split("[;]");
        if (props.length == 0) {
            return null;
        }
        ContainerProgram program = new ContainerProgram();
        for (String prop : props) {
            if (prop.length() == 0) continue;
            String[] values = prop.split("[=]");
            if (values.length != 2) {
                throw new ConfigException(L.l("'{0}' is an invalid URL.  Bean URL syntax is 'scheme:prop1=value1;prop2=value2'", url));
            }
            program.addProgram(new PropertyStringProgram(values[0], values[1]));
        }
        return program;
    }

    public String getDriverType(String apiType, String scheme) {
        HashMap<String, String> driverMap = this.getDriverTypeMap(apiType);
        return driverMap.get(scheme);
    }

    public void getDriverSchemes(ArrayList<String> schemes, String apiType) {
        HashMap<String, String> driverMap = this.getDriverTypeMap(apiType);
        ClassLoader loader = this._loader;
        if (this._loader == null) {
            loader = _systemClassLoader;
        }
        for (Map.Entry<String, String> entry : driverMap.entrySet()) {
            String scheme = entry.getKey();
            String type = entry.getValue();
            try {
                Class<?> cl = Class.forName(type, false, loader);
                if (cl == null) continue;
                schemes.add(scheme);
            }
            catch (Exception e) {
                log.finest(apiType + " schemes: " + e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, String> getDriverTypeMap(String apiType) {
        HashMap<String, HashMap<String, String>> hashMap = this._driverTypeMap;
        synchronized (hashMap) {
            HashMap<String, String> driverMap = this._driverTypeMap.get(apiType);
            if (driverMap == null) {
                driverMap = new HashMap();
                if (this._parent != null) {
                    driverMap.putAll(this._parent.getDriverTypeMap(apiType));
                }
                this.loadDriverTypeMap(driverMap, apiType);
                this._driverTypeMap.put(apiType, driverMap);
            }
            return driverMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadDriverTypeMap(HashMap<String, String> driverMap, String apiType) {
        try {
            ClassLoader loader = this._loader;
            if (loader == null) {
                loader = _systemClassLoader;
            }
            Enumeration<URL> urls = loader.getResources("META-INF/caucho/com.caucho.config.uri/" + apiType);
            while (urls.hasMoreElements()) {
                Object var11_11;
                URL url = urls.nextElement();
                if (this.hasDriver(url)) continue;
                this._driverTypeSet.add(url);
                InputStream is = url.openStream();
                try {
                    Properties props = new Properties();
                    props.load(is);
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        driverMap.put((String)entry.getKey(), (String)entry.getValue());
                    }
                    var11_11 = null;
                }
                catch (Throwable throwable) {
                    var11_11 = null;
                    is.close();
                    throw throwable;
                    return;
                }
                is.close();
                {
                }
            }
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasDriver(URL url) {
        HashSet<URL> hashSet = this._driverTypeSet;
        synchronized (hashSet) {
            if (this._driverTypeSet.contains(url)) {
                return true;
            }
            if (this._parent != null) {
                return this._parent.hasDriver(url);
            }
            return false;
        }
    }

    @Override
    public boolean isEnhancer() {
        return false;
    }

    @Override
    public void addLoader(EnvironmentClassLoader loader) {
        this.init(loader);
    }

    public NamespaceConfig createNamespace() {
        return new NamespaceConfig();
    }

    public void addNamespace(NamespaceConfig ns) {
        this._nsMap.put(ns.getName(), ns);
        if (ns.isDefault()) {
            this._nsMap.put(ns.getName(), ns);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._loader + "]";
    }

    static {
        _introspectLock = new Object();
        _primitiveTypes.put(Boolean.TYPE, BooleanPrimitiveType.TYPE);
        _primitiveTypes.put(Byte.TYPE, BytePrimitiveType.TYPE);
        _primitiveTypes.put(Short.TYPE, ShortPrimitiveType.TYPE);
        _primitiveTypes.put(Integer.TYPE, IntegerPrimitiveType.TYPE);
        _primitiveTypes.put(Long.TYPE, LongPrimitiveType.TYPE);
        _primitiveTypes.put(Float.TYPE, FloatPrimitiveType.TYPE);
        _primitiveTypes.put(Double.TYPE, DoublePrimitiveType.TYPE);
        _primitiveTypes.put(Character.TYPE, CharacterPrimitiveType.TYPE);
        _primitiveTypes.put(Boolean.class, BooleanType.TYPE);
        _primitiveTypes.put(Byte.class, ByteType.TYPE);
        _primitiveTypes.put(Short.class, ShortType.TYPE);
        _primitiveTypes.put(Integer.class, IntegerType.TYPE);
        _primitiveTypes.put(Long.class, LongType.TYPE);
        _primitiveTypes.put(Float.class, FloatType.TYPE);
        _primitiveTypes.put(Double.class, DoubleType.TYPE);
        _primitiveTypes.put(Character.class, CharacterType.TYPE);
        _primitiveTypes.put(Object.class, ObjectType.TYPE);
        _primitiveTypes.put(String.class, StringType.TYPE);
        _primitiveTypes.put(RawString.class, RawStringType.TYPE);
        _primitiveTypes.put(String[].class, StringArrayType.TYPE);
        _primitiveTypes.put(Class.class, ClassType.TYPE);
        _primitiveTypes.put(Path.class, PathType.TYPE);
        _primitiveTypes.put(File.class, FileType.TYPE);
        _primitiveTypes.put(URL.class, UrlType.TYPE);
        _primitiveTypes.put(Pattern.class, PatternType.TYPE);
        _primitiveTypes.put(Level.class, LevelBuilder.TYPE);
        _primitiveTypes.put(Locale.class, LocaleType.TYPE);
        _primitiveTypes.put(Node.class, NodeType.TYPE);
        _primitiveTypes.put(QDate.class, QDateType.TYPE);
        _primitiveTypes.put(Date.class, DateType.TYPE);
        _primitiveTypes.put(Properties.class, PropertiesType.TYPE);
        _primitiveTypes.put(Expr.class, ExprType.TYPE);
        _primitiveTypes.put(MethodExpression.class, MethodExpressionType.TYPE);
        ClassLoader systemClassLoader = null;
        try {
            systemClassLoader = ClassLoader.getSystemClassLoader();
        }
        catch (Exception exception) {
            // empty catch block
        }
        _systemClassLoader = systemClassLoader;
    }

    public class FlowConfig
    extends BeanConfig {
        FlowConfig(String ns, boolean isDefault) {
            super(ns, isDefault);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BeanConfig {
        private String _ns;
        private boolean _isDefault;
        private String _name;
        private String _className;
        private ConfigType<?> _configType;
        private ClassLoader _loader;

        BeanConfig(String ns, boolean isDefault) {
            this._ns = ns;
            this._isDefault = isDefault;
            this._loader = Thread.currentThread().getContextClassLoader();
        }

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setClass(String className) {
            this._className = className;
        }

        public ConfigType<?> getConfigType() {
            try {
                if (this._configType == null) {
                    Class<?> cl = Class.forName(this._className, false, this._loader);
                    ConfigType type = TypeFactory.this.createType(cl);
                    type.introspect();
                    this._configType = type;
                }
                return this._configType;
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
        }

        @PostConstruct
        public void init() {
            if (this._name == null) {
                throw new ConfigException(L.l("bean requires a 'name' attribute"));
            }
            if (this._className == null) {
                throw new ConfigException(L.l("bean requires a 'class' attribute"));
            }
        }
    }

    public class NamespaceConfig {
        private String _ns = "";
        private boolean _isDefault;
        private Path _path;
        private AtomicBoolean _isBeansLoaded = new AtomicBoolean();
        private HashMap<String, BeanConfig> _beanMap = new HashMap();

        public void setName(String ns) {
            if ("default".equals(ns)) {
                ns = "";
            }
            this._ns = ns;
        }

        public String getName() {
            return this._ns;
        }

        public void setDefault(boolean isDefault) {
            this._isDefault = isDefault;
        }

        public boolean isDefault() {
            return this._isDefault;
        }

        public void setPath(String path) {
            this._path = path.indexOf(58) < 0 ? Vfs.lookup("classpath:" + path) : Vfs.lookup(path);
        }

        public Path getPath() {
            return this._path;
        }

        public void loadBeans() {
            if (this._isBeansLoaded.getAndSet(true)) {
                return;
            }
            try {
                new Config().configure((Object)this, this._path);
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }

        public ConfigType getBean(String name) {
            BeanConfig beanConfig = this._beanMap.get(name);
            if (beanConfig != null) {
                return beanConfig.getConfigType();
            }
            return null;
        }

        public BeanConfig createBean() {
            return new BeanConfig(this._ns, this._isDefault);
        }

        public void addBean(BeanConfig bean) {
            this._beanMap.put(bean.getName(), bean);
        }

        public FlowConfig createFlow() {
            return new FlowConfig(this._ns, this._isDefault);
        }

        public void addFlow(FlowConfig flow) {
            this._beanMap.put(flow.getName(), flow);
        }
    }
}

